<?php
require_once "JetPlugin.class.php";

/**
 * Excelɥ󥯽<br>
 * ơ֥ƤExcelեȤƽϤ뤿Υץ饰
 *
 * @package    jettable.framework
 * @author     rds <tk@rasign.jp>
 * @license     http://www.opensource.org/licenses/mit-license.php The MIT License
 * @version    $Revision: 1.2 $ $Date: 2006/11/30 13:54:29 $
 * @link       http://jettable.rasign.jp/
 */
class JetExcelDownload extends JetPlugin{
	public function __construct(){
		$this->key = "excel";
	}

	public function action($header, $records){
		require_once "Spreadsheet\Excel\Writer.php";

		$workbook = new Spreadsheet_Excel_Writer();
		$worksheet =& $workbook->addWorksheet("list");
		$format =& $workbook->addFormat();
		$format->_font_name = mb_convert_encoding("sjis", "sjis");

		$i = 0;
		foreach($header as $headerKey=>$headerValue){
			$worksheet->write(0, $i, mb_convert_encoding($headerValue, "sjis", "euc-jp"));
			$i++;
		}

		$i = 1;
		foreach($records as $record){
			$j = 0;
			foreach($header as $headerKey=>$headerValue){
				$worksheet->write($i, $j, mb_convert_encoding($record[$headerKey], "sjis", "euc-jp"));
				$j++;
			}
			$i++;
		}

		$workbook->send("list.xls");
		$workbook->close();

		die();
	}
}
?>