<?php
require_once "PHPUnit.php";
require_once "../TableUtility.php";

class AttributeColumnTest extends PHPUnit_TestCase {

    public function __construct($name = false)
    {
        $this->PHPUnit_TestCase($name);
    }

    function setUp()
    {
    }

    function tearDown()
    {
    }

    function testNew()
    {
    	$attribute = new AttributeColumn();
    	$this->assertNull($attribute->key);
    	$this->assertNull($attribute->value);
    	$this->assertNull($attribute->columnName);
    }

    function testProperties()
    {
    	$attribute = new AttributeColumn();
    	$attribute->key = "keyString";
    	$attribute->value = "valueString";
    	$attribute->columnName = "columnNameString";
    	
    	$this->assertTrue($attribute->key, "keyString");
    	$this->assertTrue($attribute->value, "valueString");
    	$this->assertTrue($attribute->columnName, "columnNameString");
    }
}

$suite  = new PHPUnit_TestSuite("AttributeColumnTest");
$result = PHPUnit::run($suite);
echo $result->toHtml();
?>
