<?php
/**
 * ơ֥ϥ饹<br>
 * ơ֥ϤΤΥᥤ󥯥饹
 *
 * @package    jettable.framework
 * @author     rds <tk@rasign.jp>
 * @license     http://www.opensource.org/licenses/mit-license.php The MIT License
 * @version    Release: 0.0.0
 * @link       http://jettable.rasign.jp/
 */
class Table{
	private $header;
	private $records;
	private $attribute;
	private $attributeRow;
	private $attributeColumn;
	private $attributeHeaderRow;
	private $attributeHeaderColumn;
	private $attributeColumnEreg;
	private $attributeRowEreg;

	private $margeHeaderColumn;
	private $margeColumnRow;

	private $attributeColumnAll;
	private $attributeHeaderColumnAll;

	private $useSort;
	private $sortKey;
	private $sortType;
	private $sortableHeaderKeys;

	private $usePager;
	private $pager;

	private $usePlugin;

	private $scriptName;

	private $plugin;

	private $parameterPageString = "page";
	private $parameterPageParString = "pagePar";
	private $parameterSortKeyString = "sortKey";
	private $parameterSortTypeString = "sortType";
	private $parameterSortTypeAsc = "asc";
	private $parameterSortTypeDesc = "desc";
	private $sortTypeAscMarkString = "";
	private $sortTypeDescMarkString = "";
	private $rowidName = "rowidentifier";

	private $roundBackgroundColors;
	
	public $rowspan;
	
    /**
     * ǥեȥ󥹥ȥ饯<br>
     * ѿνԤޤ<br>
     *
     * @access public
     */
	public function __construct(){
		$this->header = array();
		$this->records = array();
		$this->attribute = array();
		$this->attributeRow = array();
		$this->attributeColumn = array();
		$this->attributeColumnAll = array();
		$this->attributeHeaderRow = array();
		$this->attributeHeaderColumn = array();
		$this->attributeHeaderColumnAll = array();
		$this->attributeColumnEreg = array();
		$this->attributeRowEreg = array();
		$this->sortableHeaderKeys = array();
		$this->plugin = array();
		$this->margeHeaderColumn = array();
		$this->margeColumnRow = array();
		$this->roundBackgroundColors = array();

		$this->useSort = false;
		$this->usePager = false;
		$this->usePlugin = false;

 		$this->scriptName = "";

		$this->pager = new Pager();
		
		$this->rowspan = 0;
		
	}

    /**
     * ơ֥Ф°ɲ<br>
     * TableФ°ɲäޤ<br>
     *
     * @param $key °ΥȤʤʸ
     * @param $value °
     * @access public
     */
	public function appendAttribute($key, $value){
		$attribute = new Attribute();
		$attribute->key = $key;
		$attribute->value = $value;
		$this->attribute[] = $attribute;
	}

    /**
     * إåԤФ°ɲ<br>
     * إåTRФ°ɲäޤ<br>
     *
     * @param $key °ΥȤʤʸ
     * @param $value °
     * @access public
     */
	public function appendAttributeHeaderRow($key, $value){
		$attributeHeaderRow = new Attribute();
		$attributeHeaderRow->key = $key;
		$attributeHeaderRow->value = $value;
		$this->attributeHeaderRow[] = $attributeHeaderRow;
	}

    /**
     * إåΥǡФ°ɲ<br>
     * إåTDФ°ɲäޤ<br>
     *
     * @param $columnName °Ϳ̾
     * @param $key °ΥȤʤʸ
     * @param $value °
     * @access public
     */
	public function appendAttributeHeaderColumn($columnName, $key, $value){
		$attributeHeaderColumn = new AttributeColumn();
		$attributeHeaderColumn->columnName = $columnName;
		$attributeHeaderColumn->key = $key;
		$attributeHeaderColumn->value = $value;
		$this->attributeHeaderColumn[] = $attributeHeaderColumn;
	}

    /**
     * ǡԤФ°ɲ<br>
     * ǡԤTRФ°ɲäޤ<br>
     *
     * @param $key °ΥȤʤʸ
     * @param $value °
     * @access public
     */
	public function appendAttributeRow($key, $value){
		$attributeRow = new Attribute();
		$attributeRow->key = $key;
		$attributeRow->value = $value;
		$this->attributeRow[] = $attributeRow;
	}

    /**
     * ǡФ°ɲ<br>
     * ǡԤTDФ°ɲäޤ<br>
     *
     * @param $columnName °Ϳ̾
     * @param $key °ΥȤʤʸ
     * @param $value °
     * @access public
     */
	public function appendAttributeColumn($columnName, $key, $value){
		$attributeColumn = new AttributeColumn();
		$attributeColumn->columnName = $columnName;
		$attributeColumn->key = $key;
		$attributeColumn->value = $value;
		$this->attributeColumn[] = $attributeColumn;
	}

    /**
     * ǡԤФ°ɲ<br>
     * ꤷɽоͤפ硢
     * ǡԤTRФ°ɲäޤ<br>
     *
     * @param $columnName °Ϳ̾
     * @param $ereg ɽ
     * @param $key °ΥȤʤʸ
     * @param $value °
     * @access public
     */
	public function appendAttributeRowEreg($columnName, $ereg, $key, $value){
		$attributeRowEreg = new AttributeColumnEreg();
		$attributeRowEreg->columnName = $columnName;
		$attributeRowEreg->key = $key;
		$attributeRowEreg->value = $value;
		$attributeRowEreg->ereg = $ereg;
		$this->attributeRowEreg[] = $attributeRowEreg;
	}

    /**
     * ǡФ°ɲ<br>
     * ꤷɽоͤפ硢
     * ǡԤTDФ°ɲäޤ<br>
     *
     * @param $columnName °Ϳ̾
     * @param $ereg ɽ
     * @param $key °ΥȤʤʸ
     * @param $value °
     * @access public
     */
	public function appendAttributeColumnEreg($columnName, $ereg, $key, $value){
		$attributeColumnEreg = new AttributeColumnEreg();
		$attributeColumnEreg->columnName = $columnName;
		$attributeColumnEreg->key = $key;
		$attributeColumnEreg->value = $value;
		$attributeColumnEreg->ereg = $ereg;
		$this->attributeColumnEreg[] = $attributeColumnEreg;
	}

    /**
     * ǡФ°ɲ<br>
     * ꤷ°򤹤٤ƤΥǡФͿޤ
     *
     * @param $key °ΥȤʤʸ
     * @param $value °
     * @access public
     */
	public function appendAttributeColumnAll($key, $value){
		$attribute = new Attribute();
		$attribute->key = $key;
		$attribute->value = $value;
		$this->attributeColumnAll[] = $attribute;
	}

    /**
     * إåԤΥǡФ°ɲ<br>
     * ꤷ°إåԤΤ٤ƤΥǡФͿޤ
     *
     * @param $key °ΥȤʤʸ
     * @param $value °
     * @access public
     */
	public function appendAttributeHeaderColumnAll($key, $value){
		$attribute = new Attribute();
		$attribute->key = $key;
		$attribute->value = $value;
		$this->attributeHeaderColumnAll[] = $attribute;
	}

    /**
     * ȵǽϤ̵ͭ<br>
     * ȵǽ̵ͭꤷޤ
     *
     * @param $useSort trueꤹȥȵǽѲǽˤʤޤ
     * @access public
     */
	public function setUseSort($useSort){
		$this->useSort = $useSort;
	}

    /**
     * ץ饰̵ͭ<br>
     * ץ饰̵ͭꤷޤ
     *
     * @param $useSort trueꤹȥץ饰Ѳǽˤʤޤ
     * @access public
     */
	public function setUsePlugin($usePlugin){
		$this->usePlugin = $usePlugin;
	}

    /**
     * ڡ󥰵ǽ̵ͭ<br>
     * ڡ󥰵ǽ̵ͭꤷޤ
     *
     * @param $usePager trueꤹȥڡ󥰵ǽѲǽˤʤޤ
     * @access public
     */
	public function setUsePager($usePager){
		$this->usePager = $usePager;
	}

    /**
     * λ<br>
     * ơ֥ΰʬΤߥȵǽͭˤѤޤ
     *
     * @param $headerKeys ȵǽѤ̾
     * @access public
     */
	public function setSortableHeader($headerKeys){
		if(is_array($headerKeys)){
			foreach($headerKeys as $headerKey){
				$this->sortableHeaderKeys[] = $headerKey;
			}
		}else{
			$this->sortableHeaderKeys[] = $headerKeys;
		}
	}

	private function sort(){
		$sortKey = $this->sortKey;
		if(!empty($sortKey)){
			$recordCount = count($this->records);
			for($i = 0; $i < $recordCount; $i++){
				$this->records[$i][$this->rowidName] = $i;
			}
			$sortArray = array();
			foreach($this->records as $record){
				$sortArray[$record[$this->rowidName]] = $record[$sortKey];
			}
			if($this->sortType == $this->parameterSortTypeAsc){
				asort($sortArray);
			}else{
				arsort($sortArray);
			}
			$sortRecords = array();
			foreach($sortArray as $sortKey=>$sortValue){
				foreach($this->records as $record){
					if($record[$this->rowidName] == $sortKey){
						unset($record[$this->rowidName]);
						$sortRecords[] = $record;
						break;
					}
				}
			}
			$this->records = $sortRecords;
		}
	}

    /**
     * ơ֥Υǡ<br>
     * ơ֥˽Ϥ뤿Υǡꤹ롣
     *
     * @param $records ǡ
     * @access public
     */
	public function setData($records){
		$this->records = $records;
		$this->pager->setTotalItemCount(count($records));
	}

    /**
     * ơ֥Υإå<br>
     * ơ֥Υإåͳꤹ롣
     *
     * @param $header Ϥإå
     * @access public
     */
	public function setHeader($header){
		$this->header = $header;
	}

    /**
     * Ⱦ֤<br>
     * ϻΥȾ֤ꤹ롣
     *
     * @param $sortKey ȥȤѤƤ̾
     * @param $sortType Ƚ(asc,desc,null)
     * @access public
     */
	public function setSort($sortKey, $sortType){
		$this->sortKey = $sortKey;
		$this->sortType = $sortType;
	}

    /**
     * ڡ󥰾֤<br>
     * ϻΥڡ󥰾֤ꤹ롣
     *
     * @param $currentPageNumber ɽڡֹ档
     * @param $pageParItems ڡɽ
     * @access public
     */
	public function setPager($currentPageNumber, $pageParItems){
		if(!empty($currentPageNumber)){
			$this->pager->setCurrentPageNumber($currentPageNumber);
		}
		if(!empty($pageParItems)){
			$this->pager->setPageParItems($pageParItems);
		}
	}

    /**
     * ƥȥơ֥<br>
     * ơ֥򥿥ֶڤƥȤȤɽޤ
     *
     * @access public
     */
	public function getTableText(){
		$records = $this->getRecords();
		$headerArray = $this->getHeaderArray($records);

		$text .= implode("\t", $headerArray);
		$text .= "\r\n";

		if($this->usePager){
			$records = $this->getViewRecords();
		}

		foreach($records as $record){
			foreach($headerArray as $headerKey=>$headerValue){
				$text .= $record[$headerKey];
				$text .= "\t";
			}
			$text .= "\r\n";
		}

		return $text;
	}

	private function getHeaderArray($records){
		if(empty($this->header)){
			$headerArray = array();
			foreach($records as $record){
				if(count($headerArray) < count($record)){
					$workHeaderArray = array();
					foreach($record as $itemKey=>$itemValue){
						$workHeaderArray[$itemKey] = $itemKey;
					}
					$headerArray = $workHeaderArray;
				}
			}
		}else{
			$headerArray = $this->header;
		}

		return $headerArray;
	}

	private function getUrlAttributeString(){
		$attributeArray = $this->getUrlAttribute();
		if(!empty($attributeArray)){
			foreach($attributeArray as $attribute){
				$attributeString .= "&" . $attribute->key . "=" . urlencode($attribute->value);
			}
		}
		return $attributeString;
	}

	private function getUrlAttribute(){
		$attributeArray = array();
		if($this->useSort){
			if(!empty($this->sortKey)){
				$attribute = new Attribute();
				$attribute->key = $this->parameterSortKeyString;
				$attribute->value = $this->sortKey;
				$attributeArray[] = $attribute;
			}
			if(!empty($this->sortType)){
				$attribute = new Attribute();
				$attribute->key = $this->parameterSortTypeString;
				$attribute->value = $this->sortType;
				$attributeArray[] = $attribute;
			}
		}
		if($this->usePager){
			$attribute = new Attribute();
			$attribute->key = $this->parameterPageString;
			$attribute->value = $this->pager->getCurrentPageNumber();
			$attributeArray[] = $attribute;

			$attribute = new Attribute();
			$attribute->key = $this->parameterPageParString;
			$attribute->value = $this->pager->getPageParItems();
			$attributeArray[] = $attribute;
		}
		return $attributeArray;
	}

    /**
     * ڡ󥰥󥯤μ<br>
     * ڡ󥰥󥯤֤ޤ
     *
     * @access public
     */
	public function getPagerHtml(){
		return $this->pager->getBasicPagerHtml($this->getUrlAttribute());
	}

	private function getRecords(){
		if(empty($this->records)){
			return array();
		}

		if($this->useSort){
			$this->sort();
		}

		return $this->records;
	}
	private function getViewRecords(){
		$records = $this->getRecords();

		if(empty($records)){
			return;
		}

		if($this->usePager){
			$page = $this->pager->getCurrentPageNumber();
			$pageitem = $this->pager->getPageParItems();
			$startIndex = ($page - 1) * $pageitem;
			$endIndex = ($page - 1) * $pageitem + $pageitem - 1;
		}else{
			$endIndex = 999999;
		}

		$viewRecordArray = array();
		$i = 0;
		foreach($records as $record){
			if($i >= $startIndex && $i <= $endIndex){
				$viewRecordArray[] = $record;
			}
			$i = $i + 1;
		}
		return $viewRecordArray;
	}

    /**
     * ơ֥HTMLɤμ<br>
     * ߤξ֤ǥơ֥ѤHTMLɤ֤ޤ
     *
     * @access public
     */
	public function getTableHtml(){
		$tableTag .= "<table>";
		foreach($this->attribute as $attributeClass){
			$tableTag = $this->joinTagAttribute($tableTag, $attributeClass->key, $attributeClass->value);
		}
		$text .= $tableTag;

		$trTag .= "<tr>";
		foreach($this->attributeHeaderRow as $attributeHeaderRowClass){
			$trTag = $this->joinTagAttribute($trTag, $attributeHeaderRowClass->key, $attributeHeaderRowClass->value);
		}
		$text .= $trTag;

		$records = $this->getRecords();
		$headerArray = $this->getHeaderArray($records);

		$margeCount = 0;
		foreach($headerArray as $headerKey=>$headerValue){
			if($margeCount > 0){
				$margeCount = $margeCount - 1;
				continue;
			}

			$tdTag = "<th>";
			if(!empty($this->margeHeaderColumn)){
				foreach($this->margeHeaderColumn as $margeHeaderColumnName=>$margeHeaderColumnCount){
					if($margeHeaderColumnName == $headerKey){
						$tdTag = $this->joinTagAttribute($tdTag, "colspan", $margeHeaderColumnCount);
						$margeCount = $margeHeaderColumnCount - 1;
					}
				}
			}

			foreach($this->attributeHeaderColumnAll as $attributeHeaderColumnAllClass){
				$tdTag = $this->joinTagAttribute($tdTag, $attributeHeaderColumnAllClass->key, $attributeHeaderColumnAllClass->value);
			}

			foreach($this->attributeHeaderColumn as $attributeHeaderColumnClass){
				if($headerKey == $attributeHeaderColumnClass->columnName){
					$tdTag = $this->joinTagAttribute($tdTag, $attributeHeaderColumnClass->key, $attributeHeaderColumnClass->value);
				}
			}

			if($this->useSort){
				if(!empty($this->sortableHeaderKeys) && !in_array($headerKey, $this->sortableHeaderKeys)){
					$text .= $tdTag;
					$text .= $headerValue;
					continue;
				}

				$urlSortKey = urlencode($headerValue);
				if($headerValue == $this->sortKey){
					if($this->sortType == $this->parameterSortTypeAsc){
						$urlSortType = $this->parameterSortTypeDesc;
					}else if($this->sortType == $this->parameterSortTypeDesc){
						$urlSortType = "";
						$urlSortKey = "";
					}else{
						$urlSortType = $this->parameterSortTypeAsc;
					}
				}else{
						$urlSortType = $this->parameterSortTypeAsc;
				}
				$text .= $tdTag . "<a href=\"" . $this->scriptName . "?";
				if($this->usePager){
					$text .= "&" . $this->parameterPageString . "=" . $this->pager->getCurrentPageNumber();
					$text .= "&" . $this->parameterPageParString . "=" . $this->pager->getPageParItems();
				}
				if(!empty($urlSortKey)){
					$text .= "&" . $this->parameterSortKeyString . "=" . $urlSortKey;
				}
				if(!empty($urlSortType)){
					$text .= "&" . $this->parameterSortTypeString . "=" . $urlSortType;
				}
				$text .= "\">";
				$text .= $headerValue;
				$text .= "</a>";

				if($headerValue == $this->sortKey){
					if(empty($this->sortType) || $this->sortType == $this->parameterSortTypeAsc){
						$text .= "&nbsp;" . $this->sortTypeAscMarkString;
					}else if($this->sortType == $this->parameterSortTypeDesc){
						$text .= "&nbsp;" . $this->sortTypeDescMarkString;
					}
				}

			}else{
				$text .= $tdTag;
				$text .= $headerValue;
			}
			$text .= "</th>";
		}
		$text .= "</tr>";

		if($this->usePager){
			$records = $this->getViewRecords();
		}

		$rowColorIndex = 0;
		$rowspanWorkArray = array();
		foreach($records as $record){
			$trTag = "<tr>";

			if(!empty($this->roundBackgroundColors)){
				$trTag = $this->joinTagAttribute($trTag, "style", "background-color:" . $this->roundBackgroundColors[$rowColorIndex]);
				$rowColorIndex++;
				if($rowColorIndex >= count($this->roundBackgroundColors)){
					$rowColorIndex = 0;
				}
			}
			
			foreach($this->attributeRowEreg as $attributeRowEregClass){
				foreach($headerArray as $headerKey=>$headerValue){
					if($headerKey == $attributeRowEregClass->columnName){
						if(mbereg($attributeRowEregClass->ereg, $record[$headerKey])){
							$trTag = $this->joinTagAttribute($trTag, $attributeRowEregClass->key, $attributeRowEregClass->value);
						}
					}
				}
			}

			foreach($this->attributeRow as $attributeRowClass){
				$trTag = $this->joinTagAttribute($trTag, $attributeRowClass->key, $attributeRowClass->value);
			}
			$text .= $trTag;

			foreach($headerArray as $headerKey=>$headerValue){
				$tdTag = "<td>";
				foreach($this->attributeColumnAll as $attributeColumnAllClass){
					$tdTag = $this->joinTagAttribute($tdTag, $attributeColumnAllClass->key, $attributeColumnAllClass->value);
				}
				
				foreach($this->attributeColumnEreg as $attributeColumnEregClass){
					if($headerKey == $attributeColumnEregClass->columnName){
						if(mbereg($attributeColumnEregClass->ereg, 	$record[$headerKey])){
							$tdTag = $this->joinTagAttribute($tdTag, $attributeColumnEregClass->key, $attributeColumnEregClass->value);
						}
					}
				}
				foreach($this->attributeColumn as $attributeColumnClass){
					if($headerKey == $attributeColumnClass->columnName){
						$tdTag = $this->joinTagAttribute($tdTag, $attributeColumnClass->key, $attributeColumnClass->value);
					}
				}

				if($rowspanWorkArray[$headerKey] < 2){
					$margeColumnKey = array_keys($this->margeColumnRow);
					if(in_array($headerKey, $margeColumnKey)){
						$rowspanWorkArray[$headerKey] = $this->margeColumnRow[$headerKey];
						$tdTag = $this->joinTagAttribute($tdTag, "rowspan", $rowspanWorkArray[$headerKey]);
					}

					$text .= $tdTag;
					if(empty($record[$headerKey])){
						$text .= "&nbsp;";
					}else{
						$text .= $record[$headerKey];
					}
					$text .= "</td>";					

				}else{
					$rowspanWorkArray[$headerKey] = $rowspanWorkArray[$headerKey] - 1;
				}
			}
			$text .= "</tr>";
		}
		$text .= "</table>";

		return $text;
	}

    /**
     * ơ֥HTMLɤμ<br>
     * ٤ƤεǽѤơ֥ѤHTMLɤ֤ޤ<br>
     * Ϥ뵡ǽ<br>
     * ڡ<br>
     * <br>
     * ץ饰<br>
     * Ƶǽѥե饰ξ֤˰¸ޤ
     *
     * @access public
     */
	public function getFullStackTableHtml(){
		$records = $this->getRecords();

		if(empty($records)){
			return;
		}

		if($this->usePager){
			$text .= $this->getPagerHtml();
		}

		if(!empty($this->plugin)){
			$text .= "&nbsp;";
			$text .= "&nbsp;";
			$text .= "&nbsp;";
			$text .= "Plugin:";
		}
		foreach($this->plugin as $plugin){
			$text .= "&nbsp;";
			$text .= $plugin->getLinkTag($this->getUrlAttributeString(), $this->scriptName);
		}

		$text .= $this->getTableHtml();

		return $text;
	}

	private function joinTagAttribute($baseTag, $key, $value){
		if(empty($baseTag)){
			return $baseTag;
		}

		$createTag = str_replace(">", " " . $key . "=\"" . $value . "\">", $baseTag);
		return $createTag;
	}

    /**
     * ᥽å<br>
	 * ꥯȥѥ᡼Ѥƥ֥Ȥޤ
     *
     * @param request ɬפʥѥ᡼ޤ󡣤ޤphp$_REQUEST.
     * @access public
     */
     public function initialize($request){
		$this->scriptName = basename($_SERVER["SCRIPT_NAME"]);

		if($this->usePager){
			$currentPage = $request{$this->parameterPageString};
			$pagePar = $request{$this->parameterPageParString};
			$this->setPager($currentPage, $pagePar);
		}

		if($this->useSort){
			$urlencodeSortKey = $request{$this->parameterSortKeyString};
			$sortKey = urldecode($urlencodeSortKey);
			$sortType = $request{$this->parameterSortTypeString};
			if(!empty($sortKey)){
				$this->setSort($sortKey, $sortType);
			}
		}

		if($this->usePlugin){
			$this->plugin = $this->initializePlugin();
			$this->doPlugin($request{"logic"});
		}
	}

    /**
     * ᥽å<br>
	 * ꥯȥѥ᡼Ѥƥ֥Ȥޤ<br>
	 * 礷Ƥ٤Ƥεǽޤ
     *
     * @param request ɬפʥѥ᡼ޤ󡣤ޤphp$_REQUEST.
     * @access public
     */
	public function fullStackInitialize($request){
		$this->scriptName = basename($_SERVER["SCRIPT_NAME"]);

		$currentPage = $request{$this->parameterPageString};
		$pagePar = $request{$this->parameterPageParString};

		$urlencodeSortKey = $request{$this->parameterSortKeyString};
		$sortKey = urldecode($urlencodeSortKey);
		$sortType = $request{$this->parameterSortTypeString};

		$this->setUseSort(true);
		$this->setUsePager(true);
		$this->setUsePlugin(true);

		$this->setPager($currentPage, $pagePar);

		if(!empty($sortKey)){
			$this->setSort($sortKey, $sortType);
		}

		if($this->usePlugin){
			$this->plugin = $this->initializePlugin();
			$this->doPlugin($request{"logic"});
		}
	}

	// @todo
	private function initializePlugin(){
		$plugin = array();

		$plugin[] = new CsvDownload();
		$plugin[] = new ExcelDownload();
		$plugin[] = new Bookmark();
		
		return $plugin;
	}
	
    /**
     * إåηԤ<br>
	 * ꤷإå顢ꤷηԤޤ<br>
     *
     * @param $columnName ̾
     * @param $margeCount 礹
     * @access public
     */
	public function margeHeaderColumn($columnName, $margeCount){
		if(empty($columnName)){
			return;
		}

		if(empty($margeCount)){
			return;
		}

		if($margeCount < 2){
			return;
		}

		if(!is_numeric($margeCount)){
			return;
		}

		$this->margeHeaderColumn[$columnName] = $margeCount;
	}

    /**
     * إåηԤ<br>
	 * ꤷإå顢ꤷηԤޤ<br>
     *
     * @param $columnName ̾
     * @param $margeCount 礹
     * @access public
     */
	public function margeColumnRow($columnName, $margeCount){
		if(empty($columnName)){
			return;
		}

		if(empty($margeCount)){
			return;
		}

		if($margeCount < 2){
			return;
		}

		if(!is_numeric($margeCount)){
			return;
		}

		$this->margeColumnRow[$columnName] = $margeCount;
	}

	private function doPlugin($logic){
		if(empty($logic)){
			return;
		}

		foreach($this->plugin as $plugin){
			if($plugin->key == $logic){
				$records = $this->getRecords();
				$header = $this->getHeaderArray($records);
				$plugin->action($header, $records);
				return;
			}
		}
	}
	
	public function setRoundBackgroundColor($roundBackgroundColors){
		$this->roundBackgroundColors = $roundBackgroundColors;
	}
}

/**
 * ڡ󥰵ǽϥ饹<br>
 * ڡ󥰵ǽϤ륯饹
 *
 * @package    jettable.framework
 * @author     rds <tk@rasign.jp>
 * @license     http://www.opensource.org/licenses/mit-license.php The MIT License
 * @version    Release: 0.0.0
 * @link       http://jettable.rasign.jp/
 */
class Pager{
	private $currentPageNumber;
	private $pageParItems;
	private $totalItemCount;
	private $viewPageLinks;
	private $pageParItemType;
	private $scriptName;

	private $parameterPageString = "page";
	private $parameterPageParString = "pagePar";

    /**
     * ǥեȥ󥹥ȥ饯<br>
     * ѿνԤޤ<br>
     *
     * @param $currentPageNumber ߤΥڡֹ
     * @param $pageParItems ڡΥƥʹԡ˿
     * @param $viewPageLinks ڡɽ
     * @param $scriptName 襹ץ̾
     * @access public
     */
	public function __construct(
			$currentPageNumber = 1, 
			$pageParItems = 10, 
			$viewPageLinks = 10,
			$scriptName = null){
		$this->currentPageNumber = $currentPageNumber;
		$this->pageParItems = $pageParItems;
		$this->viewPageLinks = $viewPageLinks;
		$this->scriptName = $scriptName;
		
		$this->pageParItemType = array("10"=>"10", "30"=>"30", "50"=>"50");
	}

    /**
     * <br>
     * ƥꤷޤ<br>
     *
     * @param $totalItemCount 
     * @access public
     */
	public function setTotalItemCount($totalItemCount){
		$this->totalItemCount = $totalItemCount;
	}

    /**
     * ڡ⥢ƥ<br>
     * ڡɽ륢ƥʹԡˤηꤷޤ<br>
     *
     * @param $pageParItems 
     * @access public
     */
	public function setPageParItems($pageParItems){
		$this->pageParItems = $pageParItems;
	}

    /**
     * ڡ⥢ƥ<br>
     * ڡɽ륢ƥʹԡˤηޤ<br>
     *
     * @return 
     * @access public
     */
	public function getPageParItems(){
		return $this->pageParItems;
	}

    /**
     * ߥڡ<br>
     * ɽΥڡֹꤷޤ<br>
     *
     * @param $currentPageNumber ڡֹ
     * @access public
     */
	public function setCurrentPageNumber($currentPageNumber){
		$this->currentPageNumber = $currentPageNumber;
	}

    /**
     * ߥڡ<br>
     * ɽΥڡֹޤ<br>
     *
     * @return ڡֹ
     * @access public
     */
	public function getCurrentPageNumber(){
		return $this->currentPageNumber;
	}

    /**
     * ڡֹ<br>
     * ڡֹޤ<br>
     *
     * @return ڡֹ
     * @access public
     */
    public function getMaxPage(){
		return ceil($this->totalItemCount / $this->pageParItems);
	}

    /**
     * ɽκڡֹ<br>
     * ɽκڡֹޤ<br>
     *
     * @return ɽκڡֹ
     * @access public
     */
	public function getViewMaxPage(){
		$page = $this->currentPageNumber;
		$totalPageCount = $this->getMaxPage();
		$startViewPageLink = $page - ceil($this->viewPageLinks / 2) - 1;
		$endViewPageLink = $page + ceil($this->viewPageLinks / 2) - 1;

		if($startViewPageLink < 1){
			$sa = 0 - $startViewPageLink;
			$startViewPageLink = 0;
			$endViewPageLink += $sa;
		}
		if($endViewPageLink > $totalPageCount){
			$sa = $endViewPageLink - $totalPageCount;
			$endViewPageLink = $totalPageCount;
			$startViewPageLink -= $sa;
		}
		return $endViewPageLink;
	}

    /**
     * ɽκǾڡֹ<br>
     * ɽκǾڡֹޤ<br>
     *
     * @return ɽκǾڡֹ
     * @access public
     */
	public function getViewMinPage(){
		$page = $this->currentPageNumber;
		$totalPageCount = $this->getMaxPage();
		$startViewPageLink = $page - ceil($this->viewPageLinks / 2) - 1;
		$endViewPageLink = $page + ceil($this->viewPageLinks / 2) - 1;

		if($endViewPageLink > $totalPageCount){
			$sa = $endViewPageLink - $totalPageCount;
			$endViewPageLink = $totalPageCount;
			$startViewPageLink -= $sa;
		}
		if($startViewPageLink < 1){
			$sa = 0 - $startViewPageLink;
			$startViewPageLink = 0;
			$endViewPageLink += $sa;
		}
		return $startViewPageLink + 1;
	}

    /**
     * ץʥڡ󥰥󥯼<br>
     * ץʥڡ󥰥󥯤Ϥ뤿ΥƥȤޤ<br>
     * <br>
     * 
     * <pre>
     * 1 2 3 4 5 6 7 8 9 10
     * </pre>
     *
     * @return ڡɽʸ(HTML)
     * @access public
     */
	public function getBasicPagerHtml($attributeArray){
		$page = $this->currentPageNumber;
		$totalPageCount = $this->getMaxPage();
		$startViewPageLink = $this->getViewMinPage();
		$endViewPageLink = $this->getViewMaxPage();

		foreach($attributeArray as $attribute){
			if($attribute->key == $this->parameterPageString){
				continue;
			}
			if($attribute->key == $this->parameterPageParString){
				$pageAttributeString .= "&" . $attribute->key . "=" . urlencode($attribute->value);
				continue;
			}
			$pageAttributeString .= "&" . $attribute->key . "=" . urlencode($attribute->value);
			$pageParAttributeString .= "&" . $attribute->key . "=" . urlencode($attribute->value);
		}

		$text = "Page:";
		for($i = $startViewPageLink; $i <= $endViewPageLink; $i++){
			if($i == $page){
				$text .= $i;
			}else{
				$text .= "<a href=\"" . $this->scriptname . "?";
				$text .= $this->parameterPageString . "=" . $i . $pageAttributeString ."\">";
				$text .= $i;
				$text .= "</a>";
			}
			if($i != $totalPageCount){
				$text .= "&nbsp;";
			}
		}

		$text .= "&nbsp;";
		$text .= "&nbsp;";
		$text .= "&nbsp;";
		$text .= "Items:";
		foreach($this->pageParItemType as $pageParItemKey=>$pageParItemValue){
			if($pageParItemValue == $this->pageParItems){
				$text .= $pageParItemValue . "&nbsp;";
			}else{
				$text .= "<a href=\"" . $this->scriptname . "?";
				$text .= $this->parameterPageString . "=1" . $pageParAttributeString;
				$text .= "&" . $this->parameterPageParString . "=" . $pageParItemValue . "\">";
				$text .= $pageParItemKey;
				$text .= "</a>&nbsp;";
			}
		}
		return $text;
	}
}
/**
 * °饹<br>
 * °ɽ륯饹
 *
 * @package    jettable.framework
 * @author     rds <tk@rasign.jp>
 * @license     http://www.opensource.org/licenses/mit-license.php The MIT License
 * @version    Release: 0.0.0
 * @link       http://jettable.rasign.jp/
 */
class Attribute{
	public $key;
	public $value;
}

/**
 * ǡ°饹<br>
 * ǡ°ɽ륯饹
 *
 * @package    jettable.framework
 * @author     rds <tk@rasign.jp>
 * @license     http://www.opensource.org/licenses/mit-license.php The MIT License
 * @version    Release: 0.0.0
 * @link       http://jettable.rasign.jp/
 */
class AttributeColumn extends Attribute{
	public $columnName;
}

/**
 * ɽ°饹<br>
 * ǡ°ɽɽ륯饹
 *
 * @package    jettable.framework
 * @author     rds <tk@rasign.jp>
 * @license     http://www.opensource.org/licenses/mit-license.php The MIT License
 * @version    Release: 0.0.0
 * @link       http://jettable.rasign.jp/
 */
class AttributeColumnEreg extends AttributeColumn{
	public $ereg;
}


/**
 * ץ饰󥯥饹<br>
 * JettableΥץ饰󤬷Ѿݥ饹Ǥ
 *
 * @package    jettable.framework
 * @author     rds <tk@rasign.jp>
 * @license     http://www.opensource.org/licenses/mit-license.php The MIT License
 * @version    Release: 0.0.0
 * @link       http://jettable.rasign.jp/
 */
abstract class Plugin{
	public $key;
	function getLinkTag($attributeString, $scriptName){
		$link = "<a href=\"" . $scriptName . "?logic={$this->key}{$attributeString}\">{$this->key}</a>";
		return $link;
	}
	abstract function action($header, $records);
}

/**
 * ֥åޡ󥯽<br>
 * ֥åޡɲå󥯤Ϥ뤿Υץ饰
 *
 * @package    jettable.framework
 * @author     rds <tk@rasign.jp>
 * @license     http://www.opensource.org/licenses/mit-license.php The MIT License
 * @version    Release: 0.0.0
 * @link       http://jettable.rasign.jp/
 */
class Bookmark extends Plugin{
	public function __construct(){
		$this->key = "bookmark";
	}

	function getLinkTag($attributeString, $scriptName){
		// @todo bad
		$link = "<a href=\"javascript:window.external.AddFavorite('http://localhost/table/{$scriptName}?{$attributeString}','list')\">bookmark</a>";
		return $link;
	}

	function action($header, $records){}
}

/**
 * Excelɥ󥯽<br>
 * ơ֥ƤExcelեȤƽϤ뤿Υץ饰
 *
 * @package    jettable.framework
 * @author     rds <tk@rasign.jp>
 * @license     http://www.opensource.org/licenses/mit-license.php The MIT License
 * @version    Release: 0.0.0
 * @link       http://jettable.rasign.jp/
 */
class ExcelDownload extends Plugin{
	public function __construct(){
		$this->key = "excel";
	}

	function action($header, $records){
		require_once "Spreadsheet\Excel\Writer.php";

		$workbook = new Spreadsheet_Excel_Writer();
		$worksheet =& $workbook->addWorksheet("list");
		$format =& $workbook->addFormat();
		$format->_font_name = mb_convert_encoding("sjis", "sjis");

		$i = 0;
		foreach($header as $headerKey=>$headerValue){
			$worksheet->write(0, $i, mb_convert_encoding($headerValue, "sjis", "euc-jp"));
			$i++;
		}

		$i = 1;
		foreach($records as $record){
			$j = 0;
			foreach($header as $headerKey=>$headerValue){
				$worksheet->write($i, $j, mb_convert_encoding($record[$headerKey], "sjis", "euc-jp"));
				$j++;
			}
			$i++;
		}

		$workbook->send("list.xls");
		$workbook->close();

		die();
	}
}

/**
 * CSVɥ󥯽<br>
 * ơ֥ƤCSVեȤƽϤ뤿Υץ饰
 *
 * @package    jettable.framework
 * @author     rds <tk@rasign.jp>
 * @license     http://www.opensource.org/licenses/mit-license.php The MIT License
 * @version    Release: 0.0.0
 * @link       http://jettable.rasign.jp/
 */
class CsvDownload extends Plugin{
	public function __construct(){
		$this->key = "csv";
	}

	function action($header, $records){
		$headerString = implode("\",\"", $header);
		$headerString = "\"" . $headerString . "\"";
		$contents = $headerString;
		$contents .= "\r\n";

		foreach($records as $record){
			$recordArray = array();
			foreach($header as $headerKey=>$headerValue){
				$recordArray[] = $record[$headerKey];
			}
			$recordString = implode("\",\"", $recordArray);
			$recordString = "\"" . $recordString . "\"";
			$contents .= $recordString;
			$contents .= "\r\n";
		}

		Header("Content-disposition: attachment; filename=list.csv");
	    Header("Content-type: application/octet-stream; name=list.csv");
		print $contents;

		die();
	}
}
?>