package org.apache.jetspeed.modules.actions.portlets;

import org.apache.jetspeed.portal.portlets.AbstractVTLPortlet;

// Turbine stuff
import org.apache.turbine.util.RunData;

// Velocity Stuff
import org.apache.velocity.context.Context;


/**
Hello world portlet supporting min/restore/conf/max/close buttons

@author <a href="mailto:re_carrasco@bco011.sonda.cl">Roberto Carrasco</a>
*/
public class HelloPortlet extends AbstractVTLPortletAction
{
    private final static String DEFAULT_SALUDO  = "Welcome";
    private final static String DEFAULT_ANONIMO = "Welcome anonymous";

    // called when config button pressed
    public void setConfigureContent( AbstractVTLPortlet xPortlet, Context context, RunData rundata )
    {
        String saludo = xPortlet.getAttribute( "saludo", DEFAULT_SALUDO, rundata );

        // In config mode, i require another template
        context.put( "vtlTemplate", "HelloConfigPortlet" );
        context.put( "saludo", saludo );
    }

    // called when max button pressed
    public void setMaximizedContent( AbstractVTLPortlet xPortlet, Context context, RunData rundata, boolean loggedUser )
    {
        String saludo = xPortlet.getAttribute( "saludo", loggedUser ? DEFAULT_SALUDO : DEFAULT_ANONIMO, rundata );

        // just a demo, sorry
        saludo = "<font style='font-size: 40pt; '>" + saludo + "</font>";
        context.put( "saludo", saludo );
    }

    // called in minimized state
    public void setMinimizedContent( AbstractVTLPortlet xPortlet, Context context, RunData rundata )
    {
        String saludo = xPortlet.getAttribute( "saludo", DEFAULT_SALUDO, rundata );

        // i have no data area, so use the title bar
        xPortlet.setTitle( saludo );
    }

    // called in normal state
    public void setNormalContent( AbstractVTLPortlet xPortlet, Context context, RunData rundata, boolean loggedUser )
    {
        String saludo = xPortlet.getAttribute( "saludo", loggedUser ? DEFAULT_SALUDO : DEFAULT_ANONIMO, rundata );

        // normal state
        context.put( "saludo", saludo );
    }

}