/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.util.rewriter;

// java.io
import java.io.Reader;

// java.net
import java.net.MalformedURLException;

// this makes it dependent on Swing...need an abstraction WTP
import javax.swing.text.html.HTML;
import javax.swing.text.MutableAttributeSet;

/**
 * 
 * Interface for  URL rewriting.
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: Rewriter.java,v 1.5 2003/09/05 16:41:17 morciuch Exp $
 */

public interface Rewriter
{

    /*
     * Entry point into rewriting HTML content.
     *
     * Reads stream from proxied host, runs configured HTML parser against that stream,
     * rewriting relevant links, and writes the parsed stream back to the client.
     *
     * @param input the HTML input stream.
     * @param input the base URL host string used to create full links back to host
     * @return the rewritten HTML output stream.
     *
     * @exception MalformedURLException a servlet exception.
     */
    String rewrite(Reader input, String baseURL)
            throws MalformedURLException;
                               

    /* <p>
     * This callback is called by the HTMLParserAdaptor implementation to write
     * back all rewritten URLs to point to the proxy server. Each implementation
     * writes specifically for their own type of resources.</p>
     * <p>
     * Given the targetURL, rewrites the link as a link back to the proxy server.     
     * </p>
     * @param targetURL the URL to be rewritten back to the proxy server.
     * @param baseURL the base URL of the target host.
     * @param proxyURL the base URL of the proxy server.
     * @return the rewritten URL to the proxy server.
     *
     * @exception MalformedURLException a servlet exception.
     */
    String generateNewUrl(String targetURL, HTML.Tag tag, HTML.Attribute attribute);

    /*
     * Returns true if all rewritten URLs should be sent back to the proxy server.
     *
     * @return true if all URLs are rewritten back to proxy server.
     */        
    boolean proxyAllTags();

    // parser event handling
    boolean enterSimpleTagEvent(HTML.Tag tag, MutableAttributeSet attrs);
    String exitSimpleTagEvent(HTML.Tag tag, MutableAttributeSet attrs);

    boolean enterStartTagEvent(HTML.Tag tag, MutableAttributeSet attrs);
    String exitStartTagEvent(HTML.Tag tag, MutableAttributeSet attrs);

    boolean enterEndTagEvent(HTML.Tag tag);
    String exitEndTagEvent(HTML.Tag tag);

    boolean enterText(char[] values, int param);

    void convertTagEvent(HTML.Tag tag, MutableAttributeSet attrs);
}

