/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.jetspeed.util;

// Junit imports
import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.jetspeed.test.HeadlessBaseTest;
import org.apache.jetspeed.util.parser.ValidationParameterParser;

/**
 * Command Line Test ValidationParameterParser routines.
 *
 * @author <a href="mailto:ben.woodward@bbc.co.uk">Ben Woodward</a>
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: TestValidationParameterParser.java,v 1.5 2003/08/20 05:40:22 taylor Exp $
 */

public class TestValidationParameterParser extends HeadlessBaseTest
{
    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestValidationParameterParser( String name ) {
        super( name );
    }

    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[]) {
        junit.awtui.TestRunner.main( new String[] { TestValidationParameterParser.class.getName() } );
    }

    public void setup() {
        System.out.println("Setup: Testing ValidationParameterParser");
     }

    public static Test suite()
    {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite( TestValidationParameterParser.class );
    }


      ///////////////////////////////////////////////////////////////////////////

    public void testGood() throws Exception
    {
        try
        {
            Dummy dummy = new Dummy();
            ValidationParameterParser parser = new ValidationParameterParser();
            parser.add("Name", "David");
            parser.add("Age", "41");
            parser.add("Email", "david@bluesunrise.com");           
            parser.setProperties(dummy);
        }
        catch (Throwable t)
        {
            t.printStackTrace();
        }
    }

    public void testFail() throws Exception
    {
        boolean failed = false;
        try
        {
            Dummy dummy = new Dummy();
            ValidationParameterParser parser = new ValidationParameterParser();
            parser.add("Name", "David");
            parser.add("Age", "1041");
            parser.add("Email", "david@bluesunrise.com");           
            parser.setProperties(dummy);
        }
        catch (Throwable t)
        {
            failed = true;
        }
        assertTrue(failed == true);
    }

    public class Dummy
    {
        private String name;
        private String email;
        private int age;
 
        public String getName()
        {
            return name;
        }

        public String getEmail()
        {
            return email;
        }

        public int getAge()
        {
            return age;
        }

        public void setName(String name)
        {
            this.name = name;
        }

        public void setEmail(String email)
        {
            this.email = email;
        }

        public void setAge(int age)
        {
            this.age = age;
        }

        public boolean validateAge(int age)
        {
            if (age > 0 && age < 120)
            {
                return true;
            }
            return false;
        }            

        public boolean validateEmail(String email)
        {
            return ValidationHelper.isEmailAddress(email, false);
        }            

        public boolean validateName(String name)
        {
            return ValidationHelper.isLooseAlphaNumeric(name, false);
        }            

        public String validate()
        {
            if (name.equals("David"))
            {
                if (email.equals("david@bluesunrise.com"))
                {
                    return null;
                }
                else
                {
                    return "Bad Email/Name combination";                    
                }
            }
            else
            {
                return "Bad Name/Email combination";
            }
        }
    }
        
}
