/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.util;

import org.apache.turbine.util.RunData;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.om.registry.Parameter;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletConfig;

/**
 * Defines standard utility functions for config parameters
 *
 * @author <a href="mailto:david@apache.org">David Sean Taylor</a>
 * @author <a href="mailto:morciuch@apache.org">Mark Orciuch</a> 
 * @author <a href="mailto:weaver@apache.org">Scott T. Weaver</a>
 * @version $Id: PortletConfigState.java,v 1.3 2003/04/09 14:15:02 weaver Exp $
 */
public class PortletConfigState
{

    /**
    Returns the parameter for this name from the xreg
    */
    public static String getConfigParameter(Portlet portlet,
                                            String attrName,
                                            String attrDefaultValue)
    {
        PortletConfig pc = portlet.getPortletConfig();
        return pc.getInitParameter(attrName, attrDefaultValue);
    }

    /**
    Returns the parameter for this name from the psml
    */
    public static String getInstanceParameter(Portlet portlet,
                                              RunData rundata,
                                              String attrName)
    {
        return portlet.getAttribute( attrName, null, rundata);
    }

    /**
     * Sets the parameter in the psml
     */
    public static void setInstanceParameter(Portlet portlet,
                                     RunData rundata,
                                     String attrName,
                                     String attrValue)
    {
        portlet.setAttribute(attrName, attrValue, rundata);
    }

    public static void clearInstanceParameter(Portlet portlet,
                                       RunData rundata,
                                       String attrName)
    {
        if( portlet.getAttribute(attrName, null, rundata) != null )
            portlet.setAttribute(attrName, null, rundata);
    }

    /*
     * Gets the parameter using the fallback routine - first checks PSML,
     * in case it doesn't find it then it looks up the registry
     */
    public static String getParameter(Portlet portlet,
                               RunData rundata,
                               String attrName,
                               String attrDefValue)
    {
        String str = getInstanceParameter( portlet, rundata, attrName);
        if (str == null)
        {
            str = getConfigParameter(portlet, attrName, attrDefValue);
        }
        return str;
    }

    /**
    Returns the parameter for this name from the xreg
    */
    public static String getConfigParameter(VelocityPortlet portlet,
                                            String attrName,
                                            String attrDefaultValue)
    {
        return getConfigParameter((Portlet) portlet, attrName, attrDefaultValue);
    }

    /**
    Returns the parameter for this name from the psml
    */
    public static String getInstanceParameter(VelocityPortlet portlet,
                                              RunData rundata,
                                              String attrName)
    {
        return getInstanceParameter((Portlet) portlet, rundata, attrName);
    }

    /**
     * Sets the parameter in the psml
     */
    public static void setInstanceParameter(VelocityPortlet portlet,
                                     RunData rundata,
                                     String attrName,
                                     String attrValue)
    {
        setInstanceParameter((Portlet) portlet, rundata, attrName, attrValue);
    }

    public static void clearInstanceParameter(VelocityPortlet portlet,
                                       RunData rundata,
                                       String attrName)
    {
        clearInstanceParameter((Portlet) portlet,rundata,attrName);
    }

    /*
     * Gets the parameter using the fallback routine - first checks PSML,
     * in case it doesn't find it then it looks up the registry
     */
    public static String getParameter(VelocityPortlet portlet,
                               RunData rundata,
                               String attrName,
                               String attrDefValue)
    {
        return getParameter((Portlet) portlet, rundata, attrName, attrDefValue);
    }
    
    /**
     * Sets the registry (.xreg) value of this portlet.  Use this method because
     * PortletConfig.setInitParameter() is all but useless in this case.  The portlet
     * config availble in the Portlet is never saved back to the registry.
     */
    public static void setPortletConfigParameter(Portlet portlet, String name, String value)
    {
        PortletEntry pEntry = (PortletEntry) Registry.getEntry(Registry.PORTLET, portlet.getName());

        if (pEntry != null)
        {
            Parameter param = pEntry.getParameter(name);
            portlet.getPortletConfig().setInitParameter(name, value);
            if (param != null)
            {
                param.setValue(value);
            }
            else
            {
                pEntry.addParameter(name, value);
            }
        }
    }
}
