/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *    "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.jetspeed.util;

import java.io.Serializable;

/**
 * General <Name Value Selected> utility class, can be used to store info
 * regarding checkboxes, dropdowns and other html items
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: HtmlItem.java,v 1.2 2003/08/05 19:08:04 jford Exp $
 */
public class HtmlItem implements Serializable
{

    private int intValue = -1;
    private String name;
    private boolean selected = false;

    private String value = null;

    /**
    * Default constructor
    *
    */
    public HtmlItem()
    {
    }

    /**
    * Constructor that takes intValue and description.
    * Don't have to call set methods if this is used.
    *
    * @param sValue  The list item value
    * @param sDescription  The list item description
    */
    public HtmlItem(int sValue, String sDescription)
    {
      this.setIntValue(sValue);
      this.setName(sDescription);
    }

    public HtmlItem(int sValue, String sDescription, boolean selected)
    {
      this.setIntValue(sValue);
      this.setName(sDescription);
      this.setSelected(selected);
    }

    public HtmlItem(String sValue, String sDescription)
    {
      this.setValue(sValue);
      this.setName(sDescription);
    }

    public HtmlItem(String sValue, String sDescription, boolean selected)
    {
      this.setValue(sValue);
      this.setName(sDescription);
      this.setSelected(selected);
    }

    public HtmlItem(String sDescription)
    {
      this.setValue(sDescription);
      this.setName(sDescription);
    }

    public HtmlItem(String sDescription, boolean selected)
    {
      this.setValue(sDescription);
      this.setName(sDescription);
      this.setSelected(selected);
    }

    /**
    * Setter method
    *
    * @param sValue  Item's value
    */
    private void setIntValue(int sValue)
    {
      intValue = sValue;
    }

    /**
    * Setter method
    *
    * @param sValue  Item's value
    */
    private void setValue(String sValue)
    {
      this.value = sValue;
    }

    /**
    * Setter method
    *
    * @param sValue  Item's description
    */
    private void setName(String sValue)
    {
      name = sValue;
    }

    public void setSelected(boolean value)
    {
      selected = value;
    }
    /**
    * Accessor Method that returns the items value
    *
    * @return  The Item's value
    */
    public int getIntValue()
    {
      return intValue;
    }
    /**
    * Accessor Method that returns the items value
    *
    * @return  The Item's value
    */
    public String getValue()
    {
      return value;
    }

    /**
    * Accessor Method that returns the items description
    *
    * @return  The Item's description
    */
    public String getName()
    {
      return name;
    }

    public boolean getSelected()
    {
      return selected;
    }

}

