/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.util;

//standard java stuff
import java.util.Map;
import java.util.Iterator;

/**
 * Defines a standard object configuration
 * A Config provides the parameters passed in the current request as well
 * as init parameters.
 * 
 * @author <a href="mailto:raphael@apache.org">Raphal Luta</a>
 * @version $Id: Config.java,v 1.9 2001/05/28 15:08:15 raphael Exp $
 */
public interface Config
{

    /**
    Returns the name for this configuration
    */
    public String getName();

    /**
    Sets the name of this configuration
    */
    public void setName(String name);

    /**
    Used to define a Portlet's parameters.
    */
    public void setInitParameters( Map init_params );

    /**
    Used to override Portlet's parameters.
    */
    public void addInitParameters( Map init_params );

    /**
    Retrieves the PortletController parameters
    */
    public Map getInitParameters();

    /**
    Used to define a PortletController's parameter.if value is null, removes
    the key from the stored properties
    */
    public void setInitParameter(String name, Object value);

    /**
    Returns a parameter (or null) that was given the controller.
    */
    public String getInitParameter(String name);

    /**
    Returns a parameter (or defaultValue) that was given the controller.
    */
    public String getInitParameter(String name, String defaultValue);

    /**
    Returns the parameter names of this Config.
    */
    public Iterator getInitParameterNames();

}
