/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.webpage;

/**
 * Holds the relevant state about a secured site.
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: SecuredSite.java,v 1.1 2003/02/12 08:12:28 taylor Exp $ 
 */
public class SecuredSite implements Site
{    
    //
    // Site state
    //
    private long id;
    private String url;
    private String name;
    private int    status;
    private String username;
    private String password;

    /**
     * Construct site object given a url 
     *
     * @param name the name of the site.
     * @param url the url address of the site.
     *
     */
    public SecuredSite(String name, String url)
    {
        this.id = WebPageHelper.generateId();
        this.name = name;
        this.url = url;
    }

    /**
     * get the URL for this site
     *
     * return the string value of the URL
     */
    public String getURL()
    {
        return this.url;
    }

    /**
     * get the Site ID for this site
     *
     * return the string value of the Site ID
     */
    public long getID()
    {
        return this.id;
    }

    /** 
     * sets the URL address for this site.
     *
     * @param the URL address of the site.
     */
    public void setURL(String url)
    {
        this.url = url;
    }

    /** 
     * get the common name for this site.
     *
     * return the string value of the site name.
     */
    public String getName()
    {
        return name;
    }

    /**
     * sets the common name for this site.
     *
     * @param the name of the site.
     */
    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * get the user name used to logon to this site.
     *
     * return the string value of the site user name.
     */
    public String getUserName()
    {
        return username;
    }

    /**
     * sets the user name used to logon to this site.
     *
     * @param the string value of the site user name.
     */
    public void setUserName(String username)
    {
        this.username = username;
    }

    /**
     * get the password used to logon to this site.
     *
     * return the string value of the site password.
     */
    public String getPassword()
    {
        return password;
    }

    /** 
     * sets the password used to logon to this site.
     *
     * @param the string value of the site password.
     */
    public void setPassword(String password)
    {
        this.password = password;
    }

   /**
     * get the availability status of this site.
     *
     * return the int value of the site availability status.
     */
    public int getStatus()
    {
        return status;
    }

    /**
     * sets the availability status of this site.
     *
     * @param the int value of the site availability status.
     */
    public void setStatus(int status)
    {
        this.status = status;
    }

   /* 
     * Is this site secured.
     *
     * return True if the target is secured.
     */
    public boolean isSecured()
    {
        return true;
    }
 
}
