/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.jetspeed.services.search;

import java.util.Map;
import java.net.URL;

/**
 * Contract for implementing a specific parsed object.
 *
 * @author <a href="mailto:morciuch@apache.org">Mark Orciuch</a>
 * @version $Id: ParsedObject.java,v 1.2 2003/06/16 19:05:00 morciuch Exp $
 */
public interface ParsedObject
{

    public static final String FIELDNAME_KEY = "fieldname.key";
    public static final String FIELDNAME_KEY_DEFAULT = "Key";
    public static final String FIELDNAME_TYPE = "fieldname.type";
    public static final String FIELDNAME_TYPE_DEFAULT = "Type";
    public static final String FIELDNAME_CONTENT = "fieldname.content";
    public static final String FIELDNAME_CONTENT_DEFAULT = "Content";
    public static final String FIELDNAME_DESCRIPTION = "fieldname.description";
    public static final String FIELDNAME_DESCRIPTION_DEFAULT = "Description";
    public static final String FIELDNAME_TITLE = "fieldname.title";
    public static final String FIELDNAME_TITLE_DEFAULT = "Title";
    public static final String FIELDNAME_LANGUAGE = "fieldname.language";
    public static final String FIELDNAME_LANGUAGE_DEFAULT = "Language";
    public static final String FIELDNAME_FIELDS = "fieldname.fields";
    public static final String FIELDNAME_FIELDS_DEFAULT = "Fields";
    public static final String FIELDNAME_KEYWORDS = "fieldname.keywords";
    public static final String FIELDNAME_KEYWORDS_DEFAULT = "Keywords";
    public static final String FIELDNAME_URL = "fieldname.url";
    public static final String FIELDNAME_URL_DEFAULT = "URL";
    public static final String FIELDNAME_SCORE = "fieldname.score";
    public static final String FIELDNAME_SCORE_DEFAULT = "Score";

    // Known object types
    public static final String OBJECT_TYPE_URL = "url";
    public static final String OBJECT_TYPE_PORTLET = "portlet";
    public static final String OBJECT_TYPE_PDF = "pdf";

    /**
     * Returns parsed object key (cannot be null)
     * 
     * @return 
     */
    public String getKey();

    /**
     * Sets parsed object key (cannot be null)
     * 
     * @param type
     */
    public void setKey(String key);

    /**
     * Returns parsed object type (cannot be null)
     * 
     * @return 
     */
    public String getType();

    /**
     * Sets parsed object type (cannot be null)
     * 
     * @param type
     */
    public void setType(String type);

    /**
     * Returns parsed object content (cannot be null)
     * 
     * @return 
     */
    public String getContent();

    /**
     * Sets parsed object content (cannot be null)
     * 
     * @param content
     */
    public void setContent(String content);

    /**
     * Returns parsed object description (cannot be null)
     * 
     * @return 
     */
    public String getDescription();

    /**
     * Sets parsed object description (cannot be null)
     * 
     * @param description
     */
    public void setDescription(String description);

    /**
     * Returns parsed object keywords
     * 
     * @return 
     */
    public String[] getKeywords();

    /**
     * Sets parsed object keywords
     * 
     * @param keywords
     */
    public void setKeywords(String[] keywords);

    /**
     * Returns parsed object title (cannot be null)
     * 
     * @return 
     */
    public String getTitle();

    /**
     * Sets parsed object title (cannot be null)
     * 
     * @param title
     */
    public void setTitle(String title);

    /**
     * Returns parsed object language  (cannot be null)
     * 
     * @return 
     */
    public String getLanguage();

    /**
     * Sets parsed object language (cannot be null)
     * 
     * @param language
     */
    public void setLanguage(String language);

    /**
     * Returns parsed object searchable fields
     * 
     * @return 
     */
    public Map getFields();

    /**
     * Sets parsed object searchable fields
     * 
     * @param fields
     */
    public void setFields(Map fields);

    /**
     * Returns parsed object URL
     * 
     * @return 
     */
    public URL getURL();

    /**
     * Sets parsed object URL
     * 
     * @param url
     */
    public void setURL(URL url);

    /**
     * Getter for property score.
     * 
     * @return Value of property score.
     */
    public float getScore();
    
    /**
     * Setter for property score.
     * 
     * @param score  New value of property score.
     */
    public void setScore(float score);

}

