/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.jetspeed.services.search;

import java.util.Map;
import java.net.URL;

/**
 * Base parsed object.
 *
 * @author <a href="mailto:morciuch@apache.org">Mark Orciuch</a>
 * @version $Id: BaseParsedObject.java,v 1.2 2003/06/16 19:05:00 morciuch Exp $
 */
public class BaseParsedObject implements ParsedObject
{

    private String key;
    private String type;
    private String title;
    private String description;
    private String content;
    private String language;
    private URL url;
    private String[] keywords;
    private Map fields;
    private float score;

    /**
     * Returns parsed object key
     * 
     * @return 
     */
    public String getKey()
    {
        return this.key;
    }

    /**
     * Sets parsed object key
     * 
     * @param content
     */
    public void setKey(String key)
    {
        this.key = key;
    }

    /**
     * Returns parsed object type
     * 
     * @return 
     */
    public String getType()
    {
        return this.type;
    }

    /**
     * Sets parsed object type
     * 
     * @param type
     */
    public void setType(String type)
    {
        this.type = type;
    }

    /**
     * Returns parsed object content
     * 
     * @return 
     */
    public String getContent()
    {
        return this.content;
    }

    /**
     * Sets parsed object content
     * 
     * @param content
     */
    public void setContent(String content)
    {
        this.content = content;
    }

    /**
     * Returns parsed object description
     * 
     * @return 
     */
    public String getDescription()
    {
        return this.description;
    }

    /**
     * Sets parsed object description
     * 
     * @param description
     */
    public void setDescription(String description)
    {
        this.description = description;
    }

    /**
     * Returns parsed object keywords
     * 
     * @return 
     */
    public String[] getKeywords()
    {
        return this.keywords;
    }

    /**
     * Sets parsed object keywords
     * 
     * @param keywords
     */
    public void setKeywords(String[] keywords)
    {
        this.keywords = keywords;
    }

    /**
     * Returns parsed object title
     * 
     * @return 
     */
    public String getTitle() 
    {
        return this.title;
    }

    /**
     * Sets parsed object title
     * 
     * @param title
     */
    public void setTitle(String title)
    {
        this.title = title;
    }

    /**
     * Returns parsed object language
     * 
     * @return 
     */
    public String getLanguage()
    {
        return this.language;
    }

    /**
     * Sets parsed object language
     * 
     * @param language
     */
    public void setLanguage(String language)
    {
        this.language = language;
    }

    /**
     * Returns parsed object searchable fields
     * 
     * @return 
     */
    public Map getFields()
    {
        return this.fields;
    }

    /**
     * Sets parsed object searchable fields
     * 
     * @param fields
     */
    public void setFields(Map fields)
    {
        this.fields = fields;
    }

    /**
     * Returns parsed object URL
     * 
     * @return 
     */
    public URL getURL()
    {
        return this.url;
    }

    /**
     * Sets parsed object URL
     * 
     * @param fields
     */
    public void setURL(URL url)
    {
        this.url = url;
    }

    /**
     * Getter for property score.
     * 
     * @return Value of property score.
     */
    public float getScore()
    {
        return this.score;
    }
    
    /**
     * Setter for property score.
     * 
     * @param score  New value of property score.
     */
    public void setScore(float score)
    {
        this.score = score;
    }

}

