package org.apache.jetspeed.services.jsp.tags;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;


// JetSpeed Classes
import org.apache.jetspeed.services.TemplateLocator;

// Turbine Classes
import org.apache.turbine.modules.NavigationLoader;
import org.apache.turbine.util.RunData;
import org.apache.turbine.services.template.TemplateService;
import org.apache.turbine.services.jsp.JspService;
import org.apache.turbine.services.TurbineServices;

// Jetspeed classes
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

/**
 * Supporting class for the navigation tag.
 * Includes a navigation JSP. If the respective tag parameter is set,
 * different JSPs will be choosen, depending on whether the user has 
 * already logged in or not.
 *
 * @author <a href="mailto:ingo@raleigh.ibm.com">Ingo Schuster</a>
 */
public class NavigationTag extends TagSupport 
{
    /**
     * Static initialization of the logger for this class
     */    
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(NavigationTag.class.getName());
    
    /**
     * defaultTemplate parameter defines the template whose contents will replace
     * this tag in the layout if none of the special states are detected.
     */
    private String defaultTemplate;

    /** 
     * The setter for DefaultTemplate parameter
     */
    public void setDefaultTemplate(String defaultTemplate) 
    {
        this.defaultTemplate = defaultTemplate;
    }

    /**
     * loggedInTemplate parameter defines the template whose contents will replace
     * this tag in the layout if the user is already logged into the system.
     */
    private String loggedInTemplate;

    /** 
     * The setter for loggedInTemplate parameter
     */
    public void setLoggedInTemplate(String loggedInTemplate) 
    {
        this.loggedInTemplate = loggedInTemplate;
    }


    /**
     * Method called when the tag is encountered to send the navigation
     * template's contents to the output stream
     *
     * @return SKIP_BODY, as it is intended to be a single tag.
     */
    public int doStartTag() throws JspException 
    {
        String template = defaultTemplate;
        String module   = null;

        RunData data = (RunData)pageContext.getAttribute(JspService.RUNDATA, PageContext.REQUEST_SCOPE);
        try
        {  
            /* LOGGED_IN */
            if ( (data != null) && (data.getUser() != null) && data.getUser().hasLoggedIn() && (loggedInTemplate != null) ) 
              template = loggedInTemplate;

            data.getTemplateInfo().setNavigationTemplate(
                        TemplateLocator.locateNavigationTemplate(data,template));

            pageContext.getOut().flush();
            module = ((TemplateService)TurbineServices.getInstance().getService(
            TemplateService.SERVICE_NAME)).getNavigationName(template);
            NavigationLoader.getInstance().exec(data, module);
        }
        catch (Exception e)
        {
            String message = "Error processing navigation template:" + template + " using module: " + module;
            logger.error(message, e);
            try
            {
                data.getOut().print("Error processing navigation template: " + template + " using module: " + module);
            }
            catch(java.io.IOException ioe) {}    
        }
        return SKIP_BODY;
    }
}
