/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.jetspeed.services.forward;

import java.util.Collection;
import java.util.Map;
import java.util.Iterator;

// Junit imports
import junit.framework.Test;
import junit.framework.TestSuite;


import org.apache.jetspeed.test.HeadlessBaseTest;
import org.apache.jetspeed.util.ServiceUtil;

import org.apache.jetspeed.services.forward.configuration.Forward;
import org.apache.jetspeed.services.forward.configuration.PortletForward;
import org.apache.jetspeed.services.forward.configuration.Page;
import org.apache.jetspeed.services.forward.configuration.Pane;
import org.apache.jetspeed.services.forward.configuration.Portlet;
import org.apache.jetspeed.services.forward.configuration.QueryParam;

/**
 * Test Forward service basics.
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: TestForwardService.java,v 1.3 2003/08/05 19:08:34 jford Exp $
 */

public class TestForwardService extends HeadlessBaseTest
{
    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestForwardService( String name ) {
        super( name );
    }

    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[]) {
        junit.awtui.TestRunner.main( new String[] { TestForwardService.class.getName() } );
    }

    public void setup() {
        System.out.println("Setup: Testing TestForwardService");
     }

    public static Test suite()
    {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite( TestForwardService.class );
    }


      ///////////////////////////////////////////////////////////////////////////

    public void testConfiguration() throws Exception
    {
        try
        {
            System.out.println("Running TestForwardService");
            ForwardService fs = (ForwardService)ServiceUtil.getServiceByName("ForwardService");
            assertNotNull(fs);
            Collection forwards = fs.getForwards();
            Iterator it = forwards.iterator();
            while (it.hasNext())
            {
                System.out.println("-------------------------------------------");

                Forward forward = (Forward)it.next();
                System.out.println("forward = " + forward.getName());
                Page page = forward.getPage();
                Pane pane = forward.getPane();
                Portlet portlet = forward.getPortlet();
                if (page != null)
                {
                    System.out.println("page = " + page.getName() + ", user = " + page.getUser());
                }
                if (pane != null)
                {
                    System.out.println("pane = " + pane.getId());
                }
                if (portlet != null)
                {
                    System.out.println("portlet = " + portlet.getId() + ", action = " + portlet.getAction());
                }
                printQueryParams(forward.getQueryParams());
            }
            Collection pfs = fs.getPortletForwards();
            it = pfs.iterator();
            while (it.hasNext())
            {
                System.out.println("-------------------------------------------");

                PortletForward pf = (PortletForward)it.next();
                System.out.println("PF: portlet = " + pf.getPortlet() + ", forward = " + pf.getForward() + ", target = " + pf.getTarget());
                printQueryParams(pf.getQueryParams());
            }

            System.out.println("End Run TestForwardService");
        }
        catch (Throwable t)
        {
            t.printStackTrace();
        }
    }

    private void printQueryParams(Map qparams)
    {
        Iterator it = qparams.values().iterator();
        while (it.hasNext())
        {
            QueryParam qp = (QueryParam)it.next();
            System.out.println("QP: name = " + qp.getName() + ", value = " + qp.getValue());
        }

    }

        
}
