/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services;

//standard java stuff
import java.io.Reader;

// jetspeed stuff
import org.apache.jetspeed.services.transformer.TransformerService;

// turbine stuff
import org.apache.turbine.services.TurbineServices;


/**
 * <P>This is a commodity static accessor class around the 
 * <code>TransformerService</code></P>
 * 
 * @see org.apache.jetspeed.services.transformer.TransformerService
 * @author <a href="mailto:mmari@ce.unipr.it">Marco Mari</a>
 * @version $Id: Transformer.java,v 1.1 2003/09/05 17:56:46 morciuch Exp $ 
 */
public class Transformer {
 
    /** 
     * Commodity method for getting a reference to the service
     * singleton
     */
    private static TransformerService getService() 
    {
        return (TransformerService)TurbineServices
                .getInstance()
                .getService(TransformerService.SERVICE_NAME);     
    }
    
    /**
     * @see org.apache.jetspeed.services.transformer.TransformerService#findElement
     */
    public static String findElement(Reader htmlReader, String url, String element)  
    {
        return getService().findElement(htmlReader, url, element);
    }

    /**
     * @see org.apache.jetspeed.services.transformer.TransformerService#clipElements
     */
    public static String clipElements(Reader htmlReader, 
                                       String url, 
                                       String startElement, 
                                       String stopElement)
    {
        return getService().clipElements(htmlReader, url, startElement, stopElement);
    }

    /**
     * @see org.apache.jetspeed.services.transformer.TransformerService#findElementNumber
     */
    public static String findElementNumber(Reader htmlReader, 
                                            String url, 
                                            String element, 
                                            int    tagNumber)  
    {
        return getService().findElementNumber(htmlReader, url, element, tagNumber);
    }

     /**
     * @see org.apache.jetspeed.services.transformer.TransformerService#clipElementsNumber
     */
    public static String clipElementsNumber(Reader htmlReader, 
                                             String url, 
                                             String startElement, 
                                             String stopElement,
                                             int    tagNumber)
    {
        return getService().clipElementsNumber(htmlReader, 
                                                url, 
                                                startElement, 
                                                stopElement, 
                                                tagNumber);
    }
}
