/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services;

import java.util.Iterator;
import java.security.Principal;

// Turbine
import org.apache.turbine.services.TurbineServices;

// Jetspeed
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.security.UserManagement;
import org.apache.jetspeed.services.security.JetspeedSecurityException;



/**
 * Static accessor for the PortalAccessController service
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: JetspeedUserManagement.java,v 1.3 2003/03/04 00:05:07 sgala Exp $
 */
public abstract class JetspeedUserManagement
{
        
    /*
     * Utility method for accessing the service
     * implementation
     *
     * @return a UserManagement implementation instance
     */
    protected static UserManagement getService()
    {
        return (UserManagement)TurbineServices
        .getInstance().getService(UserManagement.SERVICE_NAME);
    }
    
    /**
     * @see org.apache.jetspeed.services.security.UserManagement#getUser
     */
    public static JetspeedUser getUser(Principal principal)
        throws JetspeedSecurityException
    {
        return getService().getUser(principal);
    }

    /**
     * @see org.apache.jetspeed.services.security.UserManagement#getUsers
     */
    public static Iterator getUsers()
        throws JetspeedSecurityException
    {
        return getService().getUsers();
    }

    /**
     * @see org.apache.jetspeed.services.security.UserManagement#getUsers
     */
    public static Iterator getUsers(String filter)
        throws JetspeedSecurityException
    {
        return getService().getUsers(filter);
    }

    /**
     * @see org.apache.jetspeed.services.security.UserManagement#saveUser
     */
    public static void saveUser(JetspeedUser user)
        throws JetspeedSecurityException
    {
        getService().saveUser(user);
    }
    
    /**
     * @see org.apache.jetspeed.services.security.UserManagement#addUser
     */
    public static void addUser(JetspeedUser user)
        throws JetspeedSecurityException
    {
        getService().addUser(user);
    }

    /**
     * @see org.apache.jetspeed.services.security.UserManagement#removeUser
     */
    public static void removeUser(Principal principal)
        throws JetspeedSecurityException
    {
        getService().removeUser(principal);
    }
    
    ///////////////////////////////////////////////////////////////////////
    // Credentials Management
    //////////////////////////////////////////////////////////////////////

    /**
     * @see org.apache.jetspeed.services.security.UserManagement#changePassword
     */
    public static void changePassword( JetspeedUser user,
                         String oldPassword, 
                         String newPassword )
        throws JetspeedSecurityException
    {
        getService().changePassword(user, oldPassword, newPassword);
    }

    /**
     * @see org.apache.jetspeed.services.security.UserManagement#forcePassword
     */
    public static void forcePassword( JetspeedUser user, String password )
        throws JetspeedSecurityException
    {
        getService().forcePassword(user, password);
    }


    /**
     * @see org.apache.jetspeed.services.security.UserManagement#encryptPassword
     */
    public static String encryptPassword( String password )
        throws JetspeedSecurityException
    {
        return getService().encryptPassword(password);
    }

}

