/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.jetspeed.portal.portlets.viewprocessor;

// Jetspeed apis
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletException;

// XML stuff
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * <p>Portlet which renders RDF Site Summary.</p>
 * <p>This portlet uses XML stylesheet for transforming the RSS
 * content into display markup depending on the MimeType requested
 * by the user-agent</p>
 * <p>It accepts the following parameters :
 * <dl>
 * <dt>itemDisplayed</dt>
 * <dd>The number of items from the RSS file to display on screen. Default 15 for HTML, 5 for WML</dd>
 * <dt>showDescription</dt>
 * <dd>Should the portlet show the item descriptions. Must be true or false. Default: true for HTML, false for WML</dd>
 * <dt>showTitle</dt>
 * <dd>Should the portlet show the channel description. Must be true or false. Default: true for HTML, false for WML</dd>
 * <dt>stylesheet[.<mime>]</dt>
 * <dd>The stylesheet URL. If a mime-type is specified, the stylesheet
 * is only used for this mime-type</dd>
 * </dl>
 * 
 * @author <A HREF="mailto:raphael@apache.org">Raphal Luta</A>
 * @version $Id: $
 * @since 1.4b4
 */
public class RSSViewProcessor extends XSLViewProcessor
{

    /**
     * This method loads the init parameters and
     * parse the document tied to this portlet
     * 
     * @param portlet
     * @exception PortletException
     */
    public void init(Portlet portlet)
    throws PortletException
    {

        super.init(portlet);

        //Determine title and description for this portlet
        String title = null;
        String description = null;

        //now find the channel node.
        Node channel = null;
        NodeList list = this.document.getElementsByTagName("channel");

        if (list.getLength() != 1)
        {
            throw new PortletException(ERROR_NOT_VALID);
        }

        channel = list.item(0);

        Node tn = getNode( channel, "title" );

        if ( tn == null ) {
            throw new PortletException( ERROR_NOT_VALID );
        } 
        else 
        {
            Node fc = tn.getFirstChild();
            if (fc != null)
            {
                title = fc.getNodeValue();
            }
        }

        Node dn = getNode( channel, "description" );

        if ( dn != null ) 
        {
            Node fc = dn.getFirstChild();
            if (fc != null)
            {
                description = fc.getNodeValue();
            }
        }

        portlet.setTitle(title);
        portlet.setDescription(description);
    }

}
