/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal.portlets.admin;

//Element Construction Set
import org.apache.ecs.html.B;
import org.apache.ecs.html.BR;
import org.apache.ecs.html.HR;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.ElementContainer;

//Jetspeed stuff
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.portlets.AbstractPortlet;
import org.apache.jetspeed.services.portletcache.GlobalCache;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.threadpool.ThreadPoolService;
import org.apache.jetspeed.services.threadpool.JetspeedThreadPoolService;
import org.apache.jetspeed.services.urlmanager.URLManager;
import org.apache.jetspeed.services.urlmanager.URLManagerService;
import org.apache.jetspeed.services.urlmanager.URLFetcher;


//turbine
import org.apache.turbine.util.RunData;
import org.apache.turbine.services.TurbineServices;

/**
Returns global information about Jetspeed.

@author <a href="mailto:burton@apache.org">Kevin A. Burton</a>
@version $Id: GlobalAdminPortlet.java,v 1.17 2003/03/04 00:05:06 sgala Exp $ 
*/
public class GlobalAdminPortlet extends AbstractPortlet {

    
    /**
     * Return general runtime information. This include memory,
     * thread, Registry, Resource, and caching data.
     *
     * @param rundata RunData object for the current request
     * @return ConcreteElement
     */    
    public ConcreteElement getContent( RunData rundata ) {

        
        ElementContainer ec = new ElementContainer();

        this.createCategory( ec, "Memory" );

        ec.addElement( this.getEntry( "Free Memory (K)", 
                                      Long.toString( Runtime.getRuntime().freeMemory()/1024 ) ) );
        ec.addElement( this.getEntry( "Total Memory (K)", 
                                      Long.toString( Runtime.getRuntime().totalMemory()/1024 ) ) );
        
        JetspeedThreadPoolService service =
            ( JetspeedThreadPoolService ) TurbineServices
            .getInstance()
            .getService( ThreadPoolService.SERVICE_NAME );
        
        this.createCategory( ec, "Thread Pool" );

        ec.addElement( this.getEntry( "Available threads: ", 
                            service.getAvailableThreadCount() ) );
        
        ec.addElement( this.getEntry( "Total threads: ", 
                            service.getThreadCount() ) );

        ec.addElement( this.getEntry( "Runnable queue length: ", 
                            service.getQueueLength() ) );

        ec.addElement( this.getEntry( "Processed thread count: ", 
                            service.getThreadProcessedCount() ) );

        this.createCategory( ec, "PortletRegistry" );

        ec.addElement( this.getEntry( "Number of entries: ", 
                            Registry.get(Registry.PORTLET).getEntryCount() ) );

        this.createCategory( ec, "Resource Manager" );

        ec.addElement( this.getEntry( "Entries in Manager", 
                                      URLManager.list( URLManagerService.STATUS_ANY ).size() ) );
        ec.addElement( this.getEntry( "Bad Entries", 
                                      URLManager.list( URLManagerService.STATUS_BAD ).size() ) );
        ec.addElement( this.getEntry( "URLs Loading/Refreshing", 
                                      URLFetcher.getRealtimeURLs().size() ) );

        this.createCategory( ec, "Global Memory Cache" );
        ec.addElement( this.getEntry( "Objects in Cache",
          GlobalCache.getNumberOfObjects()));

        return ec;
        
    }

    /**
    Create a category within this portlet
    */
    private void createCategory( ElementContainer ec, 
                                 String title ) {


        ec.addElement( new HR() );
        ec.addElement( new B().addElement( title + ":" ) );
        ec.addElement( new BR() );
                                     
    }

    private ConcreteElement getEntry( String title,
                                      int value ) {
        return getEntry( title, Integer.toString( value ) );
    }
    
    private ConcreteElement getEntry( String title, 
                                      String value ) {
        
        ElementContainer ec = new ElementContainer();
        
        ec.addElement( title );
        ec.addElement( " -> " );
        ec.addElement( value );
        ec.addElement( new BR() );
        
        return ec;
    }
    
    //requried info
    /**
     * @see AbstractPortlet#init
     */    
    
    public void init() throws PortletException {

        this.setTitle( "Global" );
        this.setDescription( "Global information..." );

    }

    /**
     * @see AbstractPortlet#getAllowEdit
     */    
    public boolean getAllowEdit(RunData rundata) {
        return false;
    }

    /**
     * @see AbstractPortlet#getAllowMaximize
     */    
    public boolean getAllowMaximize(RunData rundata) {
        return false;
    }

}
