package org.apache.jetspeed.portal.portlets;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

// jetspeed
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.services.PortletFactory;
import org.apache.jetspeed.portal.PortletControl;
import org.apache.jetspeed.services.PortalToolkit;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;

// ecs
import org.apache.jetspeed.util.JetspeedClearElement;
import org.apache.ecs.ConcreteElement;

// turbine
import org.apache.turbine.util.RunData;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.velocity.context.Context;

/**
 * Preview portlet. Displays content of potlet
 * defined in parameter "previewedPortletName".
 * 
 * @version $Id: PreviewPortlet.java,v 1.4 2003/07/23 19:50:17 morciuch Exp $ 
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a> 
 * @author <a href="mailto:mark_orciuch@ngsltd.com">Mark Orciuch</a>
 */
public class PreviewPortlet extends AbstractPortlet
{

    /**
     * Static initialization of the logger for this class
     */    
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(PreviewPortlet.class.getName());
    
    /**
     * @param rundata The RunData object for the current request
     */
    public ConcreteElement getContent(RunData rundata)
    {

        Context context = TurbineVelocity.getContext(rundata);
        context.put( "data", rundata);
        TurbineVelocity.getContext(rundata).put("jetspeed", new org.apache.jetspeed.util.template.JetspeedTool(rundata));

        ConcreteElement result = null;
        String controlName = rundata.getParameters().getString("previewedControlName");
        String portletName = rundata.getParameters().getString("previewedPortletName");
        if ( portletName == null )
        {
            JetspeedLink jsLink = null;

            try
            {
                jsLink = JetspeedLinkFactory.getInstance(rundata);
                rundata.setRedirectURI(
                    jsLink.setUser(
                        rundata.getUser().getUserName(), "default.psml")
                    .addPathInfo("template", "Customize")
                    .addPathInfo("media-type", "html")
                    .toString()
                    );
                JetspeedLinkFactory.putInstance(jsLink);
                jsLink = null;
                return new JetspeedClearElement("");
            } catch (Exception e)
            {
                logger.error("Exception",  e);
                rundata.setScreenTemplate("Home");
                return new JetspeedClearElement("");
            }
            //return new JetspeedClearElement("You must specify portlet to preview using [previewedPortletName] parameter");
        }
        Portlet portlet = null;

        try
        {
            portlet = PortletFactory.getPortlet(portletName, "PreviewPortlet");
            PortletControl control = controlName == null ? PortalToolkit.getControl((String)null) :
                                     PortalToolkit.getControl(controlName);
            control = null;
            if ( control != null )
            {
                JetspeedRunData jdata = (JetspeedRunData)rundata;
                // Use the profile's skin
                //portlet.getPortletConfig().setSkin(PortalToolkit.getSkin(jdata.getProfile().getDocument().getPortlets().getSkin()));
                control.setPortlet(portlet);
                control.init();
                result = control.getContent(rundata);
            } 
            else if ( portlet != null )
            {
                result = portlet.getContent(rundata);
            }

            if ( result != null && !result.toString().equals("") )
            {
                /*String html =  result.toString();
                String currentURL = rundata.getRequest().getRequestURI();
                Log.debug("PreviewPortlet: currentURL = " + currentURL + " reader value = " + html);
                PreviewRewriter rewriter = new PreviewRewriter(currentURL, currentURL , currentURL, portletName);
                result = new JetspeedClearElement(rewriter.rewrite(new StringReader(html)));*/
            } 
            else
            {
                // The portlet already streamed its content - return a stub
                result = new JetspeedClearElement("");
            }

        } 
        catch ( Exception e )
        {
            logger.error("Exception",  e);
            result = new JetspeedClearElement("This resource is temporarily unavailable");
        }

        rundata.setLayout("preview");
        return result;
    }

}
