/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal;

// Turbine stuff
import org.apache.turbine.util.RunData;

/**
 * This interface allows implementing portlets to modify the
 * behavior of their PortletControl manager by specifically allowing or
 * refusing window manipulation actions.
 * If the given PortletControl implements these actions, it must use
 * this information.
 *
 * @author <a href="mailto:raphael@apache.org">Raphal Luta</a>
 * @author <a href="mailto:re_carrasco@bco011.sonda.cl">Roberto Carrasco</a>
 * @author <a href="mailto:morciuch@apache.org">Mark Orciuch</a> 
 */
public interface PortletState
{

    /**
     * Returns true if the portlet allows the use to remove it from its portlat
     * page
     *
     * @param rundata the RunData object for the current request
     */
    public boolean allowClose( RunData rundata );

    /**
     * Returns true if this portlet is currently closed
     */
    public boolean isClosed(RunData data);

    /**
     * Toggles the portlet state between closed and normal
     *
     * @param minimized the new portlet state
     * @param data the RunData for this request
     */
    public void setClosed(boolean closed, RunData data);

    /**
     * Returns true if the portlet allows the manager to link to a information
     * page about this portlet
     *
     * @param rundata the RunData object for the current request
     */
    public boolean allowInfo( RunData rundata );

    /**
     * Returns true if the portlet supports customization of its options
     *
     * @param rundata the RunData object for the current request
     */
    public boolean allowCustomize( RunData rundata );

    /**
     * Returns true if the portlet allows the user to maximize it, ie use
     * all the display space allowed to portlets in the given pane
     *
     * @param rundata the RunData object for the current request
     */
    public boolean allowMaximize( RunData rundata );

    /**
     * Returns true if the portlet allows the user to minimize it.
     * The portlet content is not displayed when minimized
     *
     * @param rundata the RunData object for the current request
     */
    public boolean allowMinimize( RunData rundata );

    /**
     * Returns true if this portlet is currently minimized
     */
    public boolean isMinimized(RunData data);

    /**
     * Toggles the portlet state between minimized and normal
     *
     * @param minimized the new portlet state
     * @param data the RunData for this request
     */
    public void setMinimized(boolean minimized, RunData data);

    /**
     * Returns true if the portlet allows the user to display it in print friendly format.
     *
     * @param rundata the RunData object for the current request
     */
    public boolean allowPrintFriendly( RunData rundata );

}
