/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal;

import org.apache.jetspeed.util.MimeType;
import org.apache.turbine.util.RunData;
import org.apache.ecs.ConcreteElement;
import java.util.Map;
import java.io.Serializable;

/**
 * A PortletController is responsible for laying out and rendering the content of 
 * a PortletSet. 
 * <p>As such, it also provides 2 additionnal services :
 * <ul>
 *   <li>factory for the creating appropriate PortletSet;Constraints
 *   <li>customization facilities for handling the addition of a new portlet
 *       within the set and moving entries around within the set
 * </ul>
 *
 * @author <a href="mailto:raphael@apache.org">Raphal Luta</a>
 * @author <a href="mailto:burton@apache.org">Kevin A. Burton</a>
 * @version $Id: PortletController.java,v 1.53 2002/09/26 17:35:58 taylor Exp $
 */
public interface PortletController extends Serializable
{

    /**
     * Initialize this PortletController. This method must be called after
     * the Config object has been set and whenever it is changed
     */
    public void init();

    /**
     * Sets the configuration object for this controller instance
     *
     * @param conf the controller configuration
     */
    public void setConfig(PortletControllerConfig conf);

    /**
     * Returns the configuration object for this object
     *
     * @return a configuration object
     */
    public PortletControllerConfig getConfig();

    /**
     * Sets the PotletSet to render by this controller
     *
     * @param portlets the portlet set to render
     */
    public void setPortlets(PortletSet portlets);

    /**
     * Returns the PortletSet to render by this controller
     *
     * @return the portlet set that should currently be rendered by this
     * controller
     */
    public PortletSet getPortlets();

    /**
     * Renders the content of the PortletSet for the current request
     * 
     * @param rundata the RunData for the request
     * @return the rendered content for this set or null if the content
     * was written directly on the writer available in RunData
     */
    public ConcreteElement getContent( RunData rundata );

    /**
     * Tests whether the controller supports outputting content for 
     * a specific mime type
     *
     * @param mimeType the requested mime type
     * @return true if the requested mime type is supported by this controller
     */
    public boolean supportsType( MimeType mimeType );
        
    /**
     * Creates a constraint object based on an original source.
     *
     * @param original the source for this constraint object
     * @return a new Constraints object appropriate for this controller
     */
    public PortletSet.Constraints getConstraints( Map original );
        
}
