/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal;

//standard java stuff
import java.util.Map;

//jetspeed support
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.om.SecurityReference;
import org.apache.jetspeed.util.Config;
import org.apache.jetspeed.util.MetaData;

/**
Defines a configuration for Portlets.  A PortletConfig provides information
about the running environment of a given Portlet.

@author <a href="mailto:burton@apache.org">Kevin A. Burton</a>
@version $Id: PortletConfig.java,v 1.49 2002/06/30 05:23:19 paulsp Exp $
*/

public interface PortletConfig extends Config
{
    
    /**
    Init this PortletConfig providing the basic info.
    */
    public void init( String url, Map init_params );

    /**
    Returns the portlet current PortletSet
    */
    public PortletSet getPortletSet();

    /**
    Set the context (PortletSet) for this portlet
    */
    public void setPortletSet(PortletSet set);

    /**
    Returns the portlet current PortletSet
    */
    public Map getLayout();

    /**
    Set the context (PortletSet) for this portlet
    */
    public void setLayout(Map constraints);

    /**
     * Returns the current skin mapping.  This method is used for configuration.  Use
     * getPortletSkin() to find skin use by the Layout engine.
     *
     * @return Current skin mapping or null if no skin is defined in PSML.
     */
    public Map getSkin();

    /**
     * Set the context (PortletSet) for this portlet
     *
     * @deprecated use setPortletSkin instead
     */
    public void setSkin(Map skin);

    /**
    Returns the portlet current PortletSet
    */
    public int getPosition();

    /**
    Set the context (PortletSet) for this portlet
    */
    public void setPosition(int position);

    /**
    Returns this Portlet's Metainfo or null it none exists.  The Metainfo can
    be used to determine an optional title or description for this Portlet.
    */
    public MetaData getMetainfo();

    /**
    Set the metainfo for the Portlet
    */
    public void setMetainfo(MetaData metainfo);

    /**
    Portlets can have external configuration information other than just
    parameters.  A URL can define an external configuration file or HTML file
    that this Portlet can parse out.

    The main reason for using setURL/getURL is because the remote URL is cached
    within Jetspeed so future requests won't have any latency.
    */
    public String getURL();

    /**
    Used to define a Portlet's URL.
    */
    public void setURL(String url);

    /**
     * Determines whether to use the URL as part of the unique id to the portlet cache.
     * This can be used to control the lifetime of the portlet. 
     * The URL is used in combination with the parameter names and values for this portlet
     * to uniquely identify to portlet. Parameters may also be optionally included in the cache key.
     * This value can be set in the portlet registry.
     *
     * @return true if the URL is to be part of the cache key.
     */
    public boolean isCachedOnURL();

    /**
     * Determines whether to use the URL as part of the unique id to the portlet cache.
     * This can be used to control the lifetime of the portlet. 
     * The URL is used in combination with the parameter names and values for this portlet
     * to uniquely identify to portlet. Parameters may also be optionally included in the cache key.
     * This value can be set in the portlet registry.
     *
     * @return cached set to true if want this portlet to be cached based on the url
     */
    public void setCachedOnURL(boolean cached);


    /**
    Returns a parameter (or defaultValue) that was given to a Portlet.  This can be
    by a Portlet to obtain further information of itself.
    The parameter is returned even if it is defined in the context and not directly
    in the portlet config
    */
    public String getLayout(String name, String defaultValue);

    /**
    Returns a parameter (or defaultValue) that was given to a Portlet.  This can be
    by a Portlet to obtain further information of itself.
    The parameter is returned even if it is defined in the context and not directly
    in the portlet config
    */
    public String getSkin(String name, String defaultValue);

    /**
    Sets a skin parameter value in the local config
    */
    public void setSkin(String name, String value);

    /**
     * Retrieves the Skin object that should be used for this portlet. If 
     * the current portlet does not have a skin, then skin is retrieve from
     * the parent portlet set of the system default is now skins are defined
     * in the portlet set.
     *
     * getSkin() can be used for configuration.
     *
     * @return the Skin object that should be used.
     */
    public PortletSkin getPortletSkin();
    
    /**
     * Sets the PortletSkin to use for this Portlet
     *
     * @param skin the new skin to use
     */
    public void setPortletSkin(PortletSkin skin);
    
    /**
     * Retrieves the constraints associated with this portlet
     *
     * @return the Constraints object
     */
    public PortletSet.Constraints getConstraints();
    
    /**
     * Sets the layout constraints in the current portlet set
     *
     * @param constraints the constrints object associated with this portlet
     * in the current set
     */
    public void setConstraints(PortletSet.Constraints constraints);
    
    /**
    */
    public CapabilityMap getCapabilityMap();
    
    /**
    */
    public void setCapabilityMap( CapabilityMap cm );

    public void setPortletId(String portletId);
    public String getPortletId();
    public void setPageId(String pageId);
    public String getPageId();
    
    /** Getter for property securityRef.
     * @return Value of property securityRef.
     */
    public SecurityReference getSecurityRef();
    
    /** Setter for property securityRef.
     * @param securityRef New value of property securityRef.
     */
    public void setSecurityRef(SecurityReference securityRef);
    
}
