package org.apache.jetspeed.modules.parameters;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

// Java stuff
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

// Jetspeed
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.QueryLocator;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.PortletUtils;
import org.apache.jetspeed.modules.actions.portlets.PsmlManagerAction;

// Turbine stuff
import org.apache.turbine.util.RunData;

// Velocity stuff
import org.apache.velocity.context.Context;

/**
 * Returns list box control populated with pmsl pages for current user for current media type.
 * @author <a href="morciuch@apache.org">Mark Orciuch</a>
 * @version $Id: MyPagesListBox.java,v 1.4 2003/10/13 19:47:21 morciuch Exp $  
 */

public class MyPagesListBox extends VelocityParameterPresentationStyle
{

    /**
     * Static initialization of the logger for this class
     */    
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(MyPagesListBox.class.getName());     
    
    /**
     * Put custom objects in the velocity context
     * 
     * @param data
     * @param name
     * @param value
     * @param parms
     * @param context
     */
    public void buildContext(RunData rundata, String name, String value, Map parms, Context context)
    {
        Map entries = null;

        try
        {
            entries = (Map) rundata.getUser().getTemp(PsmlManagerAction.CACHED_PSML);
            if (entries == null)
            {            
                // Initialize the query locator
                QueryLocator ql = new QueryLocator(QueryLocator.QUERY_USER);

                JetspeedRunData jdata = (JetspeedRunData) rundata;
                ql.setUser(jdata.getJetspeedUser());
                //ql.setMediaType(jdata.getCapability().getPreferredMediaType());
                entries = new Hashtable();
                Iterator i = Profiler.query(ql);
                while (i.hasNext())
                {
                    Profile profile = (Profile) i.next();

                    String mediaType = profile.getMediaType();
                    if (mediaType != null && mediaType.equals(jdata.getCapability().getPreferredMediaType()))
                    {
                        if (PortletUtils.canAccessProfile(rundata, profile))
                        {
                            if (logger.isDebugEnabled())
                            {
                                logger.debug("MyPagesListBox: refreshing user profile list: " + profile.getPath());
                            }
                            String title = profile.getName();
                            if (profile.getRootSet() != null && profile.getRootSet().getTitle() != null)
                            {
                                title = profile.getRootSet().getTitle();
                            }
                            entries.put(profile, title);                
                        }
                    }
                }

                rundata.getUser().setTemp(PsmlManagerAction.CACHED_PSML, entries);
            }

            context.put("pages", entries);
        }
        catch (Exception e)
        {
            logger.error("Exception", e);
        }

    }

}