/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
 
package org.apache.jetspeed.modules.actions.portlets;


import java.lang.reflect.Method;

import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;


// Turbine stuff
import org.apache.turbine.util.RunData;


// Velocity Stuff
import org.apache.velocity.context.Context;


/**
 * An abstract action class to build VelocityPortlet actions.
 * 
 * <p>Don't call it from the URL, the Portlet and the Action are automatically
 * associated through the registry PortletName
 *  <p>
 *  <strong>NOTE:</strong>This supports the pre-MVC style of template based 
 *   portlet development and is supplied for backward compatibility.   It is
 *  suggested you  use a combination of 
 *  @see org.apache.jetspeed.portal.portlets.GenericMVCPortlet along with
 *  subclassing @see org.apache.jetspeed.portal.portlets.GenericMVCAction
 *  for future portlet development.
 *  </p>
 * 
 * @author <a href="mailto:raphael@apache.org">Raphal Luta</a>
 * @author <a href="mailto:re_carrasco@bco011.sonda.cl">Roberto Carrasco</a>
 *
 * @version $Id: VelocityPortletAction.java,v 1.13 2003/03/24 01:10:13 weaver Exp $
 */
public abstract class VelocityPortletAction extends GenericMVCAction
{



    /** 
     * Subclasses must override this method to provide default behavior 
     * for the portlet action    
     */
    protected abstract void buildNormalContext(VelocityPortlet portlet, 
                                                Context context,
                                                RunData rundata)
        throws Exception;

    /**
     * STW: Backwards compatibility so the overriden method is called specifically using a cast to VelocityPortlet
     * @see org.apache.jetspeed.portal.portlets.mvc.PortletAction#buildNormalContext(Portlet, Context, RunData)
     */
    protected void buildNormalContext(Portlet portlet, Context context, RunData data)
        throws Exception
    {
        buildNormalContext((VelocityPortlet) portlet, context, data);
    }

    /**
     * @see org.apache.jetspeed.portal.portlets.mvc.PortletAction#buildConfigureContext(Portlet, Context, RunData)
     */
    protected void buildConfigureContext(Portlet portlet, Context context, RunData data)
        throws Exception
    {
        // STW: Don't try this at home, kids.  It's about the worst reflection hack you
        // can commit.  However, it was the only to have VelocityPortletAction implement
        // GenericMVCAction an still work correctly.  The sypmtom we where experiencing
        // was that we where skipping over the overriden method in the inheriting class
        // due to the ambiguousness of the build*() method signatures (VelocityPortlet vs. Portlet)
        // This only happens when the class subclassing VelocityPortlet defines a build*()
        // method with the signature build*(VelocityPortlet, Context, RunData), which is 100%
        // of the time with any previously defined Actions subclassing VelocityPortletAction.
        // Defining build*(Portlet, Context, RunData) fixes the problem but can't expect 
        // everyone to go back and change all of there Action method signatures just to
        // fix this.  Eventually we should deprecate this class all together.
        try
        {
            Method method =
                this.getClass().getDeclaredMethod(
                    "buildConfigureContext",
                    new Class[] { VelocityPortlet.class, Context.class, RunData.class });
            method.setAccessible(true);
            method.invoke(this, new Object[] { portlet, context, data });
            method.setAccessible(false);

        }
        catch (NoSuchMethodException e)
        {
            // Subclass did not override this method
            super.buildConfigureContext(portlet, context, data);
        }
        
    }
    
    /**
     * prevents possible self-referencing loop when sub-classes invoke super.buildConfigureContext().
     * @author <a href="mailto:weaver@apache.org">Scott T. Weaver</a>
     */
    protected void buildConfigureContext(VelocityPortlet portlet, Context context, RunData data)
        throws Exception
    {
    }
    
    
    protected void buildMaximizedContext(Portlet portlet, Context context, RunData data)
        throws Exception
    {
        // STW: Don't try this at home, kids.  It's about the worst reflection hack you
        // can commit.  However, it was the only to have VelocityPortletAction implement
        // GenericMVCAction an still work correctly.  The sypmtom we where experiencing
        // was that we where skipping over the overriden method in the inheriting class
        // due to the ambiguousness of the build*() method signatures (VelocityPortlet vs. Portlet)
        // This only happens when the class subclassing VelocityPortlet defines a build*()
        // method with the signature build*(VelocityPortlet, Context, RunData), which is 100%
        // of the time with any previously defined Actions subclassing VelocityPortletAction.
        // Defining build*(Portlet, Context, RunData) fixes the problem but can't expect 
        // everyone to go back and change all of there Action method signatures just to
        // fix this.  Eventually we should deprecate this class all together.
        try
        {
            Method method =
                this.getClass().getDeclaredMethod(
                    "buildMaximizedContext",
                    new Class[] { VelocityPortlet.class, Context.class, RunData.class });
            method.setAccessible(true);
            method.invoke(this, new Object[] { portlet, context, data });
            method.setAccessible(false);
        }
        catch (NoSuchMethodException e)
        {
            // Subclass did not override this method
            super.buildMaximizedContext(portlet, context, data);
        }
    }
    
    /**
     * prevents possible self-referencing loop when sub-classes invoke super.buildMaximizedContext().
     * @author <a href="mailto:weaver@apache.org">Scott T. Weaver</a>
     */
    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData data)
        throws Exception
    {
    }
    
   
   

}
