/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.capability;

// Junit imports
import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.turbine.util.TurbineConfig;
import org.apache.turbine.util.StringUtils;

// Jetspeed imports
import org.apache.jetspeed.test.JetspeedTestCase;
import org.apache.jetspeed.capability.CapabilityMapFactory;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.om.registry.ClientRegistry;
import org.apache.jetspeed.om.registry.ClientEntry;
import org.apache.jetspeed.util.MimeType;

/**
 * Unit test for capbility package
 *
 * @author <a href="raphael@apache.org">Raphal Luta</a>
 * @version $Id: TestCapabilityMap.java,v 1.2 2003/08/08 18:28:03 morciuch Exp $
 */

public class TestCapabilityMap extends JetspeedTestCase
{
    
    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestCapabilityMap( String name )
    {
        super( name );
    }

    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[])
    {
        junit.awtui.TestRunner.main( new String[] { TestCapabilityMap.class.getName() } );
    }

    public void setup()
    {
        System.out.println("Setup: Testing CapabilityMap functionality");
    }
    /**
     * Creates the test suite.
     *
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     */
    public static Test suite()
    {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite( TestCapabilityMap.class );
    }

    public void testRegistry() throws Exception
    {
        try
        {
            // Make sure the Registry works
            ClientRegistry cr = (ClientRegistry)Registry.get(Registry.CLIENT);
            ClientEntry ce = (ClientEntry)cr.getEntry("ie5");
            assertNotNull(ce);
        }
        catch (Exception e)
        {
            String errmsg = "Error in test: " + e.toString();
           // e.printStackTrace();
           assertNotNull(errmsg, null);
        }
    }

    public void testDefaultMap() throws Exception
    {
        try
        {
            // first test default capailitymap
            CapabilityMap cm = CapabilityMapFactory.getDefaultCapabilityMap();
            assertNotNull(cm);
            assertTrue(cm.toString().startsWith("ns4"));
        }
        catch (Exception e)
        {
            String errmsg = "Error in test: " + e.toString();
           // e.printStackTrace();
           assertNotNull(errmsg, null);
        }
    }

    public void testStandardMap() throws Exception
    {
        try
        {
            // then test different standard browsers
            getUserAgent("ie5","Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0)");
            getUserAgent("ns4","Mozilla/4.78 (Windows 2000; U) Opera 6.01  [fr]");
            getUserAgent("mozilla","Mozilla/5.0 (Windows; U; Windows NT 5.0; en-US; rv:1.0rc1) Gecko/20020417");
            getUserAgent("nokia_generic","Nokia3330/1.0 (03.05)");
            getUserAgent("lynx","Lynx/2.8.4rel.1 libwww-FM/2.14 SSL-MM/1.4.1 OpenSSL/0.9.6b");
        }
        catch (Exception e)
        {
            String errmsg = "Error in test: " + e.toString();
           // e.printStackTrace();
           assertNotNull(errmsg, null);
        }
    }

    public void testCapabilityCheck() throws Exception
    {
        try
        {
            // test simple capabilities
            CapabilityMap cm = CapabilityMapFactory.getCapabilityMap("Mozilla/5.0 (Windows; U; Windows NT 5.0; en-US; rv:1.0rc1) Gecko/20020417");
            assertTrue(cm.hasCapability("HTML_DOM_1"));
            assertTrue(cm.hasCapability("HTML_IFRAME"));
            assertTrue(cm.supportsMimeType(MimeType.XML));
            assertTrue(cm.supportsMediaType("html"));
        }
        catch (Exception e)
        {
            String errmsg = "Error in test: " + e.toString();
           // e.printStackTrace();
           assertNotNull(errmsg, null);
        }
    }

    private void getUserAgent(String name, String ua)
    {
        CapabilityMap cm = CapabilityMapFactory.getCapabilityMap(ua);
        assertNotNull(cm);
        assertNotNull(name);
        assertTrue(cm.toString().startsWith(name));
    }

    /*
      Configuration object to run Turbine outside a servlet container
      ( uses turbine.properties )
    */
    private static TurbineConfig config = null;

    /*
      Sets up TurbineConfig using the system property:
      <pre>turbine.properties</pre>
    */
    static
    {
        try
        {
           config = new TurbineConfig( "../webapp", "/WEB-INF/conf/TurbineResources.properties");
           config.init();
        }
        catch (Exception e)
        {
            fail(StringUtils.stackTrace(e));
        }
    }
}
