/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.MultiPartEmail;

public class HtmlEmail
extends MultiPartEmail {
    private String text;
    private String html;
    private List inlineImages = new ArrayList();

    public HtmlEmail setTextMsg(String text) {
        this.text = text;
        return this;
    }

    public HtmlEmail setHtmlMsg(String html) {
        this.html = html;
        return this;
    }

    public Email setMsg(String msg) {
        this.setTextMsg(msg);
        this.setHtmlMsg("<html><body><pre>" + msg + "</pre></body></html>");
        return this;
    }

    public String embed(URL url, String name) throws MessagingException {
        MimeBodyPart mbp = new MimeBodyPart();
        mbp.setDataHandler(new DataHandler((DataSource)new URLDataSource(url)));
        mbp.setFileName(name);
        mbp.setDisposition("inline");
        String cid = RandomStringUtils.randomAscii((int)10);
        mbp.addHeader("Content-ID", cid);
        this.inlineImages.add(mbp);
        return mbp.getContentID();
    }

    public void send() throws MessagingException {
        MimeMultipart container = this.getContainer();
        container.setSubType("related");
        MimeBodyPart msgText = null;
        MimeBodyPart msgHtml = null;
        if (StringUtils.isNotEmpty((String)this.html)) {
            msgHtml = this.getPrimaryBodyPart();
            if (this.charset != null) {
                msgHtml.setContent((Object)this.html, "text/html;charset=" + this.charset);
            } else {
                msgHtml.setContent((Object)this.html, "text/html");
            }
            Iterator iter = this.inlineImages.iterator();
            while (iter.hasNext()) {
                container.addBodyPart((BodyPart)iter.next());
            }
        }
        if (StringUtils.isNotEmpty((String)this.text)) {
            if (msgHtml == null) {
                msgText = this.getPrimaryBodyPart();
            } else {
                msgText = new MimeBodyPart();
                container.addBodyPart((BodyPart)msgText);
            }
            if (this.charset != null) {
                msgText.setContent((Object)this.text, "text/plain;charset=" + this.charset);
            } else {
                msgText.setContent((Object)this.text, "text/plain");
            }
        }
        super.send();
    }

    public static final boolean isValid(String foo) {
        return StringUtils.isNotEmpty((String)foo);
    }
}

