/*
 * Decompiled with CFR 0.152.
 */
package com.workingdogs.village;

import com.workingdogs.village.DataSetException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class Value {
    private Object valueObject;
    private int columnNumber;
    private int type;

    public Value(ResultSet resultSet, int n, int n2) throws SQLException {
        this.columnNumber = n;
        this.type = n2;
        this.valueObject = null;
        if (resultSet == null) {
            return;
        }
        switch (this.type()) {
            case -7: {
                String string = resultSet.getString(n);
                if (string == null) {
                    this.valueObject = new Boolean(false);
                    break;
                }
                if (this.isTrue(string)) {
                    this.valueObject = new Boolean(true);
                    break;
                }
                this.valueObject = new Boolean(false);
                break;
            }
            case -6: {
                this.valueObject = new Byte(resultSet.getByte(n));
                break;
            }
            case -5: {
                this.valueObject = new Long(resultSet.getLong(n));
                break;
            }
            case 5: {
                this.valueObject = new Short(resultSet.getShort(n));
                break;
            }
            case 4: {
                this.valueObject = new Integer(resultSet.getInt(n));
                break;
            }
            case 7: {
                this.valueObject = new Float(resultSet.getFloat(n));
                break;
            }
            case 6: 
            case 8: {
                this.valueObject = new Double(resultSet.getDouble(n));
                break;
            }
            case 2: 
            case 3: {
                String string = resultSet.getString(n);
                if (string == null) {
                    this.valueObject = null;
                    break;
                }
                this.valueObject = new BigDecimal(string);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.valueObject = resultSet.getBytes(n);
                break;
            }
            case 2004: {
                Blob blob = resultSet.getBlob(n);
                this.valueObject = blob.getBytes(1L, (int)blob.length());
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 1111: {
                this.valueObject = resultSet.getString(n);
                break;
            }
            case 91: {
                this.valueObject = resultSet.getDate(n);
                break;
            }
            case 92: {
                this.valueObject = resultSet.getTime(n);
                break;
            }
            case 93: {
                this.valueObject = resultSet.getTimestamp(n);
                break;
            }
            case 0: {
                this.valueObject = null;
                break;
            }
            default: {
                this.valueObject = resultSet.getString(n);
            }
        }
        if (resultSet.wasNull()) {
            this.valueObject = null;
        }
    }

    void setValue(Object object) {
        this.valueObject = object;
    }

    Object getValue() {
        return this.valueObject;
    }

    void setPreparedStatementValue(PreparedStatement preparedStatement, int n) throws DataSetException, SQLException {
        if (this.isNull()) {
            preparedStatement.setNull(n, this.type());
            return;
        }
        switch (this.type()) {
            case -7: {
                preparedStatement.setBoolean(n, this.asBoolean());
                break;
            }
            case -6: {
                preparedStatement.setByte(n, this.asByte());
                break;
            }
            case -5: {
                preparedStatement.setLong(n, this.asLong());
                break;
            }
            case 5: {
                preparedStatement.setShort(n, this.asShort());
                break;
            }
            case 4: {
                preparedStatement.setInt(n, this.asInt());
                break;
            }
            case 7: {
                preparedStatement.setFloat(n, this.asFloat());
                break;
            }
            case 6: 
            case 8: {
                preparedStatement.setDouble(n, this.asDouble());
                break;
            }
            case 2: 
            case 3: {
                preparedStatement.setBigDecimal(n, this.asBigDecimal());
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                byte[] byArray = this.asBytes();
                preparedStatement.setBinaryStream(n, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 1111: {
                preparedStatement.setString(n, this.asString());
                break;
            }
            case 91: {
                preparedStatement.setDate(n, this.asDate());
                break;
            }
            case 92: {
                preparedStatement.setTime(n, this.asTime());
                break;
            }
            case 93: {
                preparedStatement.setTimestamp(n, this.asTimestamp());
                break;
            }
            case 0: {
                preparedStatement.setNull(n, 0);
                break;
            }
            default: {
                preparedStatement.setString(n, this.asString());
            }
        }
    }

    public String toString() {
        return this.asString();
    }

    public String asString() {
        if (this.isNull()) {
            return null;
        }
        if (this.isString()) {
            return (String)this.valueObject;
        }
        if (this.isBytes()) {
            return new String((byte[])this.valueObject);
        }
        return this.valueObject.toString();
    }

    public BigDecimal asBigDecimal() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isBigDecimal()) {
                return (BigDecimal)this.valueObject;
            }
            if (this.isString() || this.isDouble() || this.isFloat() || this.isInt() || this.isLong() || this.isShort() || this.isByte()) {
                return new BigDecimal(this.asString());
            }
            return null;
        }
        catch (Exception exception) {
            throw new DataSetException("Illegal conversion: " + exception.toString());
        }
    }

    public BigDecimal asBigDecimal(int n) throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isBigDecimal()) {
                return ((BigDecimal)this.valueObject).setScale(n);
            }
            if (this.isString() || this.isDouble() || this.isFloat() || this.isInt() || this.isLong() || this.isShort() || this.isByte()) {
                return new BigDecimal(this.asString()).setScale(n);
            }
            return null;
        }
        catch (Exception exception) {
            throw new DataSetException("Bad conversion: " + exception.toString());
        }
    }

    public boolean asBoolean() throws DataSetException {
        try {
            if (this.isNull()) {
                return false;
            }
            if (this.isBoolean()) {
                return (Boolean)this.valueObject;
            }
            String string = this.asString();
            if (string == null) {
                return false;
            }
            return this.isTrue(string);
        }
        catch (Exception exception) {
            throw new DataSetException("Bad conversion: " + exception.toString());
        }
    }

    public Boolean asBooleanObj() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isBoolean()) {
                return (Boolean)this.valueObject;
            }
            String string = this.asString();
            if (string == null) {
                return null;
            }
            if (this.isTrue(string)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (Exception exception) {
            throw new DataSetException("Bad conversion: " + exception.toString());
        }
    }

    public int asInt() throws DataSetException {
        try {
            if (this.isNull()) {
                return 0;
            }
            if (this.isInt()) {
                return (Integer)this.valueObject;
            }
            if (this.isString()) {
                return Integer.valueOf((String)this.valueObject);
            }
            if (this.isLong()) {
                return ((Long)this.valueObject).intValue();
            }
            if (this.isDouble()) {
                return ((Double)this.valueObject).intValue();
            }
            if (this.isFloat()) {
                return ((Float)this.valueObject).intValue();
            }
            if (this.isBigDecimal()) {
                return ((BigDecimal)this.valueObject).intValue();
            }
            return Integer.valueOf(this.asString());
        }
        catch (Exception exception) {
            throw new DataSetException("Bad conversion: " + exception.toString());
        }
    }

    public Integer asIntegerObj() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isInt()) {
                return (Integer)this.valueObject;
            }
            if (this.isString() || this.isDouble() || this.isFloat() || this.isBigDecimal() || this.isLong() || this.isShort() || this.isByte()) {
                return new Integer(this.asString());
            }
            throw new DataSetException("Invalid type for Integer");
        }
        catch (Exception exception) {
            throw new DataSetException("Illegal conversion: " + exception.toString());
        }
    }

    public byte asByte() throws DataSetException {
        try {
            if (this.isNull()) {
                return 0;
            }
            if (this.isByte()) {
                return (Byte)this.valueObject;
            }
            if (this.isString()) {
                return Integer.valueOf((String)this.valueObject).byteValue();
            }
            if (this.isShort()) {
                return ((Short)this.valueObject).byteValue();
            }
            if (this.isInt()) {
                return ((Integer)this.valueObject).byteValue();
            }
            if (this.isLong()) {
                return ((Long)this.valueObject).byteValue();
            }
            if (this.isDouble()) {
                return ((Double)this.valueObject).byteValue();
            }
            if (this.isFloat()) {
                return ((Float)this.valueObject).byteValue();
            }
            if (this.isBigDecimal()) {
                return ((BigDecimal)this.valueObject).byteValue();
            }
            return Integer.valueOf(this.asString()).byteValue();
        }
        catch (Exception exception) {
            throw new DataSetException("Bad conversion: " + exception.toString());
        }
    }

    public Byte asByteObj() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isByte()) {
                return (Byte)this.valueObject;
            }
            if (this.isString() || this.isDouble() || this.isFloat() || this.isInt() || this.isLong() || this.isShort() || this.isBigDecimal()) {
                return new Byte(this.asString());
            }
            throw new DataSetException("Invalid type for Byte");
        }
        catch (Exception exception) {
            throw new DataSetException("Illegal conversion: " + exception.toString());
        }
    }

    public byte[] asBytes() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isBytes()) {
                return (byte[])this.valueObject;
            }
            if (this.isString()) {
                return ((String)this.valueObject).getBytes();
            }
        }
        catch (Exception exception) {
            throw new DataSetException("Bad conversion: " + exception.toString());
        }
        return null;
    }

    public short asShort() throws DataSetException {
        try {
            if (this.isNull()) {
                return 0;
            }
            if (this.isShort()) {
                return (Short)this.valueObject;
            }
            if (this.isString()) {
                return Integer.valueOf((String)this.valueObject).shortValue();
            }
            if (this.isInt()) {
                return ((Integer)this.valueObject).shortValue();
            }
            if (this.isLong()) {
                return ((Long)this.valueObject).shortValue();
            }
            if (this.isDouble()) {
                return ((Double)this.valueObject).shortValue();
            }
            if (this.isFloat()) {
                return ((Float)this.valueObject).shortValue();
            }
            if (this.isBigDecimal()) {
                return ((BigDecimal)this.valueObject).shortValue();
            }
            return Integer.valueOf(this.asString()).shortValue();
        }
        catch (Exception exception) {
            throw new DataSetException("Bad conversion: " + exception.toString());
        }
    }

    public Short asShortObj() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isShort()) {
                return (Short)this.valueObject;
            }
            if (this.isString() || this.isDouble() || this.isFloat() || this.isInt() || this.isLong() || this.isBigDecimal() || this.isByte()) {
                return new Short(this.asString());
            }
            throw new DataSetException("Invalid type for Short");
        }
        catch (Exception exception) {
            throw new DataSetException("Illegal conversion: " + exception.toString());
        }
    }

    public long asLong() throws DataSetException {
        try {
            if (this.isNull()) {
                return 0L;
            }
            if (this.isLong()) {
                return (Long)this.valueObject;
            }
            if (this.isString()) {
                return Integer.valueOf((String)this.valueObject).longValue();
            }
            if (this.isShort()) {
                return ((Short)this.valueObject).longValue();
            }
            if (this.isInt()) {
                return ((Integer)this.valueObject).longValue();
            }
            if (this.isDouble()) {
                return ((Double)this.valueObject).longValue();
            }
            if (this.isFloat()) {
                return ((Float)this.valueObject).longValue();
            }
            if (this.isBigDecimal()) {
                return ((BigDecimal)this.valueObject).longValue();
            }
            return Integer.valueOf(this.asString()).longValue();
        }
        catch (Exception exception) {
            throw new DataSetException("Bad conversion: " + exception.toString());
        }
    }

    public Long asLongObj() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isLong()) {
                return (Long)this.valueObject;
            }
            if (this.isString() || this.isDouble() || this.isFloat() || this.isInt() || this.isBigDecimal() || this.isShort() || this.isByte()) {
                return new Long(this.asString());
            }
            throw new DataSetException("Invalid type for Long");
        }
        catch (Exception exception) {
            throw new DataSetException("Illegal conversion: " + exception.toString());
        }
    }

    public double asDouble() throws DataSetException {
        try {
            if (this.isNull()) {
                return 0.0;
            }
            if (this.isDouble()) {
                return (Double)this.valueObject;
            }
            if (this.isString()) {
                return Integer.valueOf((String)this.valueObject).doubleValue();
            }
            if (this.isShort()) {
                return ((Short)this.valueObject).doubleValue();
            }
            if (this.isInt()) {
                return ((Integer)this.valueObject).doubleValue();
            }
            if (this.isLong()) {
                return ((Long)this.valueObject).doubleValue();
            }
            if (this.isFloat()) {
                return ((Float)this.valueObject).doubleValue();
            }
            if (this.isBigDecimal()) {
                return ((BigDecimal)this.valueObject).doubleValue();
            }
            return Integer.valueOf(this.asString()).doubleValue();
        }
        catch (Exception exception) {
            throw new DataSetException("Bad conversion: " + exception.toString());
        }
    }

    public Double asDoubleObj() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isDouble()) {
                return (Double)this.valueObject;
            }
            if (this.isString() || this.isBigDecimal() || this.isFloat() || this.isInt() || this.isLong() || this.isShort() || this.isByte()) {
                return new Double(this.asString());
            }
            throw new DataSetException("Invalid type for Double");
        }
        catch (Exception exception) {
            throw new DataSetException("Illegal conversion: " + exception.toString());
        }
    }

    public float asFloat() throws DataSetException {
        try {
            if (this.isNull()) {
                return 0.0f;
            }
            if (this.isFloat()) {
                return ((Float)this.valueObject).floatValue();
            }
            if (this.isString()) {
                return Integer.valueOf((String)this.valueObject).floatValue();
            }
            if (this.isShort()) {
                return ((Short)this.valueObject).floatValue();
            }
            if (this.isInt()) {
                return ((Integer)this.valueObject).floatValue();
            }
            if (this.isLong()) {
                return ((Long)this.valueObject).floatValue();
            }
            if (this.isDouble()) {
                return ((Double)this.valueObject).floatValue();
            }
            if (this.isBigDecimal()) {
                return ((BigDecimal)this.valueObject).floatValue();
            }
            return Integer.valueOf(this.asString()).floatValue();
        }
        catch (Exception exception) {
            throw new DataSetException("Bad conversion: " + exception.toString());
        }
    }

    public Float asFloatObj() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isFloat()) {
                return (Float)this.valueObject;
            }
            if (this.isString() || this.isDouble() || this.isBigDecimal() || this.isInt() || this.isLong() || this.isShort() || this.isByte()) {
                return new Float(this.asString());
            }
            throw new DataSetException("Invalid type for Float");
        }
        catch (Exception exception) {
            throw new DataSetException("Illegal conversion: " + exception.toString());
        }
    }

    public Time asTime() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isTime()) {
                return (Time)this.valueObject;
            }
            Calendar calendar = Calendar.getInstance();
            if (this.isTimestamp()) {
                calendar.setTime((Timestamp)this.valueObject);
                return new Time(calendar.getTime().getTime());
            }
            if (this.isUtilDate()) {
                calendar.setTime((java.util.Date)this.valueObject);
                return new Time(calendar.getTime().getTime());
            }
            if (this.isString()) {
                return Time.valueOf((String)this.valueObject);
            }
            return Time.valueOf(this.asString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DataSetException("Bad date value - Java Time Objects cannot be earlier than 1/1/70");
        }
        catch (Exception exception) {
            throw new DataSetException("Bad conversion: " + exception.toString());
        }
    }

    public Timestamp asTimestamp() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isTimestamp()) {
                return (Timestamp)this.valueObject;
            }
            if (this.isTime()) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Time)this.valueObject);
                return new Timestamp(calendar.getTime().getTime());
            }
            if (this.isUtilDate()) {
                return new Timestamp(((java.util.Date)this.valueObject).getTime());
            }
            if (this.isString()) {
                return Timestamp.valueOf((String)this.valueObject);
            }
            return Timestamp.valueOf(this.asString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DataSetException("Bad date value - Java Timestamp Objects cannot be earlier than 1/1/70");
        }
        catch (Exception exception) {
            throw new DataSetException("Bad conversion: " + exception.toString());
        }
    }

    public Date asDate() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isDate()) {
                return (Date)this.valueObject;
            }
            Calendar calendar = Calendar.getInstance();
            if (this.isTimestamp()) {
                Timestamp timestamp = (Timestamp)this.valueObject;
                long l = timestamp.getTime();
                int n = timestamp.getNanos();
                return new Date(l + (long)(n / 1000000));
            }
            if (this.isTime()) {
                calendar.setTime((Time)this.valueObject);
                return Date.valueOf(calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5));
            }
            if (this.isUtilDate()) {
                calendar.setTime((java.util.Date)this.valueObject);
                return Date.valueOf(calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5));
            }
            if (this.isString()) {
                return Date.valueOf((String)this.valueObject);
            }
            return Date.valueOf(this.asString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DataSetException("Bad date value - Java Timestamp Objects cannot be earlier than 1/1/70");
        }
        catch (Exception exception) {
            throw new DataSetException("Bad conversion: " + exception.toString());
        }
    }

    public java.util.Date asUtilDate() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isUtilDate()) {
                return (java.util.Date)this.valueObject;
            }
            Calendar calendar = Calendar.getInstance();
            if (this.isTimestamp()) {
                Timestamp timestamp = (Timestamp)this.valueObject;
                long l = timestamp.getTime();
                int n = timestamp.getNanos();
                return new java.util.Date(l + (long)(n / 1000000));
            }
            if (this.isTime()) {
                calendar.setTime((Time)this.valueObject);
                return Date.valueOf(calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5));
            }
            if (this.isUtilDate()) {
                calendar.setTime((java.util.Date)this.valueObject);
                return Date.valueOf(calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5));
            }
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DataSetException("Bad date value - Java java.util.Date Objects cannot be earlier than 1/1/70");
        }
        catch (Exception exception) {
            throw new DataSetException("Bad conversion: " + exception.toString());
        }
    }

    public boolean isBigDecimal() {
        return this.valueObject instanceof BigDecimal;
    }

    public boolean isByte() {
        return this.valueObject instanceof Byte;
    }

    public boolean isBytes() {
        return this.valueObject instanceof byte[];
    }

    public boolean isDate() {
        return this.valueObject instanceof Date;
    }

    public boolean isShort() {
        return this.valueObject instanceof Short;
    }

    public boolean isInt() {
        return this.valueObject instanceof Integer;
    }

    public boolean isLong() {
        return this.valueObject instanceof Long;
    }

    public boolean isDouble() {
        return this.valueObject instanceof Double;
    }

    public boolean isFloat() {
        return this.valueObject instanceof Float;
    }

    public boolean isBoolean() {
        return this.valueObject instanceof Boolean;
    }

    public boolean isNull() {
        return this.valueObject == null;
    }

    public boolean isString() {
        return this.valueObject instanceof String;
    }

    public boolean isTime() {
        return this.valueObject instanceof Time;
    }

    public boolean isTimestamp() {
        return this.valueObject instanceof Timestamp;
    }

    public boolean isUtilDate() {
        return this.valueObject instanceof java.util.Date;
    }

    public int type() {
        return this.type;
    }

    int columnNumber() {
        return this.columnNumber;
    }

    private boolean isTrue(String string) {
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("t") || string.equalsIgnoreCase("yes") || string.equals("1");
    }
}

