/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.Fault;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.providers.RPCJavaProvider;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.RPCMessage;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.RPCRouter;
import org.apache.soap.server.ServerUtils;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.server.http.ServerHTTPUtils;
import org.apache.soap.transport.EnvelopeEditor;
import org.apache.soap.transport.EnvelopeEditorFactory;
import org.apache.soap.transport.TransportMessage;
import org.apache.soap.util.xml.XMLParserUtils;

public class RPCRouterServlet
extends HttpServlet {
    private EnvelopeEditor editor = null;
    private String configFilename = null;

    private Object createObject(String string, ClassLoader classLoader) throws ServletException {
        try {
            return classLoader.loadClass(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ServletException("Can't find class named '" + string + "'.");
        }
        catch (InstantiationException instantiationException) {
            throw new ServletException("Can't instantiate class '" + string + "'.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ServletException("WARNING: Can't access the constructor of the class '" + string + "'.");
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<html><head><title>SOAP RPC Router</title></head>");
        printWriter.println("<body><h1>SOAP RPC Router</h1>");
        printWriter.println("<p>Sorry, I don't speak via HTTP GET- you have to use");
        printWriter.println("HTTP POST to talk to me.</p></body></html>");
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServletConfig servletConfig = this.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        HttpSession httpSession = httpServletRequest.getSession();
        ServiceManager serviceManager = ServerHTTPUtils.getServiceManagerFromContext(servletContext, this.configFilename);
        RPCMessage rPCMessage = null;
        Response response = null;
        String string = null;
        String string2 = null;
        int n = 200;
        DeploymentDescriptor deploymentDescriptor = null;
        SOAPContext sOAPContext = new SOAPContext();
        SOAPContext sOAPContext2 = new SOAPContext();
        Envelope envelope = null;
        sOAPContext.setClassLoader(ServerHTTPUtils.getServletClassLoaderFromContext(servletContext));
        try {
            Object object;
            Object object2;
            Object object3;
            try {
                try {
                    sOAPContext.setProperty(Constants.BAG_HTTPSERVLET, (Object)this);
                    sOAPContext.setProperty(Constants.BAG_HTTPSESSION, httpSession);
                    sOAPContext.setProperty(Constants.BAG_HTTPSERVLETREQUEST, httpServletRequest);
                    sOAPContext.setProperty(Constants.BAG_HTTPSERVLETRESPONSE, httpServletResponse);
                    object3 = XMLParserUtils.getXMLDocBuilder();
                    envelope = ServerHTTPUtils.readEnvelopeFromRequest((DocumentBuilder)object3, httpServletRequest.getContentType(), httpServletRequest.getContentLength(), (InputStream)httpServletRequest.getInputStream(), this.editor, httpServletResponse, sOAPContext);
                    if (envelope == null) {
                        return;
                    }
                    rPCMessage = RPCRouter.extractCallFromEnvelope(serviceManager, envelope, sOAPContext);
                    string = rPCMessage.getTargetObjectURI();
                    string2 = rPCMessage.getFullTargetObjectURI();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    String string3 = illegalArgumentException.getMessage();
                    String string4 = string3 != null && string3.equals(Constants.ERR_MSG_VERSION_MISMATCH) ? Constants.FAULT_CODE_VERSION_MISMATCH : Constants.FAULT_CODE_CLIENT;
                    throw new SOAPException(string4, string3, illegalArgumentException);
                }
                deploymentDescriptor = serviceManager.query(string);
                sOAPContext.setProperty(Constants.BAG_DEPLOYMENTDESCRIPTOR, deploymentDescriptor);
                object3 = deploymentDescriptor.getProviderType() == 0 ? new RPCJavaProvider() : (deploymentDescriptor.getProviderType() == 3 ? ServerUtils.loadProvider(deploymentDescriptor, sOAPContext) : new RPCJavaProvider());
                object3.locate(deploymentDescriptor, envelope, (Call)rPCMessage, rPCMessage.getMethodName(), string2, sOAPContext);
                object3.invoke(sOAPContext, sOAPContext2);
            }
            catch (Throwable throwable) {
                object2 = null;
                object2 = throwable instanceof SOAPException ? (SOAPException)throwable : new SOAPException(String.valueOf(Constants.FAULT_CODE_SERVER) + ".Exception:", "", throwable);
                object = new Fault((SOAPException)object2);
                ((Fault)object).setFaultActorURI(httpServletRequest.getRequestURI());
                if (deploymentDescriptor != null) {
                    deploymentDescriptor.buildFaultRouter(sOAPContext).notifyListeners((Fault)object, (SOAPException)object2);
                }
                n = 500;
                String string5 = null;
                if (rPCMessage != null) {
                    string5 = rPCMessage.getEncodingStyleURI();
                }
                if (string5 == null) {
                    string5 = "http://schemas.xmlsoap.org/soap/encoding/";
                }
                sOAPContext2 = new SOAPContext();
                response = new Response(null, null, (Fault)object, null, null, string5, sOAPContext2);
                SOAPMappingRegistry sOAPMappingRegistry = rPCMessage != null ? ((Call)rPCMessage).getSOAPMappingRegistry() : ServerHTTPUtils.getSMRFromContext(servletContext);
                Envelope envelope2 = response.buildEnvelope();
                StringWriter stringWriter = new StringWriter();
                envelope2.marshall(stringWriter, sOAPMappingRegistry, response.getSOAPContext());
                response.getSOAPContext().setRootPart(stringWriter.toString(), "text/xml;charset=utf-8");
            }
            object3 = new TransportMessage(null, sOAPContext2, null);
            ((TransportMessage)object3).editOutgoing(this.editor);
            ((TransportMessage)object3).save();
            httpServletResponse.setStatus(n);
            httpServletResponse.setContentType(((TransportMessage)object3).getContentType());
            object2 = ((TransportMessage)object3).getHeaderNames();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                httpServletResponse.setHeader((String)object, ((TransportMessage)object3).getHeader((String)object));
            }
            httpServletResponse.setContentLength(((TransportMessage)object3).getContentLength());
            object = httpServletResponse.getOutputStream();
            ((TransportMessage)object3).writeTo((OutputStream)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ServletException("Error building response envelope: " + exception);
        }
    }

    public void init() throws ServletException {
        Object object;
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        ServletConfig servletConfig = this.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        String string = servletConfig.getInitParameter("EnvelopeEditorFactory");
        if (string != null && (object = (EnvelopeEditorFactory)this.createObject(string, classLoader)) != null) {
            try {
                String string2;
                Properties properties = new Properties();
                Enumeration enumeration = servletConfig.getInitParameterNames();
                while (enumeration.hasMoreElements()) {
                    string2 = (String)enumeration.nextElement();
                    if ("EnvelopeEditorFactory".equals(string2) || "XMLParser".equals(string2)) continue;
                    ((Hashtable)properties).put(string2, servletConfig.getInitParameter(string2));
                }
                string2 = servletContext.getRealPath("");
                if (string2 != null) {
                    ((Hashtable)properties).put("SOAPServerContextPath", string2);
                }
                this.editor = object.create(properties);
            }
            catch (SOAPException sOAPException) {
                throw new ServletException("Can't create editor", (Throwable)sOAPException);
            }
        }
        if ((object = servletConfig.getInitParameter("ConfigFile")) != null) {
            this.configFilename = object;
        }
        if ((object = servletConfig.getInitParameter("XMLParser")) != null) {
            XMLParserUtils.refreshDocumentBuilderFactory((String)object, true, false);
        }
        ServerHTTPUtils.setServletClassLoaderIntoContext(servletContext, classLoader);
    }
}

