/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine.memory.lru;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.CacheElement;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.group.GroupAttrName;
import org.apache.jcs.engine.control.group.GroupId;
import org.apache.jcs.engine.memory.AbstractMemoryCache;
import org.apache.jcs.engine.memory.lru.MemoryElementDescriptor;

public class LRUMemoryCache
extends AbstractMemoryCache {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$engine$memory$lru$LRUMemoryCache == null ? (class$org$apache$jcs$engine$memory$lru$LRUMemoryCache = LRUMemoryCache.class$("org.apache.jcs.engine.memory.lru.LRUMemoryCache")) : class$org$apache$jcs$engine$memory$lru$LRUMemoryCache));
    private MemoryElementDescriptor first;
    private MemoryElementDescriptor last;
    static /* synthetic */ Class class$org$apache$jcs$engine$memory$lru$LRUMemoryCache;

    public synchronized void initialize(CompositeCache hub) {
        super.initialize(hub);
        log.info((Object)("initialized LRUMemoryCache for " + this.cacheName));
    }

    public void update(ICacheElement ce) throws IOException {
        int size;
        ce.getElementAttributes().setLastAccessTimeNow();
        this.addFirst(ce);
        MemoryElementDescriptor old = this.map.put(ce.getKey(), this.first);
        if (old != null && this.first.ce.getKey().equals(old.ce.getKey())) {
            this.removeNode(old);
        }
        if ((size = this.map.size()) < this.cattr.getMaxObjects()) {
            return;
        }
        log.debug((Object)"In memory limit reached, spooling");
        int chunkSizeCorrected = Math.min(size, this.chunkSize);
        if (log.isDebugEnabled()) {
            log.debug((Object)("About to spool to disk cache, map size: " + size + ", max objects: " + this.cattr.getMaxObjects() + ", items to spool: " + chunkSizeCorrected));
        }
        int i = 0;
        while (i < chunkSizeCorrected) {
            LRUMemoryCache lRUMemoryCache = this;
            synchronized (lRUMemoryCache) {
                this.cache.spoolToDisk(this.last.ce);
                this.map.remove(this.last.ce.getKey());
                this.removeNode(this.last);
            }
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("After spool map size: " + size));
        }
    }

    public ICacheElement getQuiet(Serializable key) throws IOException {
        ICacheElement ce = null;
        MemoryElementDescriptor me = (MemoryElementDescriptor)this.map.get(key);
        if (me != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.cacheName + ": LRUMemoryCache quiet hit for " + key));
            }
            ce = me.ce;
        } else if (log.isDebugEnabled()) {
            log.debug((Object)(this.cacheName + ": LRUMemoryCache quiet miss for " + key));
        }
        return ce;
    }

    public ICacheElement get(Serializable key) throws IOException {
        MemoryElementDescriptor me;
        ICacheElement ce = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getting item for key: " + key));
        }
        if ((me = (MemoryElementDescriptor)this.map.get(key)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.cacheName + ": LRUMemoryCache hit for " + key));
            }
            ce = me.ce;
            ce.getElementAttributes().setLastAccessTimeNow();
            this.makeFirst(me);
        } else {
            log.debug((Object)(this.cacheName + ": LRUMemoryCache miss for " + key));
        }
        return ce;
    }

    public boolean remove(Serializable key) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removing item for key: " + key));
        }
        boolean removed = false;
        if (key instanceof String && ((String)((Object)key)).endsWith(":")) {
            Map map = this.map;
            synchronized (map) {
                Iterator itr = this.map.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    Object k = entry.getKey();
                    if (!(k instanceof String) || !((String)k).startsWith(key.toString())) continue;
                    itr.remove();
                    this.removeNode((MemoryElementDescriptor)entry.getValue());
                    removed = true;
                }
            }
        } else if (key instanceof GroupId) {
            Map map = this.map;
            synchronized (map) {
                Iterator itr = this.map.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    Object k = entry.getKey();
                    if (!(k instanceof GroupAttrName) || !((GroupAttrName)k).groupId.equals(key)) continue;
                    itr.remove();
                    this.removeNode((MemoryElementDescriptor)entry.getValue());
                    removed = true;
                }
            }
        } else {
            MemoryElementDescriptor me = (MemoryElementDescriptor)this.map.remove(key);
            if (me != null) {
                this.removeNode(me);
                removed = true;
            }
        }
        return removed;
    }

    public Iterator getIterator() {
        return new IteratorWrapper(this.map);
    }

    public Object[] getKeyArray() {
        LRUMemoryCache lRUMemoryCache = this;
        synchronized (lRUMemoryCache) {
            Object[] objectArray = this.map.keySet().toArray();
            return objectArray;
        }
    }

    private synchronized void removeNode(MemoryElementDescriptor me) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removing node " + me.ce.getKey()));
        }
        if (me.next == null) {
            if (me.prev == null) {
                if (me == this.first && me == this.last) {
                    this.last = null;
                    this.first = null;
                }
            } else {
                this.last = me.prev;
                this.last.next = null;
                me.prev = null;
            }
        } else if (me.prev == null) {
            this.first = me.next;
            this.first.prev = null;
            me.next = null;
        } else {
            me.prev.next = me.next;
            me.next.prev = me.prev;
            me.next = null;
            me.prev = null;
        }
    }

    private void addLast(CacheElement ce) {
        MemoryElementDescriptor me = new MemoryElementDescriptor(ce);
        if (this.first == null) {
            this.first = me;
        } else {
            this.last.next = me;
            me.prev = this.last;
        }
        this.last = me;
    }

    private synchronized void addFirst(ICacheElement ce) {
        MemoryElementDescriptor me = new MemoryElementDescriptor(ce);
        if (this.last == null) {
            this.last = me;
        } else {
            this.first.prev = me;
            me.next = this.first;
        }
        this.first = me;
    }

    public void makeFirst(ICacheElement ce) {
        this.makeFirst(new MemoryElementDescriptor(ce));
    }

    public synchronized void makeFirst(MemoryElementDescriptor me) {
        if (me.prev == null) {
            return;
        }
        me.prev.next = me.next;
        if (me.next == null) {
            this.last = me.prev;
            this.last.next = null;
        } else {
            me.next.prev = me.prev;
        }
        this.first.prev = me;
        me.next = this.first;
        me.prev = null;
        this.first = me;
    }

    public void dumpMap() {
        log.debug((Object)"dumpingMap");
        Iterator itr = this.map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = itr.next();
            MemoryElementDescriptor me = (MemoryElementDescriptor)e.getValue();
            log.debug((Object)("dumpMap> key=" + e.getKey() + ", val=" + me.ce.getVal()));
        }
    }

    public void dumpCacheEntries() {
        log.debug((Object)"dumpingCacheEntries");
        MemoryElementDescriptor me = this.first;
        while (me != null) {
            log.debug((Object)("dumpCacheEntries> key=" + me.ce.getKey() + ", val=" + me.ce.getVal()));
            me = me.next;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class MapEntryWrapper
    implements Map.Entry {
        private final Map.Entry e;

        private MapEntryWrapper(Map.Entry e) {
            this.e = e;
        }

        public boolean equals(Object o) {
            return this.e.equals(o);
        }

        public Object getKey() {
            return this.e.getKey();
        }

        public Object getValue() {
            return ((MemoryElementDescriptor)this.e.getValue()).ce;
        }

        public int hashCode() {
            return this.e.hashCode();
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException("Use normal cache methods to alter the contents of the cache.");
        }
    }

    public class IteratorWrapper
    implements Iterator {
        private final Iterator i;

        private IteratorWrapper(Map m) {
            this.i = m.entrySet().iterator();
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            return new MapEntryWrapper((Map.Entry)this.i.next());
        }

        public void remove() {
            this.i.remove();
        }

        public boolean equals(Object o) {
            return this.i.equals(o);
        }

        public int hashCode() {
            return this.i.hashCode();
        }
    }
}

