/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.indexed;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.disk.indexed.IndexedDiskElementDescriptor;
import org.apache.jcs.engine.CacheElement;

class IndexedDisk {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$disk$indexed$IndexedDisk == null ? (class$org$apache$jcs$auxiliary$disk$indexed$IndexedDisk = IndexedDisk.class$("org.apache.jcs.auxiliary.disk.indexed.IndexedDisk")) : class$org$apache$jcs$auxiliary$disk$indexed$IndexedDisk));
    private final String filepath;
    private RandomAccessFile raf;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$disk$indexed$IndexedDisk;

    IndexedDisk(File file) throws FileNotFoundException {
        this.filepath = file.getAbsolutePath();
        this.raf = new RandomAccessFile(this.filepath, "rw");
    }

    Serializable readObject(long pos) {
        byte[] data = null;
        boolean corrupted = false;
        try {
            Serializable serializable;
            IndexedDisk indexedDisk = this;
            synchronized (indexedDisk) {
                this.raf.seek(pos);
                int datalen = this.raf.readInt();
                if ((long)datalen > this.raf.length()) {
                    corrupted = true;
                } else {
                    data = new byte[datalen];
                    this.raf.readFully(data);
                }
            }
            if (corrupted) {
                log.debug((Object)"The datFile is corrupted");
                return null;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            BufferedInputStream bis = new BufferedInputStream(bais);
            ObjectInputStream ois = new ObjectInputStream(bis);
            try {
                serializable = (Serializable)ois.readObject();
                Object var11_12 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                ois.close();
                throw throwable;
            }
            ois.close();
            return serializable;
        }
        catch (Exception e) {
            log.error((Object)this.raf, (Throwable)e);
            return null;
        }
    }

    boolean append(byte[] data) {
        try {
            IndexedDisk indexedDisk = this;
            synchronized (indexedDisk) {
                boolean bl = this.write(data, this.raf.length());
                return bl;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    boolean write(byte[] data, long pos) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("write> pos=" + pos));
            log.debug((Object)(this.raf + " -- data.length = " + data.length));
        }
        try {
            IndexedDisk indexedDisk = this;
            synchronized (indexedDisk) {
                this.raf.seek(pos);
                this.raf.writeInt(data.length);
                this.raf.write(data);
            }
            return true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    boolean writeObject(Serializable obj, long pos) {
        try {
            return this.write(IndexedDisk.serialize(obj), pos);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    IndexedDiskElementDescriptor appendObject(CacheElement obj) {
        long pos = -1L;
        boolean success = false;
        try {
            IndexedDiskElementDescriptor ded = new IndexedDiskElementDescriptor();
            byte[] data = IndexedDisk.serialize(obj);
            IndexedDisk indexedDisk = this;
            synchronized (indexedDisk) {
                pos = this.raf.length();
                ded.init(pos, data);
                success = this.write(data, pos);
            }
            return success ? ded : null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    long length() throws IOException {
        IndexedDisk indexedDisk = this;
        synchronized (indexedDisk) {
            long l = this.raf.length();
            return l;
        }
    }

    synchronized void close() throws IOException {
        this.raf.close();
    }

    synchronized void reset() throws IOException {
        this.raf.close();
        File f = new File(this.filepath);
        int i = 0;
        while (i < 10 && !f.delete()) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            log.warn((Object)("Failed to delete " + f.getName() + " " + i));
            ++i;
        }
        if (i == 10) {
            IllegalStateException ex = new IllegalStateException("Failed to delete " + f.getName());
            log.error((Object)ex);
            throw ex;
        }
        this.raf = new RandomAccessFile(this.filepath, "rw");
    }

    static byte[] serialize(Serializable obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(obj);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            oos.close();
            throw throwable;
        }
        oos.close();
        return baos.toByteArray();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

