/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs;

import junit.extensions.ActiveTestSuite;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.jcs.JCS;

public class TestDiskCacheConcurrent
extends TestCase {
    static /* synthetic */ Class class$org$apache$jcs$TestDiskCacheConcurrent;

    public TestDiskCacheConcurrent(String testName) {
        super(testName);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{(class$org$apache$jcs$TestDiskCacheConcurrent == null ? (class$org$apache$jcs$TestDiskCacheConcurrent = TestDiskCacheConcurrent.class$("org.apache.jcs.TestDiskCacheConcurrent")) : class$org$apache$jcs$TestDiskCacheConcurrent).getName()};
        TestRunner.main((String[])testCaseName);
    }

    public static Test suite() {
        ActiveTestSuite suite = new ActiveTestSuite();
        suite.addTest((Test)new TestDiskCacheConcurrent("testIndexedDiskCache1"){

            public void runTest() throws Exception {
                this.runTestForRegion("indexedRegion4", 0, 200);
            }
        });
        suite.addTest((Test)new TestDiskCacheConcurrent("testIndexedDiskCache2"){

            public void runTest() throws Exception {
                this.runTestForRegion("indexedRegion4", 1000, 1200);
            }
        });
        suite.addTest((Test)new TestDiskCacheConcurrent("testIndexedDiskCache3"){

            public void runTest() throws Exception {
                this.runTestForRegion("indexedRegion4", 2000, 2200);
            }
        });
        return suite;
    }

    public void setUp() {
        JCS.setConfigFilename("/TestDiskCacheCon.ccf");
    }

    public void runTestForRegion(String region, int start, int end) throws Exception {
        JCS jcs = JCS.getInstance(region);
        int i = start;
        while (i <= end) {
            jcs.put(i + ":key", region + " data " + i);
            ++i;
        }
        int i2 = start;
        while (i2 <= end) {
            String value = (String)jcs.get(i2 + ":key");
            Assert.assertEquals((Object)(region + " data " + i2), (Object)value);
            ++i2;
        }
        int i3 = start;
        while (i3 <= end) {
            jcs.remove(i3 + ":key");
            ++i3;
        }
        int i4 = start;
        while (i4 <= end) {
            Assert.assertNull((String)("Removed key should be null: " + i4 + ":key"), (Object)jcs.get(i4 + ":key"));
            ++i4;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

