/*
 * Decompiled with CFR 0.152.
 */
package org.apache.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.util.URIException;
import sun.security.action.GetPropertyAction;

public class URI
implements Cloneable,
Comparable,
Serializable {
    static final long serialVersionUID = 604752400577948726L;
    protected char[] _uri = null;
    protected static String _protocolCharset = "UTF8";
    protected static String _documentCharset = null;
    protected char[] _scheme = null;
    protected char[] _opaque = null;
    protected char[] _authority = null;
    protected char[] _userinfo = null;
    protected char[] _host = null;
    protected int _port = -1;
    protected char[] _path = null;
    protected char[] _query = null;
    protected char[] _fragment = null;
    protected static int debug;
    protected static final BitSet percent;
    protected static final BitSet digit;
    protected static final BitSet alpha;
    protected static final BitSet alphanum;
    protected static final BitSet hex;
    protected static final BitSet escaped;
    protected static final BitSet mark;
    protected static final BitSet unreserved;
    protected static final BitSet reserved;
    protected static final BitSet uric;
    protected static final BitSet fragment;
    protected static final BitSet query;
    protected static final BitSet pchar;
    protected static final BitSet param;
    protected static final BitSet segment;
    protected static final BitSet path_segments;
    protected static final BitSet abs_path;
    protected static final BitSet uric_no_slash;
    protected static final BitSet opaque_part;
    protected static final BitSet path;
    protected static final BitSet port;
    protected static final BitSet IPv4address;
    protected static final BitSet IPv6address;
    protected static final BitSet IPv6reference;
    protected static final BitSet toplabel;
    protected static final BitSet domainlabel;
    protected static final BitSet hostname;
    protected static final BitSet host;
    protected static final BitSet hostport;
    protected static final BitSet userinfo;
    protected static final BitSet server;
    protected static final BitSet reg_name;
    protected static final BitSet authority;
    protected static final BitSet scheme;
    protected static final BitSet rel_segment;
    protected static final BitSet rel_path;
    protected static final BitSet net_path;
    protected static final BitSet hier_part;
    protected static final BitSet relativeURI;
    protected static final BitSet absoluteURI;
    protected static final BitSet URI_reference;
    public static final BitSet control;
    public static final BitSet space;
    public static final BitSet delims;
    public static final BitSet unwise;
    public static final BitSet disallowed_rel_path;
    public static final BitSet disallowed_opaque_part;
    public static final BitSet allowed_authority;
    public static final BitSet allowed_opaque_part;
    public static final BitSet allowed_reg_name;
    public static final BitSet allowed_userinfo;
    public static final BitSet allowed_IPv6reference;
    public static final BitSet allowed_host;
    public static final BitSet allowed_abs_path;
    public static final BitSet allowed_rel_path;
    public static final BitSet allowed_query;
    public static final BitSet allowed_fragment;
    protected boolean _is_hier_part;
    protected boolean _is_opaque_part;
    protected boolean _is_net_path;
    protected boolean _is_abs_path;
    protected boolean _is_rel_path;
    protected boolean _is_reg_name;
    protected boolean _is_server;
    protected boolean _is_hostname;
    protected boolean _is_IPv4address;
    protected boolean _is_IPv6reference;
    protected boolean _is_only_fragment;

    static {
        Locale locale = Locale.getDefault();
        _documentCharset = locale != null ? LocaleToCharsetMap.getCharset(locale) : AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
        debug = 0;
        percent = new BitSet(256);
        percent.set(37);
        digit = new BitSet(256);
        int i = 48;
        while (i <= 57) {
            digit.set(i);
            ++i;
        }
        alpha = new BitSet(256);
        i = 97;
        while (i <= 122) {
            alpha.set(i);
            ++i;
        }
        int i2 = 65;
        while (i2 <= 90) {
            alpha.set(i2);
            ++i2;
        }
        alphanum = new BitSet(256);
        alphanum.or(alpha);
        alphanum.or(digit);
        hex = new BitSet(256);
        hex.or(digit);
        i = 97;
        while (i <= 102) {
            hex.set(i);
            ++i;
        }
        i2 = 65;
        while (i2 <= 70) {
            hex.set(i2);
            ++i2;
        }
        escaped = new BitSet(256);
        escaped.or(percent);
        escaped.or(hex);
        mark = new BitSet(256);
        mark.set(45);
        mark.set(95);
        mark.set(46);
        mark.set(33);
        mark.set(126);
        mark.set(42);
        mark.set(39);
        mark.set(40);
        mark.set(41);
        unreserved = new BitSet(256);
        unreserved.or(alphanum);
        unreserved.or(mark);
        reserved = new BitSet(256);
        reserved.set(59);
        reserved.set(47);
        reserved.set(63);
        reserved.set(58);
        reserved.set(64);
        reserved.set(38);
        reserved.set(61);
        reserved.set(43);
        reserved.set(36);
        reserved.set(44);
        uric = new BitSet(256);
        uric.or(reserved);
        uric.or(unreserved);
        uric.or(escaped);
        fragment = uric;
        query = uric;
        pchar = new BitSet(256);
        pchar.or(unreserved);
        pchar.or(escaped);
        pchar.set(58);
        pchar.set(64);
        pchar.set(38);
        pchar.set(61);
        pchar.set(43);
        pchar.set(36);
        pchar.set(44);
        param = pchar;
        segment = new BitSet(256);
        segment.or(pchar);
        segment.set(59);
        segment.or(param);
        path_segments = new BitSet(256);
        path_segments.set(47);
        path_segments.or(segment);
        abs_path = new BitSet(256);
        abs_path.set(47);
        abs_path.or(path_segments);
        uric_no_slash = new BitSet(256);
        uric_no_slash.or(unreserved);
        uric_no_slash.or(escaped);
        uric_no_slash.set(59);
        uric_no_slash.set(63);
        uric_no_slash.set(59);
        uric_no_slash.set(64);
        uric_no_slash.set(38);
        uric_no_slash.set(61);
        uric_no_slash.set(43);
        uric_no_slash.set(36);
        uric_no_slash.set(44);
        opaque_part = new BitSet(256);
        opaque_part.or(uric_no_slash);
        opaque_part.or(uric);
        path = new BitSet(256);
        path.or(abs_path);
        path.or(opaque_part);
        port = digit;
        IPv4address = new BitSet(256);
        IPv4address.or(digit);
        IPv4address.set(46);
        IPv6address = new BitSet(256);
        IPv6address.or(hex);
        IPv6address.set(58);
        IPv6address.or(IPv4address);
        IPv6reference = new BitSet(256);
        IPv6reference.set(91);
        IPv6reference.or(IPv6address);
        IPv6reference.set(93);
        toplabel = new BitSet(256);
        toplabel.or(alphanum);
        toplabel.set(45);
        domainlabel = toplabel;
        hostname = new BitSet(256);
        hostname.or(toplabel);
        hostname.set(46);
        host = new BitSet(256);
        host.or(hostname);
        host.or(IPv6reference);
        hostport = new BitSet(256);
        hostport.or(host);
        hostport.set(58);
        hostport.or(port);
        userinfo = new BitSet(256);
        userinfo.or(unreserved);
        userinfo.or(escaped);
        userinfo.set(59);
        userinfo.set(58);
        userinfo.set(38);
        userinfo.set(61);
        userinfo.set(43);
        userinfo.set(36);
        userinfo.set(44);
        server = new BitSet(256);
        server.or(userinfo);
        server.set(64);
        server.or(hostport);
        reg_name = new BitSet(256);
        reg_name.or(unreserved);
        reg_name.or(escaped);
        reg_name.set(36);
        reg_name.set(44);
        reg_name.set(59);
        reg_name.set(58);
        reg_name.set(64);
        reg_name.set(38);
        reg_name.set(61);
        reg_name.set(43);
        authority = new BitSet(256);
        authority.or(server);
        authority.or(reg_name);
        scheme = new BitSet(256);
        scheme.or(alpha);
        scheme.or(digit);
        scheme.set(43);
        scheme.set(45);
        scheme.set(46);
        rel_segment = new BitSet(256);
        rel_segment.or(unreserved);
        rel_segment.or(escaped);
        rel_segment.set(59);
        rel_segment.set(64);
        rel_segment.set(38);
        rel_segment.set(61);
        rel_segment.set(43);
        rel_segment.set(36);
        rel_segment.set(44);
        rel_path = new BitSet(256);
        rel_path.or(rel_segment);
        rel_path.or(abs_path);
        net_path = new BitSet(256);
        net_path.set(47);
        net_path.or(authority);
        net_path.or(abs_path);
        hier_part = new BitSet(256);
        hier_part.or(net_path);
        hier_part.or(abs_path);
        hier_part.or(query);
        relativeURI = new BitSet(256);
        relativeURI.or(net_path);
        relativeURI.or(abs_path);
        relativeURI.or(rel_path);
        relativeURI.or(query);
        absoluteURI = new BitSet(256);
        absoluteURI.or(scheme);
        absoluteURI.set(58);
        absoluteURI.or(hier_part);
        absoluteURI.or(opaque_part);
        URI_reference = new BitSet(256);
        URI_reference.or(absoluteURI);
        URI_reference.or(relativeURI);
        URI_reference.set(35);
        URI_reference.or(fragment);
        control = new BitSet(256);
        i = 0;
        while (i <= 31) {
            control.set(i);
            ++i;
        }
        control.set(127);
        space = new BitSet(256);
        space.set(32);
        delims = new BitSet(256);
        delims.set(60);
        delims.set(62);
        delims.set(35);
        delims.set(37);
        delims.set(34);
        unwise = new BitSet(256);
        unwise.set(123);
        unwise.set(125);
        unwise.set(124);
        unwise.set(92);
        unwise.set(94);
        unwise.set(91);
        unwise.set(93);
        unwise.set(96);
        disallowed_rel_path = new BitSet(256);
        disallowed_rel_path.or(uric);
        disallowed_rel_path.andNot(rel_path);
        disallowed_opaque_part = new BitSet(256);
        disallowed_opaque_part.or(uric);
        disallowed_opaque_part.andNot(opaque_part);
        allowed_authority = new BitSet(256);
        allowed_authority.or(authority);
        allowed_authority.clear(37);
        allowed_opaque_part = new BitSet(256);
        allowed_opaque_part.or(opaque_part);
        allowed_opaque_part.clear(37);
        allowed_reg_name = new BitSet(256);
        allowed_reg_name.or(reg_name);
        allowed_reg_name.clear(37);
        allowed_userinfo = new BitSet(256);
        allowed_userinfo.or(userinfo);
        allowed_userinfo.clear(37);
        allowed_IPv6reference = new BitSet(256);
        allowed_IPv6reference.or(IPv6reference);
        allowed_IPv6reference.clear(91);
        allowed_IPv6reference.clear(93);
        allowed_host = new BitSet(256);
        allowed_host.or(hostname);
        allowed_host.or(allowed_IPv6reference);
        allowed_abs_path = new BitSet(256);
        allowed_abs_path.or(abs_path);
        allowed_abs_path.andNot(percent);
        allowed_rel_path = new BitSet(256);
        allowed_rel_path.or(rel_path);
        allowed_rel_path.clear(37);
        allowed_query = new BitSet(256);
        allowed_query.or(uric);
        allowed_query.clear(37);
        allowed_fragment = new BitSet(256);
        allowed_fragment.or(uric);
        allowed_fragment.clear(37);
    }

    protected URI() {
    }

    public URI(String original) throws URIException {
        this.parseUriReference(original, false);
    }

    public URI(String scheme, String scheme_specific_part, String fragment) throws URIException {
        if (scheme == null) {
            throw new URIException(1, "scheme required");
        }
        char[] s = scheme.toLowerCase().toCharArray();
        if (!this.validate(s, URI.scheme)) {
            throw new URIException(1, "incorrect scheme");
        }
        this._scheme = s;
        this._opaque = this.encode(scheme_specific_part, allowed_opaque_part);
        this._is_opaque_part = true;
        this.setUriReference();
    }

    public URI(String scheme, String userinfo, String host, int port, String path, String query, String fragment) throws URIException {
        this(scheme, host == null ? null : String.valueOf(userinfo != null ? String.valueOf(userinfo) + '@' : "") + host + (port != -1 ? ":" + port : ""), path, query, fragment);
    }

    public URI(String scheme, String host, String path, String fragment) throws URIException {
        this(scheme, host, path, null, fragment);
    }

    public URI(String scheme, String authority, String path, String query, String fragment) throws URIException {
        StringBuffer buff = new StringBuffer();
        if (scheme != null) {
            buff.append(scheme);
            buff.append(':');
        }
        if (authority != null) {
            buff.append("//");
            buff.append(authority);
        }
        if (path != null) {
            if (!(scheme == null && authority == null || path.startsWith("/"))) {
                throw new URIException(1, "abs_path requested");
            }
            buff.append(path);
        }
        if (query != null) {
            buff.append('?');
            buff.append(query);
        }
        if (fragment != null) {
            buff.append('#');
            buff.append(fragment);
        }
        this.parseUriReference(buff.toString(), false);
    }

    public URI(URI base, URI relative) throws URIException {
        if (base._scheme == null) {
            throw new URIException(1, "base URI required");
        }
        if (base._scheme != null) {
            this._scheme = base._scheme;
            this._authority = base._authority;
        }
        if (base._is_opaque_part || relative._is_opaque_part) {
            this._scheme = base._scheme;
            this._is_opaque_part = relative._is_opaque_part;
            this._opaque = relative._opaque;
            this._fragment = relative._fragment;
            this.setUriReference();
            return;
        }
        if (relative._is_only_fragment) {
            this._fragment = relative._fragment;
            this._is_only_fragment = relative._is_only_fragment;
            this.setUriReference();
            return;
        }
        if (relative._scheme != null) {
            this._scheme = relative._scheme;
            this._is_net_path = relative._is_net_path;
            this._authority = relative._authority;
            if (relative._is_server) {
                this._userinfo = relative._userinfo;
                this._host = relative._host;
                this._port = relative._port;
            } else if (relative._is_reg_name) {
                this._is_reg_name = relative._is_reg_name;
            }
            this._is_abs_path = relative._is_abs_path;
            this._is_rel_path = relative._is_rel_path;
            this._path = relative._path;
        } else if (base._authority != null && relative._scheme == null) {
            this._is_net_path = base._is_net_path;
            this._authority = base._authority;
            if (base._is_server) {
                this._userinfo = base._userinfo;
                this._host = base._host;
                this._port = base._port;
            } else if (base._is_reg_name) {
                this._is_reg_name = base._is_reg_name;
            }
        }
        if (relative._authority != null) {
            this._is_net_path = relative._is_net_path;
            this._authority = relative._authority;
            if (relative._is_server) {
                this._is_server = relative._is_server;
                this._userinfo = relative._userinfo;
                this._host = relative._host;
                this._port = relative._port;
            } else if (relative._is_reg_name) {
                this._is_reg_name = relative._is_reg_name;
            }
            this._is_abs_path = relative._is_abs_path;
            this._is_rel_path = relative._is_rel_path;
            this._path = relative._path;
        }
        if (relative._scheme == null && relative._authority == null || this.equals(base._scheme, relative._scheme)) {
            this._path = this.resolvePath(base._path, relative._path);
        }
        if (relative._query != null) {
            this._query = relative._query;
        }
        if (relative._fragment != null) {
            this._fragment = relative._fragment;
        }
        this.setUriReference();
    }

    public URI(char[] escaped) throws URIException {
        this.parseUriReference(new String(escaped), true);
    }

    public synchronized Object clone() {
        URI instance = new URI();
        instance._uri = this._uri;
        instance._scheme = this._scheme;
        instance._opaque = this._opaque;
        instance._authority = this._authority;
        instance._userinfo = this._userinfo;
        instance._host = this._host;
        instance._port = this._port;
        instance._path = this._path;
        instance._query = this._query;
        instance._fragment = this._fragment;
        instance._is_hier_part = this._is_hier_part;
        instance._is_opaque_part = this._is_opaque_part;
        instance._is_net_path = this._is_net_path;
        instance._is_abs_path = this._is_abs_path;
        instance._is_rel_path = this._is_rel_path;
        instance._is_reg_name = this._is_reg_name;
        instance._is_server = this._is_server;
        instance._is_hostname = this._is_hostname;
        instance._is_IPv4address = this._is_IPv4address;
        instance._is_IPv6reference = this._is_IPv6reference;
        instance._is_only_fragment = this._is_only_fragment;
        return instance;
    }

    public int compareTo(Object obj) {
        URI another = (URI)obj;
        if (!this.equals(this._authority, another.getRawAuthority())) {
            return -1;
        }
        return this.toString().compareTo(another.toString());
    }

    protected String decode(char[] component) throws URIException {
        String result;
        byte[] octets;
        if (component == null) {
            return null;
        }
        try {
            octets = new String(component).getBytes(_protocolCharset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new URIException(2, "not supported " + _protocolCharset + " encoding");
        }
        int length = octets.length;
        int oi = 0;
        int ii = 0;
        while (ii < length) {
            byte aByte;
            if ((aByte = octets[ii++]) == 37 && ii + 2 <= length) {
                byte high = (byte)Character.digit((char)octets[ii++], 16);
                byte low = (byte)Character.digit((char)octets[ii++], 16);
                if (high == -1 || low == -1) {
                    throw new URIException(3, "incomplete trailing escape pattern");
                }
                aByte = (byte)((high << 4) + low);
            }
            octets[oi] = aByte;
            ++oi;
        }
        try {
            result = new String(octets, 0, oi, _protocolCharset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new URIException(2, "not supported " + _protocolCharset + " encoding");
        }
        return result;
    }

    protected char[] encode(String original, BitSet allowed) throws URIException {
        byte[] octets;
        if (original == null) {
            throw new URIException(1, "null");
        }
        if (allowed == null) {
            throw new URIException(1, "null allowed characters");
        }
        try {
            octets = original.getBytes(_protocolCharset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new URIException(2, _protocolCharset);
        }
        StringBuffer buf = new StringBuffer(octets.length);
        int i = 0;
        while (i < octets.length) {
            char c = (char)octets[i];
            if (allowed.get(c)) {
                buf.append(c);
            } else {
                buf.append('%');
                byte b = octets[i];
                char hexadecimal = Character.forDigit(b >> 4 & 0xF, 16);
                buf.append(Character.toUpperCase(hexadecimal));
                hexadecimal = Character.forDigit(b & 0xF, 16);
                buf.append(Character.toUpperCase(hexadecimal));
            }
            ++i;
        }
        return buf.toString().toCharArray();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof URI)) {
            return false;
        }
        URI another = (URI)obj;
        if (!this.equals(this._scheme, another._scheme)) {
            return false;
        }
        if (!this.equals(this._opaque, another._opaque)) {
            return false;
        }
        if (!this.equals(this._authority, another._authority)) {
            return false;
        }
        if (!this.equals(this._path, another._path)) {
            return false;
        }
        if (!this.equals(this._query, another._query)) {
            return false;
        }
        return this.equals(this._fragment, another._fragment);
    }

    protected boolean equals(char[] first, char[] second) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length != second.length) {
            return false;
        }
        int i = 0;
        while (i < first.length) {
            if (first[i] != second[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getAboveHierPath() throws URIException {
        char[] path = this.getRawAboveHierPath();
        return path == null ? null : this.decode(path);
    }

    public String getAuthority() throws URIException {
        return this._authority == null ? null : this.decode(this._authority);
    }

    public String getCurrentHierPath() throws URIException {
        char[] path = this.getRawCurrentHierPath();
        return path == null ? null : this.decode(path);
    }

    public static String getDocumentCharset() {
        return _documentCharset;
    }

    public String getEscapedAboveHierPath() throws URIException {
        char[] path = this.getRawAboveHierPath();
        return path == null ? null : new String(path);
    }

    public String getEscapedAuthority() {
        return this._authority == null ? null : new String(this._authority);
    }

    public String getEscapedCurrentHierPath() throws URIException {
        char[] path = this.getRawCurrentHierPath();
        return path == null ? null : new String(path);
    }

    public String getEscapedFragment() {
        return this._fragment == null ? null : new String(this._fragment);
    }

    public String getEscapedName() {
        char[] basename = this.getRawName();
        return basename == null ? null : new String(basename);
    }

    public String getEscapedPath() {
        char[] path = this.getRawPath();
        return path == null ? null : new String(path);
    }

    public String getEscapedPathQuery() {
        char[] rawPathQuery = this.getRawPathQuery();
        return rawPathQuery == null ? null : new String(rawPathQuery);
    }

    public String getEscapedQuery() {
        return this._query == null ? null : new String(this._query);
    }

    public String getEscapedURI() {
        return this._uri == null ? null : new String(this._uri);
    }

    public String getEscapedUserinfo() {
        return this._userinfo == null ? null : new String(this._userinfo);
    }

    public String getFragment() throws URIException {
        return this._fragment == null ? null : this.decode(this._fragment);
    }

    public String getHost() throws URIException {
        return this.decode(this._host);
    }

    public String getName() throws URIException {
        char[] basename = this.getRawName();
        return basename == null ? null : this.decode(this.getRawName());
    }

    public String getPath() throws URIException {
        char[] path = this.getRawPath();
        return path == null ? null : this.decode(path);
    }

    public String getPathQuery() throws URIException {
        char[] rawPathQuery = this.getRawPathQuery();
        return rawPathQuery == null ? null : this.decode(rawPathQuery);
    }

    public int getPort() {
        return this._port;
    }

    public static String getProtocolCharset() {
        return _protocolCharset;
    }

    public String getQuery() throws URIException {
        return this._query == null ? null : this.decode(this._query);
    }

    public char[] getRawAboveHierPath() throws URIException {
        char[] path = this.getRawCurrentHierPath();
        return path == null ? null : this.getRawCurrentHierPath(path);
    }

    public char[] getRawAuthority() {
        return this._authority;
    }

    public char[] getRawCurrentHierPath() throws URIException {
        return this._path == null ? null : this.getRawCurrentHierPath(this._path);
    }

    protected char[] getRawCurrentHierPath(char[] path) throws URIException {
        int last;
        if (this._is_opaque_part) {
            throw new URIException(1, "no hierarchy level");
        }
        if (path == null) {
            throw new URIException(1, "emtpy path");
        }
        String buff = new String(path);
        int first = buff.indexOf(47);
        if (first != (last = buff.lastIndexOf(47)) && last != -1) {
            return buff.substring(0, last).toCharArray();
        }
        return path;
    }

    public char[] getRawFragment() {
        return this._fragment;
    }

    public char[] getRawHost() {
        return this._host;
    }

    public char[] getRawName() {
        if (this._path == null) {
            return null;
        }
        int at = 0;
        int i = this._path.length - 1;
        while (i >= 0) {
            if (this._path[i] == '/') {
                at = i;
                break;
            }
            --i;
        }
        int len = this._path.length - at;
        char[] basename = new char[len];
        System.arraycopy(this._path, at + 1, basename, 0, len);
        return basename;
    }

    public char[] getRawPath() {
        return this._is_opaque_part ? this._opaque : this._path;
    }

    public char[] getRawPathQuery() {
        if (this._path == null && this._query == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        if (this._path != null) {
            buff.append(this._path);
        }
        if (this._query != null) {
            buff.append('?');
            buff.append(this._query);
        }
        return buff.toString().toCharArray();
    }

    public char[] getRawQuery() {
        return this._query;
    }

    public char[] getRawScheme() {
        return this._scheme;
    }

    public char[] getRawURI() {
        return this._uri;
    }

    public char[] getRawUserinfo() {
        return this._userinfo;
    }

    public String getScheme() {
        return this._scheme == null ? null : new String(this._scheme);
    }

    public String getURI() throws URIException {
        return this._uri == null ? null : this.decode(this._uri);
    }

    public String getUserinfo() throws URIException {
        return this._userinfo == null ? null : this.decode(this._userinfo);
    }

    public boolean hasAuthority() {
        return this._authority != null || this._is_net_path;
    }

    public boolean hasFragment() {
        return this._fragment != null;
    }

    public boolean hasQuery() {
        return this._query != null;
    }

    public boolean hasUserinfo() {
        return this._userinfo != null;
    }

    protected int indexFirstOf(String s, String delims) {
        return this.indexFirstOf(s, delims, -1);
    }

    protected int indexFirstOf(String s, String delims, int offset) {
        if (s == null || s.length() == 0) {
            return -1;
        }
        if (delims == null || delims.length() == 0) {
            return -1;
        }
        if (offset < 0) {
            offset = 0;
        } else if (offset > s.length()) {
            return -1;
        }
        int min = s.length();
        char[] delim = delims.toCharArray();
        int i = 0;
        while (i < delim.length) {
            int at = s.indexOf(delim[i], offset);
            if (at >= 0 && at < min) {
                min = at;
            }
            ++i;
        }
        return min == s.length() ? -1 : min;
    }

    protected int indexFirstOf(char[] s, char delim) {
        return this.indexFirstOf(s, delim, 0);
    }

    protected int indexFirstOf(char[] s, char delim, int offset) {
        if (s == null || s.length == 0) {
            return -1;
        }
        if (offset < 0) {
            offset = 0;
        } else if (offset > s.length) {
            return -1;
        }
        int i = offset;
        while (i < s.length) {
            if (s[i] == delim) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isAbsPath() {
        return this._is_abs_path;
    }

    public boolean isAbsoluteURI() {
        return this._is_only_fragment ? false : this._scheme != null;
    }

    public boolean isHierPart() {
        return this._is_hier_part;
    }

    public boolean isHostname() {
        return this._is_hostname;
    }

    public boolean isIPv4address() {
        return this._is_IPv4address;
    }

    public boolean isIPv6reference() {
        return this._is_IPv6reference;
    }

    public boolean isNetPath() {
        return this._is_net_path || this._authority != null;
    }

    public boolean isOpaquePart() {
        return this._is_opaque_part;
    }

    public boolean isRegName() {
        return this._is_reg_name;
    }

    public boolean isRelPath() {
        return this._is_rel_path;
    }

    public boolean isRelativeURI() {
        return this._is_only_fragment ? false : this._scheme == null;
    }

    public boolean isServer() {
        return this._is_server;
    }

    public void normalize() {
        this._path = this.normalize(this._path);
    }

    protected char[] normalize(char[] path) {
        int at;
        if (path == null) {
            return null;
        }
        String normalized = new String(path);
        boolean endsWithSlash = true;
        if (!normalized.endsWith("/")) {
            normalized = String.valueOf(normalized) + '/';
            endsWithSlash = false;
        }
        if (normalized.endsWith("/./") || normalized.endsWith("/../")) {
            endsWithSlash = true;
        }
        while ((at = normalized.indexOf("/./")) != -1) {
            normalized = String.valueOf(normalized.substring(0, at)) + normalized.substring(at + 2);
        }
        while ((at = normalized.indexOf("/../")) != -1) {
            if (at == 0) {
                normalized = "/";
                break;
            }
            int backward = normalized.lastIndexOf(47, at - 1);
            if (backward == -1) {
                normalized = normalized.substring(at + 4);
                continue;
            }
            normalized = String.valueOf(normalized.substring(0, backward)) + normalized.substring(at + 3);
        }
        while ((at = normalized.indexOf("//")) != -1) {
            normalized = String.valueOf(normalized.substring(0, at)) + normalized.substring(at + 1);
        }
        if (!endsWithSlash && normalized.endsWith("/")) {
            normalized = normalized.substring(0, normalized.length() - 1);
        } else if (endsWithSlash && !normalized.endsWith("/")) {
            normalized = String.valueOf(normalized) + "/";
        }
        return normalized.toCharArray();
    }

    protected void parseAuthority(String original, boolean escaped) throws URIException {
        this._is_IPv6reference = false;
        this._is_IPv4address = false;
        this._is_hostname = false;
        this._is_server = false;
        this._is_reg_name = false;
        boolean has_port = true;
        int from = 0;
        int next = original.indexOf(64);
        if (next != -1) {
            this._userinfo = escaped ? original.substring(0, next).toCharArray() : this.encode(original.substring(0, next), allowed_userinfo);
            from = next + 1;
        }
        if ((next = original.indexOf(91, from)) >= from) {
            next = original.indexOf(93, from);
            if (next == -1) {
                throw new URIException(1, "IPv6reference");
            }
            this._host = escaped ? original.substring(from, next).toCharArray() : this.encode(original.substring(from, ++next), allowed_IPv6reference);
            this._is_IPv6reference = true;
        } else {
            next = original.indexOf(58, from);
            if (next == -1) {
                next = original.length();
                has_port = false;
            }
            this._host = original.substring(from, next).toCharArray();
            if (this.validate(this._host, IPv4address)) {
                this._is_IPv4address = true;
            } else if (this.validate(this._host, hostname)) {
                this._is_hostname = true;
            } else {
                this._is_reg_name = true;
            }
        }
        if (this._is_reg_name) {
            this._is_IPv6reference = false;
            this._is_IPv4address = false;
            this._is_hostname = false;
            this._is_server = false;
            this._authority = escaped ? original.toString().toCharArray() : this.encode(original.toString(), allowed_reg_name);
        } else {
            if (original.length() - 1 > next && has_port && original.charAt(next) == ':') {
                from = next + 1;
                try {
                    this._port = Integer.parseInt(original.substring(from));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new URIException(1, "invalid port number");
                }
            }
            StringBuffer buf = new StringBuffer();
            if (this._userinfo != null) {
                buf.append(this._userinfo);
                buf.append('@');
            }
            if (this._host != null) {
                buf.append(this._host);
                if (this._port != -1) {
                    buf.append(':');
                    buf.append(this._port);
                }
            }
            this._authority = buf.toString().toCharArray();
            this._is_server = true;
        }
    }

    protected void parseUriReference(String original, boolean escaped) throws URIException {
        int from;
        if (original == null) {
            throw new URIException("URI-Reference required");
        }
        String tmp = original.trim();
        int at = this.indexFirstOf(tmp, ":/?#", from = 0);
        if (at == -1) {
            at = 0;
        }
        int length = tmp.length();
        if (at > 0 && at < length && tmp.charAt(at) == ':') {
            char[] target = tmp.substring(0, at).toLowerCase().toCharArray();
            if (!this.validate(target, scheme)) {
                throw new URIException("incorrect scheme");
            }
            this._scheme = target;
            from = ++at;
        }
        this._is_hier_part = false;
        this._is_rel_path = false;
        this._is_abs_path = false;
        this._is_net_path = false;
        if (at >= 0 && at < length && tmp.charAt(at) == '/') {
            this._is_hier_part = true;
            if (at + 2 < length && tmp.charAt(at + 1) == '/') {
                int next = this.indexFirstOf(tmp, "/?#", at + 2);
                if (next == -1) {
                    next = tmp.substring(at + 2).length() == 0 ? at + 2 : tmp.length();
                }
                this.parseAuthority(tmp.substring(at + 2, next), escaped);
                from = at = next;
                this._is_net_path = true;
            }
            if (from == at) {
                this._is_abs_path = true;
            }
        }
        if (from < length) {
            int next = this.indexFirstOf(tmp, "?#", from);
            if (next == -1) {
                next = tmp.length();
            }
            if (!this._is_abs_path) {
                if (!escaped && this.prevalidate(tmp.substring(from, next), disallowed_rel_path) || escaped && this.validate(tmp.substring(from, next).toCharArray(), rel_path)) {
                    this._is_rel_path = true;
                } else if (!escaped && this.prevalidate(tmp.substring(from, next), disallowed_opaque_part) || escaped && this.validate(tmp.substring(from, next).toCharArray(), opaque_part)) {
                    this._is_opaque_part = true;
                } else {
                    this._path = null;
                }
            }
            this.setPath(tmp.substring(from, next));
            at = next;
        }
        if (at >= 0 && at + 1 < length && tmp.charAt(at) == '?') {
            int next = tmp.indexOf(35, at + 1);
            if (next == -1) {
                next = tmp.length();
            }
            this._query = escaped ? tmp.substring(at + 1, next).toCharArray() : this.encode(tmp.substring(at + 1, next), allowed_query);
            at = next;
        }
        if (at >= 0 && at + 1 < length && tmp.charAt(at) == '#') {
            char[] cArray = this._fragment = escaped ? tmp.substring(at + 1).toCharArray() : this.encode(tmp.substring(at + 1), allowed_fragment);
            if (!(this._is_abs_path || this._is_rel_path || this._is_opaque_part)) {
                this._is_only_fragment = true;
            }
        }
        this.setUriReference();
    }

    protected boolean prevalidate(String component, BitSet disallowed) {
        if (component == null) {
            return false;
        }
        char[] target = component.toCharArray();
        int i = 0;
        while (i < target.length) {
            if (disallowed.get(target[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    protected char[] resolvePath(char[] base_path, char[] rel_path) {
        String base = base_path == null ? "" : new String(base_path);
        int at = base.lastIndexOf(47);
        if (at != -1) {
            base_path = base.substring(0, at + 1).toCharArray();
        }
        if (rel_path == null || rel_path.length == 0) {
            return this.normalize(base_path);
        }
        if (rel_path[0] == '/') {
            return rel_path;
        }
        StringBuffer buff = new StringBuffer(base.length() + rel_path.length);
        if (at != -1) {
            buff.append(base.substring(0, at + 1));
            buff.append(rel_path);
        }
        return this.normalize(buff.toString().toCharArray());
    }

    public void setAuthority(String authority) throws URIException {
        this.parseAuthority(authority, false);
        this.setUriReference();
    }

    public void setDebug(int level) {
        debug = level;
    }

    public static void setDocumentCharset(String charset) {
        _documentCharset = charset;
    }

    public void setFragment(String fragment) throws URIException {
        this._fragment = this.encode(fragment, allowed_fragment);
        this.setUriReference();
    }

    protected void setPath(String path) throws URIException {
        if (this._is_net_path || this._is_abs_path) {
            this._path = this.encode(path, allowed_abs_path);
        } else if (this._is_rel_path) {
            StringBuffer buff = new StringBuffer(path.length());
            int at = path.indexOf(47);
            if (at > 0) {
                buff.append(this.encode(path.substring(0, at), allowed_rel_path));
                buff.append(this.encode(path.substring(at), allowed_abs_path));
            } else {
                buff.append(this.encode(path, allowed_rel_path));
            }
            this._path = buff.toString().toCharArray();
        } else if (this._is_opaque_part) {
            this._opaque = this.encode(path, allowed_opaque_part);
        } else {
            throw new URIException(1, "incorrect path");
        }
    }

    public static void setProtocolCharset(String charset) {
        _protocolCharset = charset;
    }

    public void setQuery(String query) throws URIException {
        this._query = this.encode(query, allowed_query);
        this.setUriReference();
    }

    protected void setUriReference() {
        StringBuffer buf = new StringBuffer();
        if (this._scheme != null) {
            buf.append(this._scheme);
            buf.append(':');
        }
        if (this._is_net_path) {
            buf.append("//");
            if (this._authority != null) {
                if (this._userinfo != null) {
                    if (this._host != null) {
                        buf.append(this._host);
                        if (this._port != -1) {
                            buf.append(':');
                            buf.append(this._port);
                        }
                    }
                } else {
                    buf.append(this._authority);
                }
            }
        }
        if (this._opaque != null && this._is_opaque_part) {
            buf.append(this._opaque);
        } else if (this._path != null) {
            if (this._path.length != 0) {
                buf.append(this._path);
            }
            if (this._query != null) {
                buf.append('?');
                buf.append(this._query);
            }
        }
        if (this._fragment != null) {
            buf.append('#');
            buf.append(this._fragment);
        }
        this._uri = buf.toString().toCharArray();
    }

    public String toString() {
        return this.getEscapedURI();
    }

    protected boolean validate(char[] component, int soffset, int eoffset, BitSet generous) {
        if (eoffset == -1) {
            eoffset = component.length - 1;
        }
        int i = soffset;
        while (i < eoffset) {
            if (!generous.get(component[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean validate(char[] component, BitSet generous) {
        return this.validate(component, 0, -1, generous);
    }

    protected void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    public static class LocaleToCharsetMap {
        private static Hashtable map = new Hashtable();

        static {
            map.put("ar", "ISO-8859-6");
            map.put("be", "ISO-8859-5");
            map.put("bg", "ISO-8859-5");
            map.put("ca", "ISO-8859-1");
            map.put("cs", "ISO-8859-2");
            map.put("da", "ISO-8859-1");
            map.put("de", "ISO-8859-1");
            map.put("el", "ISO-8859-7");
            map.put("en", "ISO-8859-1");
            map.put("es", "ISO-8859-1");
            map.put("et", "ISO-8859-1");
            map.put("fi", "ISO-8859-1");
            map.put("fr", "ISO-8859-1");
            map.put("hr", "ISO-8859-2");
            map.put("hu", "ISO-8859-2");
            map.put("is", "ISO-8859-1");
            map.put("it", "ISO-8859-1");
            map.put("iw", "ISO-8859-8");
            map.put("ja", "Shift_JIS");
            map.put("ko", "EUC-KR");
            map.put("lt", "ISO-8859-2");
            map.put("lv", "ISO-8859-2");
            map.put("mk", "ISO-8859-5");
            map.put("nl", "ISO-8859-1");
            map.put("no", "ISO-8859-1");
            map.put("pl", "ISO-8859-2");
            map.put("pt", "ISO-8859-1");
            map.put("ro", "ISO-8859-2");
            map.put("ru", "ISO-8859-5");
            map.put("sh", "ISO-8859-5");
            map.put("sk", "ISO-8859-2");
            map.put("sl", "ISO-8859-2");
            map.put("sq", "ISO-8859-2");
            map.put("sr", "ISO-8859-5");
            map.put("sv", "ISO-8859-1");
            map.put("tr", "ISO-8859-9");
            map.put("uk", "ISO-8859-5");
            map.put("zh", "GB2312");
            map.put("zh_TW", "Big5");
        }

        public static String getCharset(Locale locale) {
            String charset = (String)map.get(locale.toString());
            if (charset != null) {
                return charset;
            }
            charset = (String)map.get(locale.getLanguage());
            return charset;
        }
    }
}

