/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search;

import org.apache.slide.search.InvalidScopeException;

public class SlideUri {
    private String context;
    private String path;

    public SlideUri(String requestUri) {
        if (requestUri == null) {
            this.context = null;
            this.path = "";
        } else {
            this.context = this.getContextOfRelPath(requestUri);
            this.path = this.getPathOfRelPath(requestUri);
        }
    }

    private String getContextOfRelPath(String relPath) {
        String result = null;
        int posSlash = relPath.indexOf(47, 1);
        result = posSlash == -1 ? relPath.substring(0) : relPath.substring(0, posSlash);
        return result;
    }

    public String getContextPath(String slidePath) {
        if (this.context == null) {
            throw new RuntimeException("getContextPath not allowed in this context");
        }
        return String.valueOf(this.context) + slidePath;
    }

    private String getPathOfRelPath(String relPath) {
        String result = null;
        int posSlash = relPath.indexOf(47, 1);
        result = posSlash == -1 ? "" : relPath.substring(posSlash);
        return result;
    }

    public String getSlidePath(String relPath) throws InvalidScopeException {
        if (this.context == null) {
            if (!relPath.startsWith("/")) {
                throw new InvalidScopeException("absolute scope is required");
            }
            return relPath;
        }
        StringBuffer sb = new StringBuffer();
        if (relPath.startsWith("/")) {
            String relContext = this.getContextOfRelPath(relPath);
            if (!relContext.equals(this.context)) {
                throw new InvalidScopeException("Uri does not refer to " + this.context + ". If an absolute scope is used, it must start with /" + this.context);
            }
            relPath = this.getPathOfRelPath(relPath);
        } else {
            sb.append(this.path);
            if (!this.path.endsWith("/")) {
                sb.append("/");
            }
        }
        sb.append(relPath);
        return sb.toString();
    }
}

