/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.content;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.slide.common.ObjectValidationFailedException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.util.Messages;

public final class NodeRevisionDescriptor
implements Serializable,
Cloneable {
    public static final String CREATION_DATE = "creationdate";
    public static final String LAST_MODIFIED = "getlastmodified";
    public static final String NAME = "displayname";
    public static final String RESOURCE_TYPE = "resourcetype";
    public static final String TYPE = "resourcetype";
    public static final String SOURCE = "source";
    public static final String OWNER = "owner";
    public static final String CONTENT_TYPE = "getcontenttype";
    public static final String CONTENT_LANGUAGE = "getcontentlanguage";
    public static final String CONTENT_LENGTH = "getcontentlength";
    public static final String ETAG = "getetag";
    public static final String COLLECTION_TYPE = "<collection/>";
    protected static final SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    protected static final SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'")};
    protected static final SimpleDateFormat creationDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private String branchName = "main";
    private NodeRevisionNumber number;
    private Vector labels;
    private Hashtable properties = new Hashtable();
    static /* synthetic */ Class class$org$apache$slide$content$NodeRevisionDescriptor;

    static {
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        creationDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        int i = 0;
        while (i < formats.length) {
            formats[i].setTimeZone(TimeZone.getTimeZone("GMT"));
            ++i;
        }
    }

    public NodeRevisionDescriptor() {
        this.labels = new Vector();
        this.initDefaultProperties();
    }

    public NodeRevisionDescriptor(long contentLength) {
        this();
        this.setContentLength(contentLength);
    }

    public NodeRevisionDescriptor(NodeRevisionNumber number, String branchName, Vector labels, Hashtable properties) {
        this();
        this.number = number;
        if (branchName != null) {
            this.branchName = branchName;
        }
        this.labels = labels;
        this.setProperties(properties);
    }

    public void addLabel(String label) {
        this.labels.addElement(label);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public NodeRevisionDescriptor cloneObject() {
        NodeRevisionDescriptor result = null;
        try {
            result = (NodeRevisionDescriptor)super.clone();
            Hashtable propertiesClone = new Hashtable();
            Enumeration propertiesList = this.properties.keys();
            while (propertiesList.hasMoreElements()) {
                Object key = propertiesList.nextElement();
                Object value = this.properties.get(key);
                propertiesClone.put(key, value);
            }
            result.properties = propertiesClone;
            result.labels = (Vector)this.labels.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Enumeration enumerateLabels() {
        return this.labels.elements();
    }

    public Enumeration enumerateProperties() {
        return this.properties.elements();
    }

    public Enumeration enumeratePropertiesName() {
        Vector<String> result = new Vector<String>();
        Enumeration propertyList = this.enumerateProperties();
        while (propertyList.hasMoreElements()) {
            NodeProperty currentProperty = (NodeProperty)propertyList.nextElement();
            result.addElement(currentProperty.getName());
        }
        return result.elements();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof NodeRevisionDescriptor) {
            NodeRevisionDescriptor revisionDescriptor = (NodeRevisionDescriptor)obj;
            result = this.getRevisionNumber().equals(revisionDescriptor.getRevisionNumber());
        }
        return result;
    }

    public boolean exists(String name) {
        return this.exists(name, "DAV:");
    }

    public boolean exists(String name, String namespace) {
        if (name != null) {
            return this.properties.get(this.getNamespacedPropertyName(namespace, name)) != null;
        }
        return false;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public String getContentLanguage() {
        NodeProperty contentLanguage = this.getProperty(CONTENT_LANGUAGE);
        if (contentLanguage == null) {
            return new String();
        }
        return (String)contentLanguage.getValue();
    }

    public long getContentLength() {
        NodeProperty contentLength = this.getProperty(CONTENT_LENGTH);
        if (contentLength == null) {
            return -1L;
        }
        if (contentLength.getValue() instanceof Long) {
            return (Long)contentLength.getValue();
        }
        if (contentLength.getValue() instanceof String) {
            return new Long((String)contentLength.getValue());
        }
        return -1L;
    }

    public String getContentType() {
        NodeProperty contentType = this.getProperty(CONTENT_TYPE);
        if (contentType == null) {
            return new String();
        }
        return (String)contentType.getValue();
    }

    public String getCreationDate() {
        NodeProperty creationDate = this.getProperty(CREATION_DATE);
        if (creationDate == null) {
            return null;
        }
        if (creationDate.getValue() instanceof Date) {
            return creationDateFormat.format((Date)creationDate.getValue());
        }
        return creationDate.getValue().toString();
    }

    public Date getCreationDateAsDate() {
        NodeProperty creationDate = this.getProperty(CREATION_DATE);
        if (creationDate == null) {
            return null;
        }
        if (creationDate.getValue() instanceof Date) {
            return (Date)creationDate.getValue();
        }
        String creationDateValue = creationDate.getValue().toString();
        Date result = null;
        int i = 0;
        while (result == null && i < formats.length) {
            try {
                SimpleDateFormat simpleDateFormat = formats[i];
                synchronized (simpleDateFormat) {
                    result = formats[i].parse(creationDateValue);
                }
            }
            catch (ParseException parseException) {}
            ++i;
        }
        return result;
    }

    public String getETag() {
        NodeProperty contentType = this.getProperty(ETAG);
        if (contentType == null) {
            return new String();
        }
        return (String)contentType.getValue();
    }

    public String getLastModified() {
        NodeProperty lastModified = this.getProperty(LAST_MODIFIED);
        if (lastModified == null) {
            return null;
        }
        if (lastModified.getValue() instanceof Date) {
            return format.format((Date)lastModified.getValue());
        }
        return lastModified.getValue().toString();
    }

    public Date getLastModifiedAsDate() {
        NodeProperty lastModified = this.getProperty(LAST_MODIFIED);
        if (lastModified == null) {
            return null;
        }
        if (lastModified.getValue() instanceof Date) {
            return (Date)lastModified.getValue();
        }
        String lastModifiedValue = lastModified.getValue().toString();
        Date result = null;
        int i = 0;
        while (result == null && i < formats.length) {
            try {
                SimpleDateFormat simpleDateFormat = formats[i];
                synchronized (simpleDateFormat) {
                    result = formats[i].parse(lastModifiedValue);
                }
            }
            catch (ParseException parseException) {}
            ++i;
        }
        return result;
    }

    public String getName() {
        NodeProperty name = this.getProperty(NAME);
        if (name == null) {
            return new String();
        }
        return (String)name.getValue();
    }

    public String getNamespacedPropertyName(String namespace, String propertyName) {
        String result = namespace == null ? propertyName : String.valueOf(namespace) + propertyName;
        return result;
    }

    public String getOwner() {
        NodeProperty owner = this.getProperty(OWNER);
        if (owner == null) {
            return new String();
        }
        return (String)owner.getValue();
    }

    Hashtable getProperties() {
        return this.properties;
    }

    public Enumeration getPropertiesNames() {
        return this.enumeratePropertiesName();
    }

    public Enumeration getPropertiesValues() {
        return this.enumerateProperties();
    }

    public NodeProperty getProperty(String name) {
        return this.getProperty(name, "DAV:");
    }

    public NodeProperty getProperty(String name, String namespace) {
        Object result = this.properties.get(this.getNamespacedPropertyName(namespace, name));
        if (result != null) {
            return (NodeProperty)result;
        }
        return null;
    }

    public String getResourceType() {
        NodeProperty resourceType = this.getProperty("resourcetype");
        if (resourceType == null) {
            return new String();
        }
        return (String)resourceType.getValue();
    }

    public NodeRevisionNumber getRevisionNumber() {
        return this.number;
    }

    public String getSource() {
        NodeProperty source = this.getProperty(SOURCE);
        if (source == null) {
            return new String();
        }
        return (String)source.getValue();
    }

    private void initDefaultProperties() {
        this.setCreationDate(new Date());
        this.setName("");
        this.setResourceType(COLLECTION_TYPE);
        this.setProperty(SOURCE, "");
        this.setContentLength(-1L);
        this.setLastModified(new Date());
    }

    public boolean propertyValueContains(String name, String substr) {
        Object v;
        boolean result = false;
        NodeProperty p = this.getProperty(name);
        if (p != null && (v = p.getValue()) instanceof String && ((String)v).indexOf(substr) >= 0) {
            result = true;
        }
        return result;
    }

    public boolean propertyValueContains(String name, String namespace, String substr) {
        Object v;
        boolean result = false;
        NodeProperty p = this.getProperty(name, namespace);
        if (p != null && (v = p.getValue()) instanceof String && ((String)v).indexOf(substr) >= 0) {
            result = true;
        }
        return result;
    }

    public void removeLabel(String label) {
        this.labels.removeElement(label);
    }

    public void removeLabels() {
        this.labels.removeAllElements();
    }

    public void removeProperty(String property) {
        this.properties.remove(this.getNamespacedPropertyName("DAV:", property));
    }

    public void removeProperty(String property, String nameSpace) {
        this.properties.remove(this.getNamespacedPropertyName(nameSpace, property));
    }

    public void removeProperty(NodeProperty property) {
        this.properties.remove(this.getNamespacedPropertyName(property.getNamespace(), property.getName()));
    }

    void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public void setContentLanguage(String contentLanguage) {
        this.setProperty(CONTENT_LANGUAGE, contentLanguage);
    }

    public void setContentLength(long contentLength) {
        this.setProperty(CONTENT_LENGTH, new Long(contentLength));
    }

    public void setContentLength(String contentLength) {
        Long contentLengthValue = null;
        try {
            contentLengthValue = new Long(contentLength);
        }
        catch (NumberFormatException numberFormatException) {}
        if (contentLengthValue == null) {
            contentLengthValue = new Long(0L);
        }
        this.setProperty(CONTENT_LENGTH, contentLengthValue);
    }

    public void setContentType(String contentType) {
        this.setProperty(CONTENT_TYPE, contentType);
    }

    public void setCreationDate(String creationDate) {
        this.setProperty(CREATION_DATE, creationDate);
    }

    public void setCreationDate(Date creationDate) {
        this.setProperty(CREATION_DATE, creationDateFormat.format(creationDate));
    }

    void setDefaultProperties(Enumeration defaultProperties) {
        while (defaultProperties.hasMoreElements()) {
            String namespace;
            NodeProperty currentProperty = (NodeProperty)defaultProperties.nextElement();
            String name = currentProperty.getName();
            NodeProperty lookup = this.getProperty(name, namespace = currentProperty.getNamespace());
            if (lookup != null) continue;
            this.setProperty(name, namespace, currentProperty.getValue());
        }
    }

    public void setETag(String eTag) {
        this.setProperty(ETAG, eTag);
    }

    public void setLastModified(String lastModified) {
        this.setProperty(LAST_MODIFIED, lastModified);
    }

    public void setLastModified(Date lastModified) {
        this.setProperty(LAST_MODIFIED, format.format(lastModified));
    }

    public void setName(String name) {
        this.setProperty(NAME, name);
    }

    public void setOwner(String owner) {
        this.setProperty(OWNER, owner);
    }

    public void setOwner(String owner, String userpath) {
        this.setProperty(OWNER, String.valueOf(userpath) + "/" + owner);
    }

    void setProperties(Hashtable properties) {
        this.properties = properties;
    }

    public void setProperty(String name, Object value) {
        this.setProperty(new NodeProperty(name, value));
    }

    public void setProperty(String name, String namespace, Object value) {
        this.setProperty(new NodeProperty(name, value, namespace));
    }

    public void setProperty(NodeProperty property) {
        this.properties.put(this.getNamespacedPropertyName(property.getNamespace(), property.getName()), property);
    }

    public void setResourceType(String resourceType) {
        this.setProperty("resourcetype", resourceType);
    }

    void setRevisionNumber(NodeRevisionNumber number) {
        this.number = number;
    }

    public void setSource(String source) {
        this.setProperty(SOURCE, source);
    }

    public void validate() {
        if (this.branchName == null) {
            throw new ObjectValidationFailedException(Messages.message(String.valueOf((class$org$apache$slide$content$NodeRevisionDescriptor != null ? class$org$apache$slide$content$NodeRevisionDescriptor : (class$org$apache$slide$content$NodeRevisionDescriptor = NodeRevisionDescriptor.class$("org.apache.slide.content.NodeRevisionDescriptor"))).getName()) + ".nullBranchName"));
        }
        if (this.number == null) {
            throw new ObjectValidationFailedException(Messages.message(String.valueOf((class$org$apache$slide$content$NodeRevisionDescriptor != null ? class$org$apache$slide$content$NodeRevisionDescriptor : (class$org$apache$slide$content$NodeRevisionDescriptor = NodeRevisionDescriptor.class$("org.apache.slide.content.NodeRevisionDescriptor"))).getName()) + ".nullNumber"));
        }
        this.number.validate();
        if (this.labels == null) {
            throw new ObjectValidationFailedException(Messages.message(String.valueOf((class$org$apache$slide$content$NodeRevisionDescriptor != null ? class$org$apache$slide$content$NodeRevisionDescriptor : (class$org$apache$slide$content$NodeRevisionDescriptor = NodeRevisionDescriptor.class$("org.apache.slide.content.NodeRevisionDescriptor"))).getName()) + ".nullLabels"));
        }
        if (this.properties == null) {
            throw new ObjectValidationFailedException(Messages.message(String.valueOf((class$org$apache$slide$content$NodeRevisionDescriptor != null ? class$org$apache$slide$content$NodeRevisionDescriptor : (class$org$apache$slide$content$NodeRevisionDescriptor = NodeRevisionDescriptor.class$("org.apache.slide.content.NodeRevisionDescriptor"))).getName()) + ".nullProperties"));
        }
        Enumeration propertyList = this.properties.elements();
        while (propertyList.hasMoreElements()) {
            Object obj = propertyList.nextElement();
            if (!(obj instanceof NodeProperty)) {
                throw new ObjectValidationFailedException(Messages.message(String.valueOf((class$org$apache$slide$content$NodeRevisionDescriptor != null ? class$org$apache$slide$content$NodeRevisionDescriptor : (class$org$apache$slide$content$NodeRevisionDescriptor = NodeRevisionDescriptor.class$("org.apache.slide.content.NodeRevisionDescriptor"))).getName()) + ".invalidPropertyType"));
            }
            ((NodeProperty)obj).validate();
        }
    }
}

