/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import org.apache.slide.common.Domain;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.Scope;
import org.apache.slide.common.ScopeTokenizer;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceMissingOnRootNodeException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.store.Store;

public final class Uri
implements Cloneable,
Serializable {
    private transient Namespace namespace;
    private transient String uri;
    private transient ScopeTokenizer scopes;
    private transient Scope scope;
    private transient int pk;
    private transient Store store;
    private transient SlideToken token;

    public Uri(Namespace namespace, String uri) {
        this(null, namespace, uri);
    }

    public Uri(SlideToken token, Namespace namespace, String uri) {
        this.token = token;
        this.namespace = namespace;
        this.parseUri(uri);
    }

    public Uri cloneObject() {
        Uri result = null;
        try {
            result = (Uri)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Uri) {
            return this.uri.equals(obj.toString());
        }
        return false;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Uri getParentUri() {
        Uri result = this.scopes.getParentUri();
        if (result != null) {
            result.setToken(this.token);
        }
        return result;
    }

    public String getRelative() {
        return this.uri.substring(this.scope.toString().length());
    }

    public Scope getScope() {
        return this.scope;
    }

    public Enumeration getScopes() {
        return this.scopes.elements();
    }

    public Store getStore() {
        return this.store;
    }

    public SlideToken getToken() {
        return this.token;
    }

    public int hashCode() {
        return this.pk;
    }

    public void invalidateServices() {
        this.store = null;
        this.pk = 0;
        this.parseUri(this.uri);
    }

    public boolean isParent(Uri uri) {
        return this.uri.startsWith(uri.toString());
    }

    private void parseUri(String uri) {
        this.scopes = new ScopeTokenizer(this.namespace, uri);
        this.uri = this.scopes.getUri();
        this.store = null;
        while (this.store == null && this.scopes.hasMoreElements()) {
            Scope courScope = this.scopes.nextScope();
            try {
                if (this.store != null) continue;
                this.store = this.token == null ? this.namespace.retrieveStore(courScope, null) : this.namespace.retrieveStore(courScope, this.token.getCredentialsToken());
                if (this.store == null) continue;
                this.scope = courScope;
                this.pk = uri.substring(this.scope.toString().length()).hashCode();
            }
            catch (ServiceConnectionFailedException serviceConnectionFailedException) {
            }
            catch (ServiceAccessException serviceAccessException) {}
        }
        if (this.store == null) {
            throw new ServiceMissingOnRootNodeException();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String namespaceName = (String)in.readObject();
        this.namespace = Domain.getNamespace(namespaceName);
        this.parseUri((String)in.readObject());
    }

    public void reconnectServices() {
        try {
            if (this.token == null) {
                this.store.connectIfNeeded(null);
            } else {
                this.store.connectIfNeeded(this.token.getCredentialsToken());
            }
        }
        catch (ServiceConnectionFailedException serviceConnectionFailedException) {
            this.parseUri(this.uri);
        }
        catch (ServiceAccessException serviceAccessException) {
            this.parseUri(this.uri);
        }
    }

    public void setToken(SlideToken token) {
        this.token = token;
    }

    public void setUri(String uri) {
        this.parseUri(uri);
    }

    public String toString() {
        return this.uri;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.namespace.getName());
        out.writeObject(this.uri);
    }
}

