/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.regexp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.regexp.Jdk14RegexpMatcher;
import org.apache.tools.ant.util.regexp.Regexp;
import org.apache.tools.ant.util.regexp.RegexpUtil;

public class Jdk14RegexpRegexp
extends Jdk14RegexpMatcher
implements Regexp {
    protected int getSubsOptions(int options) {
        int subsOptions = 1;
        if (RegexpUtil.hasFlag((int)options, (int)16)) {
            subsOptions = 16;
        }
        return subsOptions;
    }

    public String substitute(String input, String argument, int options) throws BuildException {
        StringBuffer subst = new StringBuffer();
        int i = 0;
        while (i < argument.length()) {
            char c = argument.charAt(i);
            if (c == '\\') {
                if (++i < argument.length()) {
                    c = argument.charAt(i);
                    int value = Character.digit(c, 10);
                    if (value > -1) {
                        subst.append("$").append(value);
                    } else {
                        subst.append(c);
                    }
                } else {
                    subst.append('\\');
                }
            } else {
                subst.append(c);
            }
            ++i;
        }
        argument = subst.toString();
        int sOptions = this.getSubsOptions(options);
        Pattern p = this.getCompiledPattern(options);
        StringBuffer sb = new StringBuffer();
        Matcher m = p.matcher(input);
        if (RegexpUtil.hasFlag((int)sOptions, (int)16)) {
            sb.append(m.replaceAll(argument));
        } else {
            boolean res = m.find();
            if (res) {
                m.appendReplacement(sb, argument);
                m.appendTail(sb);
            } else {
                sb.append(input);
            }
        }
        return sb.toString();
    }
}

