/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.mail;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;

public class ByteArrayDataSource
implements DataSource {
    private byte[] data;
    private String type;
    private ByteArrayOutputStream baos;

    public ByteArrayDataSource(byte[] data, String type) {
        this.data = data;
        this.type = type;
    }

    /*
     * WARNING - void declaration
     */
    public ByteArrayDataSource(InputStream is, String type) {
        this.type = type;
        try {
            int ch;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            BufferedInputStream isReader = new BufferedInputStream(is);
            BufferedOutputStream osWriter = new BufferedOutputStream(os);
            while ((ch = isReader.read()) != -1) {
                void var3_6;
                osWriter.write((int)var3_6);
            }
            this.data = os.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ByteArrayDataSource(String data, String type) {
        this.type = type;
        try {
            this.data = data.getBytes("iso-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getContentType() {
        if (this.type == null) {
            return "application/octet-stream";
        }
        return this.type;
    }

    public InputStream getInputStream() throws IOException {
        if (this.data == null) {
            throw new IOException("no data");
        }
        return new ByteArrayInputStream(this.data);
    }

    public String getName() {
        return "ByteArrayDataSource";
    }

    public OutputStream getOutputStream() throws IOException {
        this.baos = new ByteArrayOutputStream();
        return this.baos;
    }
}

