/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.servlet;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.servlet.ServletService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.ServletUtils;

public class TurbineServletService
extends TurbineBaseService
implements ServletService {
    private ServletContext servletContext = null;
    private ServletConfig servletConfig = null;

    public void init() throws InitializationException {
        ServletConfig conf = Turbine.getTurbineServletConfig();
        this.init(conf);
    }

    public void init(ServletConfig servletConfig) {
        try {
            this.servletConfig = servletConfig;
            this.servletContext = servletConfig.getServletContext();
            Log.debug("[TurbineServletService] Initializing with ServletConfig");
        }
        catch (Exception e) {
            Log.error("Cannot initialize TurbineServletService.");
            Log.error(e);
        }
        this.setInit(true);
    }

    public URL getResource(String uri) {
        if (this.servletContext == null) {
            return null;
        }
        URL url = null;
        try {
            url = this.getServletContext().getResource(uri);
            if (url != null && url.toString().startsWith("classloader:")) {
                url = new URL("file:" + url.toString().substring(12));
            } else if (url == null) {
                url = new URL("file:" + this.getServletContext().getRealPath(uri));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    public InputStream getResourceAsStream(String uri) {
        if (this.servletContext == null) {
            return null;
        }
        InputStream is = null;
        is = this.servletContext.getResourceAsStream(uri);
        return is;
    }

    public String getRealPath(String uri) {
        if (this.getServletContext() == null || uri == null) {
            return null;
        }
        return this.getServletContext().getRealPath(uri);
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getServerScheme() {
        return Turbine.getServerScheme();
    }

    public String getServerName() {
        return Turbine.getServerName();
    }

    public String getServerPort() {
        return Turbine.getServerPort();
    }

    public String getContextPath() {
        return Turbine.getContextPath();
    }

    public String expandRelative(String path) {
        return ServletUtils.expandRelative(this.getServletConfig(), path);
    }
}

