/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.impl.db.entity;

import java.util.Iterator;
import org.apache.fulcrum.security.TurbineSecurity;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbineGroup;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.TurbineSecurityException;

public class TurbineGroup
extends BaseTurbineGroup
implements Group,
Comparable {
    public TurbineGroup() {
    }

    public TurbineGroup(String name) {
        this.setName(name);
    }

    public static Group getGlobalGroup() {
        return TurbineSecurity.getGlobalGroup();
    }

    public static Group create(String name) throws TurbineSecurityException {
        return TurbineSecurity.createGroup(name);
    }

    public void save() throws TurbineSecurityException {
        TurbineSecurity.saveGroup(this);
    }

    public void remove() throws TurbineSecurityException {
        TurbineSecurity.removeGroup(this);
    }

    public void rename(String name) throws TurbineSecurityException {
        TurbineSecurity.renameGroup(this, name);
    }

    public void grant(User user, Role role) throws TurbineSecurityException {
        TurbineSecurity.grant(user, this, role);
    }

    public void grant(User user, RoleSet roleSet) throws TurbineSecurityException {
        Iterator roles = roleSet.elements();
        while (roles.hasNext()) {
            TurbineSecurity.grant(user, this, (Role)roles.next());
        }
    }

    public void revoke(User user, Role role) throws TurbineSecurityException {
        TurbineSecurity.revoke(user, this, role);
    }

    public void revoke(User user, RoleSet roleSet) throws TurbineSecurityException {
        Iterator roles = roleSet.elements();
        while (roles.hasNext()) {
            TurbineSecurity.revoke(user, this, (Role)roles.next());
        }
    }

    public int compareTo(Object obj) {
        if (this.getClass() != obj.getClass()) {
            throw new ClassCastException();
        }
        String name1 = ((SecurityEntity)obj).getName();
        String name2 = this.getName();
        return name2.compareTo(name1);
    }
}

