/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.intake.Retrievable;
import org.apache.fulcrum.intake.TurbineIntake;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.FieldFactory;
import org.apache.fulcrum.intake.xmlmodel.AppData;
import org.apache.fulcrum.intake.xmlmodel.XmlField;
import org.apache.fulcrum.intake.xmlmodel.XmlGroup;
import org.apache.fulcrum.util.parser.ValueParser;
import org.apache.log4j.Category;

public class Group {
    public static final String EMPTY = "";
    public static final String NEW = "_0";
    private static final Category log;
    private static final boolean isDebugEnabled;
    protected final String gid;
    protected final String name;
    private final int poolCapacity;
    protected Map fields;
    protected Map mapToObjectFields;
    protected Field[] fieldsArray;
    protected String oid;
    protected ValueParser pp;
    protected boolean isDeclared;
    static /* synthetic */ Class class$org$apache$fulcrum$intake$model$Group;

    public Group(XmlGroup group) throws Exception {
        ArrayList<Field> tmpFields;
        this.gid = group.getKey();
        this.name = group.getName();
        this.poolCapacity = Integer.parseInt(group.getPoolCapacity());
        List inputFields = group.getFields();
        int size = inputFields.size();
        this.fields = new HashMap((int)(1.25 * (double)size + 1.0));
        this.mapToObjectFields = new HashMap((int)(1.25 * (double)size + 1.0));
        this.fieldsArray = new Field[size];
        int i = size - 1;
        while (i >= 0) {
            Field field;
            XmlField f = (XmlField)inputFields.get(i);
            this.fieldsArray[i] = field = FieldFactory.getInstance(f, this);
            this.fields.put(f.getName(), field);
            tmpFields = (List)this.mapToObjectFields.get(f.getMapToObject());
            if (tmpFields == null) {
                tmpFields = new ArrayList<Field>(size);
                this.mapToObjectFields.put(f.getMapToObject(), tmpFields);
            }
            tmpFields.add(field);
            --i;
        }
        Iterator keys = this.mapToObjectFields.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            tmpFields = (ArrayList<Field>)this.mapToObjectFields.get(key);
            this.mapToObjectFields.put(key, tmpFields.toArray(new Field[tmpFields.size()]));
        }
    }

    public Group init(ValueParser pp) throws ServiceException {
        return this.init(NEW, pp);
    }

    public Group init(String key, ValueParser pp) throws ServiceException {
        this.oid = key;
        this.pp = pp;
        int i = this.fieldsArray.length - 1;
        while (i >= 0) {
            this.fieldsArray[i].init(pp);
            --i;
        }
        return this;
    }

    public Group init(Retrievable obj) {
        this.oid = obj.getQueryKey();
        Class<?> cls = obj.getClass();
        while (cls != null) {
            Field[] flds = (Field[])this.mapToObjectFields.get(cls.getName());
            if (flds != null) {
                int i = flds.length - 1;
                while (i >= 0) {
                    flds[i].init(obj);
                    --i;
                }
            }
            cls = cls.getSuperclass();
        }
        return this;
    }

    public String[] getFieldNames() {
        String[] nameList = new String[this.fieldsArray.length];
        int i = 0;
        while (i < nameList.length) {
            nameList[i] = this.fieldsArray[i].name;
            ++i;
        }
        return nameList;
    }

    public String getIntakeGroupName() {
        return this.name;
    }

    public int getPoolCapacity() {
        return this.poolCapacity;
    }

    public String getGID() {
        return this.gid;
    }

    public String getOID() {
        return this.oid;
    }

    public String getObjectKey() {
        return this.gid + this.oid;
    }

    public ArrayList getObjects(ValueParser pp) throws ServiceException {
        ArrayList<Group> objs = null;
        String[] oids = pp.getStrings(this.gid);
        if (oids != null) {
            objs = new ArrayList<Group>(oids.length);
            int i = oids.length - 1;
            while (i >= 0) {
                objs.add(TurbineIntake.getGroup(this.name).init(oids[i], pp));
                --i;
            }
        }
        return objs;
    }

    public Field get(String fieldName) throws ServiceException {
        if (this.fields.containsKey(fieldName)) {
            return (Field)this.fields.get(fieldName);
        }
        throw new ServiceException("Intake Field name: " + fieldName + " not found!");
    }

    public boolean isAllValid() {
        boolean valid = true;
        int i = this.fieldsArray.length - 1;
        while (i >= 0) {
            valid &= this.fieldsArray[i].isValid();
            if (isDebugEnabled && !this.fieldsArray[i].isValid()) {
                log.debug((Object)("[Intake] Group(" + this.oid + "): " + this.name + "; Field: " + this.fieldsArray[i].name + "; value=" + this.fieldsArray[i].getValue() + " is invalid!"));
            }
            --i;
        }
        return valid;
    }

    public void setProperties(Object obj) throws ServiceException {
        Class<?> cls = obj.getClass();
        while (cls != null) {
            Field[] flds = (Field[])this.mapToObjectFields.get(cls.getName());
            if (flds != null) {
                int i = flds.length - 1;
                while (i >= 0) {
                    flds[i].setProperty(obj);
                    --i;
                }
            }
            cls = cls.getSuperclass();
        }
    }

    public void setValidProperties(Object obj) {
        Class<?> cls = obj.getClass();
        while (cls != null) {
            Field[] flds = (Field[])this.mapToObjectFields.get(cls.getName());
            if (flds != null) {
                int i = flds.length - 1;
                while (i >= 0) {
                    try {
                        flds[i].setProperty(obj);
                    }
                    catch (ServiceException e) {
                        // empty catch block
                    }
                    --i;
                }
            }
            cls = cls.getSuperclass();
        }
    }

    public void getProperties(Object obj) throws Exception {
        Class<?> cls = obj.getClass();
        while (cls != null) {
            Field[] flds = (Field[])this.mapToObjectFields.get(cls.getName());
            if (flds != null) {
                int i = flds.length - 1;
                while (i >= 0) {
                    flds[i].getProperty(obj);
                    --i;
                }
            }
            cls = cls.getSuperclass();
        }
    }

    public void removeFromRequest() {
        String[] groups;
        if (this.pp != null && (groups = this.pp.getStrings(this.gid)) != null) {
            this.pp.remove(this.gid);
            int i = 0;
            while (i < groups.length) {
                if (groups[i] != null && !groups[i].equals(this.oid)) {
                    this.pp.add(this.gid, groups[i]);
                }
                ++i;
            }
            int i2 = this.fieldsArray.length - 1;
            while (i2 >= 0) {
                this.fieldsArray[i2].removeFromRequest();
                --i2;
            }
        }
    }

    public void resetDeclared() {
        this.isDeclared = false;
    }

    public String getHtmlFormInput() {
        StringBuffer sb = new StringBuffer(64);
        this.appendHtmlFormInput(sb);
        return sb.toString();
    }

    public void appendHtmlFormInput(StringBuffer sb) {
        if (!this.isDeclared) {
            this.isDeclared = true;
            sb.append("<input type=\"hidden\" name=\"").append(this.gid).append("\" value=\"").append(this.oid).append("\"/>\n");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        EMPTY = EMPTY;
        NEW = NEW;
        log = Category.getInstance((String)(class$org$apache$fulcrum$intake$model$Group == null ? (class$org$apache$fulcrum$intake$model$Group = Group.class$("org.apache.fulcrum.intake.model.Group")) : class$org$apache$fulcrum$intake$model$Group).getName());
        isDebugEnabled = log.isDebugEnabled();
    }

    public static class GroupFactory
    extends BaseKeyedPoolableObjectFactory {
        private AppData appData;

        public GroupFactory(AppData appData) {
            this.appData = appData;
        }

        public Object makeObject(Object key) throws Exception {
            return new Group(this.appData.getGroup((String)key));
        }

        public void passivateObject(Object key, Object obj) throws Exception {
            Group group = (Group)obj;
            group.oid = null;
            group.pp = null;
            int i = group.fieldsArray.length - 1;
            while (i >= 0) {
                group.fieldsArray[i].dispose();
                --i;
            }
            group.isDeclared = false;
        }
    }
}

