/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.xmlmodel.XmlField;
import org.apache.log4j.Category;

public class FloatField
extends Field {
    Category category = Category.getInstance((String)this.getClass().getName());

    public FloatField(XmlField field, Group group) throws Exception {
        super(field, group);
    }

    protected void setDefaultValue(String prop) {
        this.defaultValue = null;
        if (prop == null) {
            return;
        }
        try {
            this.defaultValue = new Float(prop);
        }
        catch (Exception e) {
            this.category.error((Object)("Could not convert " + prop + " into an Float. (" + this.name + ")"));
        }
    }

    protected String getDefaultValidator() {
        return "org.apache.fulcrum.intake.validator.NumberValidator";
    }

    protected void doSetValue() {
        if (this.isMultiValued) {
            String[] ss = this.pp.getStrings(this.getKey());
            float[] ival = new float[ss.length];
            int i = 0;
            while (i < ss.length) {
                if (ss[i] != null && ss[i].length() > 0) {
                    ival[i] = Float.parseFloat(ss[i]);
                }
                ++i;
            }
            this.setTestValue(ival);
        } else {
            String s = this.pp.getString(this.getKey());
            if (s != null && s.length() > 0) {
                this.setTestValue(new Float(s));
            } else {
                this.set_flag = false;
            }
        }
    }
}

