/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import org.apache.commons.fileupload.FileItem;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.validator.FileValidator;
import org.apache.fulcrum.intake.validator.ValidationException;
import org.apache.fulcrum.intake.xmlmodel.XmlField;
import org.apache.fulcrum.util.parser.ParameterParser;
import org.apache.fulcrum.util.parser.ValueParser;

public class FileItemField
extends Field {
    public FileItemField(XmlField field, Group group) throws Exception {
        super(field, group);
    }

    protected void setDefaultValue(String prop) {
        this.defaultValue = prop;
    }

    protected String getDefaultValidator() {
        return "org.apache.fulcrum.intake.validator.FileValidator";
    }

    public Field init(ValueParser vp) throws ServiceException {
        try {
            this.pp = (ParameterParser)vp;
        }
        catch (ClassCastException e) {
            throw new ServiceException("FileItemFields can only be used with ParameterParser");
        }
        this.valid_flag = true;
        if (this.pp.containsKey(this.getKey())) {
            this.set_flag = true;
            this.validate(this.pp);
        }
        this.initialized = true;
        return this;
    }

    protected boolean validate() {
        ParameterParser pp = (ParameterParser)this.pp;
        if (this.isMultiValued) {
            FileItem[] ss = pp.getFileItems(this.getKey());
            if (ss.length == 0) {
                this.set_flag = false;
            }
            if (this.validator != null) {
                int i = 0;
                while (i < ss.length) {
                    try {
                        ((FileValidator)this.validator).assertValidity(ss[i]);
                    }
                    catch (ValidationException ve) {
                        this.setMessage(ve.getMessage());
                    }
                    ++i;
                }
            }
            if (this.set_flag && this.valid_flag) {
                this.doSetValue(pp);
            }
        } else {
            FileItem s = pp.getFileItem(this.getKey());
            if (s == null || s.getSize() == 0L) {
                this.set_flag = false;
            }
            if (this.validator != null) {
                try {
                    ((FileValidator)this.validator).assertValidity(s);
                    if (this.set_flag) {
                        this.doSetValue(pp);
                    }
                }
                catch (ValidationException ve) {
                    this.setMessage(ve.getMessage());
                }
            } else if (this.set_flag) {
                this.doSetValue(pp);
            }
        }
        return this.valid_flag;
    }

    protected void doSetValue() {
        ParameterParser pp = (ParameterParser)this.pp;
        if (this.isMultiValued) {
            this.setTestValue(pp.getFileItems(this.getKey()));
        } else {
            this.setTestValue(pp.getFileItem(this.getKey()));
        }
    }
}

