/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.StackKeyedObjectPool;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.intake.IntakeService;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.transform.XmlToAppData;
import org.apache.fulcrum.intake.xmlmodel.AppData;
import org.apache.fulcrum.intake.xmlmodel.XmlGroup;

public class TurbineIntakeService
extends BaseService
implements IntakeService {
    private String[] groupNames;
    private Map groupNameMap;
    private Map groupKeyMap;
    private Map getterMap;
    private Map setterMap;
    private AppData appData;
    KeyedObjectPool keyedPool;
    private static final int GETTER = 0;
    private static final int SETTER = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws InitializationException {
        String xmlPath = this.getConfiguration().getString("xml.path", "WEB-INF/conf/intake.xml");
        String appDataPath = this.getConfiguration().getString("serialize.path", "WEB-INF/appData.ser");
        String SERIALIZED_ERROR_MSG = "Intake initialization could not be serialized because writing to " + appDataPath + " was not " + "allowed.  This will require that the xml file be " + "parsed when restarting the application.";
        if (xmlPath == null) {
            String pathError = "Path to intake.xml was not specified.  Check that the property exists in TR.props and was loaded.";
            this.getCategory().error((Object)pathError);
            throw new InitializationException(pathError);
        }
        File serialAppData = null;
        File xmlFile = null;
        xmlFile = new File(xmlPath);
        if (!xmlFile.canRead() && !(xmlFile = new File(xmlPath = this.getRealPath(xmlPath))).canRead()) {
            String pathError = "Could not read input file.  Even tried relative to webapp root.";
            this.getCategory().error((Object)pathError);
            throw new InitializationException(pathError);
        }
        serialAppData = new File(appDataPath);
        try {
            serialAppData.createNewFile();
            serialAppData.delete();
        }
        catch (Exception e) {
            appDataPath = this.getRealPath(appDataPath);
            serialAppData = new File(appDataPath);
            try {
                serialAppData.createNewFile();
                serialAppData.delete();
            }
            catch (Exception ee) {
                this.getCategory().info((Object)SERIALIZED_ERROR_MSG);
            }
        }
        try {
            block19: {
                if (serialAppData.exists() && serialAppData.lastModified() > xmlFile.lastModified()) {
                    FileInputStream in = null;
                    try {
                        Object var9_15;
                        try {
                            in = new FileInputStream(serialAppData);
                            ObjectInputStream p = new ObjectInputStream(in);
                            this.appData = (AppData)p.readObject();
                        }
                        catch (Exception e) {
                            this.writeAppData(xmlPath, appDataPath, serialAppData);
                            var9_15 = null;
                            if (in != null) {
                                ((InputStream)in).close();
                            }
                            break block19;
                        }
                        var9_15 = null;
                        if (in == null) break block19;
                    }
                    catch (Throwable throwable) {
                        Object var9_16 = null;
                        if (in == null) throw throwable;
                        ((InputStream)in).close();
                        throw throwable;
                    }
                    ((InputStream)in).close();
                } else {
                    this.writeAppData(xmlPath, appDataPath, serialAppData);
                }
            }
            this.groupNames = new String[this.appData.getGroups().size()];
            this.groupKeyMap = new HashMap();
            this.groupNameMap = new HashMap();
            this.getterMap = new HashMap();
            this.setterMap = new HashMap();
            String pkg = this.appData.getBasePackage();
            int maxPooledGroups = 0;
            List glist = this.appData.getGroups();
            int i = glist.size() - 1;
            block10: while (true) {
                String groupName;
                if (i < 0) {
                    Group.GroupFactory factory = new Group.GroupFactory(this.appData);
                    this.keyedPool = new StackKeyedObjectPool((KeyedPoolableObjectFactory)factory, maxPooledGroups);
                    this.setInit(true);
                    return;
                }
                XmlGroup g = (XmlGroup)glist.get(i);
                this.groupNames[i] = groupName = g.getName();
                this.groupKeyMap.put(groupName, g.getKey());
                this.groupNameMap.put(g.getKey(), groupName);
                maxPooledGroups = Math.max(maxPooledGroups, Integer.parseInt(g.getPoolCapacity()));
                List classNames = g.getMapToObjects();
                Iterator iter2 = classNames.iterator();
                while (true) {
                    if (!iter2.hasNext()) {
                        --i;
                        continue block10;
                    }
                    String className = (String)iter2.next();
                    if (this.getterMap.containsKey(className)) continue;
                    this.getterMap.put(className, new HashMap());
                    this.setterMap.put(className, new HashMap());
                }
                break;
            }
        }
        catch (Exception e) {
            throw new InitializationException("TurbineIntakeService failed to initialize", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeAppData(String xmlPath, String appDataPath, File serialAppData) throws Exception {
        InputStream in;
        block7: {
            XmlToAppData xmlApp = new XmlToAppData();
            this.appData = xmlApp.parseFile(xmlPath);
            FileOutputStream out = null;
            in = null;
            try {
                try {
                    out = new FileOutputStream(serialAppData);
                    ObjectOutputStream p = new ObjectOutputStream(out);
                    p.writeObject(this.appData);
                    p.flush();
                    in = new FileInputStream(serialAppData);
                    ObjectInputStream pin = new ObjectInputStream(in);
                    this.appData = (AppData)pin.readObject();
                }
                catch (Exception e) {
                    this.getCategory().info((Object)("Intake initialization could not be serialized because writing to " + appDataPath + " was not " + "allowed.  This will require that the xml file be " + "parsed when restarting the application."));
                    Object var10_11 = null;
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                    if (in == null) return;
                    in.close();
                    return;
                }
                Object var10_10 = null;
                if (out == null) break block7;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (out != null) {
                    ((OutputStream)out).close();
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            ((OutputStream)out).close();
        }
        if (in == null) return;
        in.close();
    }

    public Group getGroup(String groupName) throws ServiceException {
        Group group = null;
        if (groupName == null) {
            throw new ServiceException("Intake TurbineIntakeService.getGroup(groupName) is null");
        }
        try {
            group = (Group)this.keyedPool.borrowObject((Object)groupName);
        }
        catch (Exception e) {
            new ServiceException(e);
        }
        return group;
    }

    public void releaseGroup(Group instance) {
        if (instance != null) {
            String name = instance.getIntakeGroupName();
            try {
                this.keyedPool.returnObject((Object)name, (Object)instance);
            }
            catch (Exception e) {
                new ServiceException(e);
            }
        }
    }

    public int getSize(String name) {
        return this.keyedPool.getNumActive((Object)name) + this.keyedPool.getNumIdle((Object)name);
    }

    public String[] getGroupNames() {
        return this.groupNames;
    }

    public String getGroupKey(String groupName) {
        return (String)this.groupKeyMap.get(groupName);
    }

    public String getGroupName(String groupKey) {
        return (String)this.groupNameMap.get(groupKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getFieldSetter(String className, String propName) {
        Map settersForClassName = (Map)this.setterMap.get(className);
        Method setter = (Method)settersForClassName.get(propName);
        if (setter == null) {
            PropertyDescriptor pd = null;
            Map map = this.setterMap;
            synchronized (map) {
                try {
                    pd = new PropertyDescriptor(propName, Class.forName(className));
                    setter = pd.getWriteMethod();
                    ((Map)this.setterMap.get(className)).put(propName, setter);
                    if (setter == null) {
                        this.getCategory().error((Object)("Intake: setter for '" + propName + "' in class '" + className + "' could not be found."));
                    }
                }
                catch (Exception e) {
                    this.getCategory().error((Object)e);
                }
            }
            Map map2 = this.getterMap;
            synchronized (map2) {
                try {
                    Method getter = pd.getReadMethod();
                    ((Map)this.getterMap.get(className)).put(propName, getter);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return setter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getFieldGetter(String className, String propName) {
        Map gettersForClassName = (Map)this.getterMap.get(className);
        Method getter = (Method)gettersForClassName.get(propName);
        if (getter == null) {
            PropertyDescriptor pd = null;
            Map map = this.getterMap;
            synchronized (map) {
                try {
                    pd = new PropertyDescriptor(propName, Class.forName(className));
                    getter = pd.getReadMethod();
                    ((Map)this.getterMap.get(className)).put(propName, getter);
                    if (getter == null) {
                        this.getCategory().error((Object)("Intake: getter for '" + propName + "' in class '" + className + "' could not be found."));
                    }
                }
                catch (Exception e) {
                    this.getCategory().error((Object)e);
                }
            }
            Map map2 = this.setterMap;
            synchronized (map2) {
                try {
                    Method setter = pd.getWriteMethod();
                    ((Map)this.setterMap.get(className)).put(propName, setter);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return getter;
    }

    static {
        GETTER = 0;
        SETTER = 1;
    }
}

