/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.factory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.factory.Factory;
import org.apache.fulcrum.factory.FactoryService;
import org.apache.fulcrum.pool.ObjectInputStreamForContext;

public class TurbineFactoryService
extends BaseService
implements FactoryService {
    public static final String CLASS_LOADERS = "class.loaders";
    public static final String OBJECT_FACTORY = "factory.";
    protected static final String DEFAULT_FACTORY = "default";
    private static HashMap primitiveClasses;
    private ArrayList classLoaders;
    private HashMap objectFactories;

    protected static Class getPrimitiveClass(String type) {
        return (Class)primitiveClasses.get(type);
    }

    public TurbineFactoryService() {
        primitiveClasses = new HashMap(8);
        primitiveClasses.put(Boolean.TYPE.toString(), Boolean.TYPE);
        primitiveClasses.put(Character.TYPE.toString(), Character.TYPE);
        primitiveClasses.put(Byte.TYPE.toString(), Byte.TYPE);
        primitiveClasses.put(Short.TYPE.toString(), Short.TYPE);
        primitiveClasses.put(Integer.TYPE.toString(), Integer.TYPE);
        primitiveClasses.put(Long.TYPE.toString(), Long.TYPE);
        primitiveClasses.put(Float.TYPE.toString(), Float.TYPE);
        primitiveClasses.put(Double.TYPE.toString(), Double.TYPE);
        this.classLoaders = new ArrayList();
        this.objectFactories = new HashMap();
    }

    public void init() throws InitializationException {
        if (this.getConfiguration() != null) {
            Vector loaders = this.getConfiguration().getVector(CLASS_LOADERS);
            if (loaders != null) {
                int i = 0;
                while (i < loaders.size()) {
                    try {
                        this.classLoaders.add(this.loadClass((String)loaders.get(i)).newInstance());
                    }
                    catch (Exception x) {
                        throw new InitializationException("No such class loader '" + (String)loaders.get(i) + "' for TurbinbeFactoryService", x);
                    }
                    ++i;
                }
            }
            Iterator i = this.getConfiguration().getKeys(OBJECT_FACTORY);
            while (i.hasNext()) {
                String key = (String)i.next();
                String factory = this.getConfiguration().getString(key);
                this.objectFactories.put(key.substring(OBJECT_FACTORY.length()), factory);
            }
        }
        this.setInit(true);
    }

    public Object getInstance(String className) throws ServiceException {
        if (className == null) {
            throw new ServiceException(new NullPointerException("String className"));
        }
        Factory factory = this.getFactory(className);
        if (factory == null) {
            Class clazz;
            try {
                clazz = this.loadClass(className);
            }
            catch (ClassNotFoundException x) {
                throw new ServiceException("Instantiation failed for class " + className, x);
            }
            return this.getInstance(clazz);
        }
        return factory.getInstance();
    }

    public Object getInstance(String className, ClassLoader loader) throws ServiceException {
        if (className == null) {
            throw new ServiceException(new NullPointerException("String className"));
        }
        Factory factory = this.getFactory(className);
        if (factory == null) {
            if (loader != null) {
                Class clazz;
                try {
                    clazz = this.loadClass(className, loader);
                }
                catch (ClassNotFoundException x) {
                    throw new ServiceException("Instantiation failed for class " + className, x);
                }
                return this.getInstance(clazz);
            }
            return this.getInstance(className);
        }
        return factory.getInstance(loader);
    }

    public Object getInstance(String className, Object[] params, String[] signature) throws ServiceException {
        if (className == null) {
            throw new ServiceException(new NullPointerException("String className"));
        }
        Factory factory = this.getFactory(className);
        if (factory == null) {
            Class clazz;
            try {
                clazz = this.loadClass(className);
            }
            catch (ClassNotFoundException x) {
                throw new ServiceException("Instantiation failed for class " + className, x);
            }
            return this.getInstance(clazz, params, signature);
        }
        return factory.getInstance(params, signature);
    }

    public Object getInstance(String className, ClassLoader loader, Object[] params, String[] signature) throws ServiceException {
        if (className == null) {
            throw new ServiceException(new NullPointerException("String className"));
        }
        Factory factory = this.getFactory(className);
        if (factory == null) {
            if (loader != null) {
                Class clazz;
                try {
                    clazz = this.loadClass(className, loader);
                }
                catch (ClassNotFoundException x) {
                    throw new ServiceException("Instantiation failed for class " + className, x);
                }
                return this.getInstance(clazz, params, signature);
            }
            return this.getInstance(className, params, signature);
        }
        return factory.getInstance(loader, params, signature);
    }

    public boolean isLoaderSupported(String className) throws ServiceException {
        Factory factory = this.getFactory(className);
        return factory != null ? factory.isLoaderSupported() : true;
    }

    protected Object getInstance(Class clazz) throws ServiceException {
        try {
            return clazz.newInstance();
        }
        catch (Exception x) {
            throw new ServiceException("Instantiation failed for " + clazz.getName(), x);
        }
    }

    protected Object getInstance(Class clazz, Object[] params, String[] signature) throws ServiceException {
        try {
            Class[] sign = this.getSignature(clazz, params, signature);
            return clazz.getConstructor(sign).newInstance(params);
        }
        catch (Exception x) {
            throw new ServiceException("Instantiation failed for " + clazz.getName(), x);
        }
    }

    protected Class[] getSignature(Class clazz, Object[] params, String[] signature) throws ClassNotFoundException {
        if (signature != null) {
            ClassLoader loader = clazz.getClassLoader();
            Class[] sign = new Class[signature.length];
            int i = 0;
            while (i < signature.length) {
                sign[i] = TurbineFactoryService.getPrimitiveClass(signature[i]);
                if (sign[i] == null) {
                    if (loader != null) {
                        sign[i] = loader.loadClass(signature[i]);
                        ClassLoader tempLoader = sign[i].getClassLoader();
                        if (params[i] != null && tempLoader != null && !tempLoader.equals(params[i].getClass().getClassLoader())) {
                            params[i] = this.switchObjectContext(params[i], loader);
                        }
                    } else {
                        sign[i] = this.loadClass(signature[i]);
                    }
                }
                ++i;
            }
            return sign;
        }
        return null;
    }

    protected Object switchObjectContext(Object object, ClassLoader loader) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bout);
            out.writeObject(object);
            out.flush();
        }
        catch (Exception x) {
            return object;
        }
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
            ObjectInputStreamForContext in = new ObjectInputStreamForContext(bin, loader);
            return in.readObject();
        }
        catch (Exception x) {
            return object;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected Class loadClass(String className) throws ClassNotFoundException {
        loader = this.getClass().getClassLoader();
        try {
            return loader != null ? loader.loadClass(className) : Class.forName(className);
        }
        catch (ClassNotFoundException x) {
            i = this.classLoaders.iterator();
            ** while (i.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            try {
                return ((ClassLoader)i.next()).loadClass(className);
            }
            catch (ClassNotFoundException xx) {
                // empty catch block
            }
            continue;
        }
lbl12:
        // 1 sources

        throw x;
    }

    protected Class loadClass(String className, ClassLoader loader) throws ClassNotFoundException {
        return loader != null ? loader.loadClass(className) : this.loadClass(className);
    }

    protected Factory getFactory(String className) throws ServiceException {
        HashMap factories = this.objectFactories;
        Object factory = factories.get(className);
        if (factory == null) {
            factory = factories.get(DEFAULT_FACTORY);
        }
        if (factory != null) {
            if (factory instanceof String) {
                try {
                    factory = (Factory)this.getInstance((String)factory);
                    ((Factory)factory).init(className);
                }
                catch (ServiceException x) {
                    throw x;
                }
                catch (ClassCastException x) {
                    throw new ServiceException("Incorrect factory " + (String)factory + " for class " + className, x);
                }
                factories = (HashMap)factories.clone();
                factories.put(className, factory);
                this.objectFactories = factories;
            }
            return (Factory)factory;
        }
        return null;
    }

    static {
        CLASS_LOADERS = CLASS_LOADERS;
        OBJECT_FACTORY = OBJECT_FACTORY;
        DEFAULT_FACTORY = DEFAULT_FACTORY;
    }
}

