/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

class LineFormatter {
    String comment = null;
    int maxLength = 65;
    int offset = 0;
    int length = 0;
    String prefix = null;
    private StringBuffer sb = null;

    LineFormatter(String string) {
        this.comment = string;
        if (string != null) {
            this.length = string.length();
        }
        this.sb = new StringBuffer();
    }

    LineFormatter(String string, int n) {
        this(string, n, null);
    }

    LineFormatter(String string, int n, String string2) {
        this(string);
        this.maxLength = n;
        this.prefix = string2;
    }

    boolean hasMoreLines() {
        if (this.comment == null) {
            return false;
        }
        return this.offset < this.length;
    }

    private boolean isBreakable(char c) {
        return this.isWhitespace(c) || this.isNewLine(c);
    }

    private boolean isNewLine(char c) {
        return c == '\n' || c == '\r';
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    String nextLine() {
        int n;
        if (this.comment == null) {
            return null;
        }
        if (this.offset >= this.length) {
            return null;
        }
        this.sb.setLength(0);
        if (this.prefix != null) {
            this.sb.append(this.prefix);
        }
        if ((n = this.offset + this.maxLength) > this.length) {
            n = this.length;
        }
        int n2 = this.offset;
        int n3 = this.offset;
        while (n2 < n) {
            char c = this.comment.charAt(n2);
            if (this.isNewLine(c)) {
                this.sb.append(this.comment.substring(this.offset, n2));
                this.offset = n2 + 1;
                return this.sb.toString();
            }
            if (this.isWhitespace(c)) {
                n3 = n2;
            }
            ++n2;
        }
        if (n2 < this.length - 1) {
            if (this.offset == n3) {
                while (n2 < this.length) {
                    if (!this.isBreakable(this.comment.charAt(n2))) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            } else {
                n2 = n3;
            }
        }
        this.sb.append(this.comment.substring(this.offset, n2));
        this.offset = n2 + 1;
        return this.sb.toString();
    }

    void setPrefix(String string) {
        this.prefix = string;
    }
}

