/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dtx;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.exolab.castor.dtx.DTXClassDescriptor;
import org.exolab.castor.dtx.DTXEngine;
import org.exolab.castor.dtx.DTXException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.mapping.xml.BindXml;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.MapTo;
import org.exolab.castor.mapping.xml.Sql;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.QueryExpression;
import org.xml.sax.DocumentHandler;
import org.xml.sax.helpers.AttributeListImpl;

public class DTXQuery {
    protected DTXEngine _eng = null;
    protected DocumentHandler _handler = null;
    protected PrintWriter _logWriter = null;
    protected PreparedStatement _stmt = null;
    protected String _objName = null;
    protected String _objType = null;
    protected ClassMapping _clsMapping = null;
    protected ArrayList _ids = null;
    protected int _lastCol = 0;
    protected HashMap _cols = null;
    protected HashMap _classes = null;

    DTXQuery() {
    }

    private void addField(ClassMapping classMapping, StringTokenizer stringTokenizer, QueryExpression queryExpression) throws DTXException {
        if (!stringTokenizer.hasMoreTokens()) {
            throw new DTXException("Missing field name");
        }
        String string = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            throw new DTXException("Missing operator");
        }
        String string2 = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            throw new DTXException("Missing field value");
        }
        String string3 = stringTokenizer.nextToken();
        if (string.indexOf(".") > 0) {
            string = string.substring(string.indexOf(".") + 1);
        }
        FieldMapping[] fieldMappingArray = classMapping.getFieldMapping();
        FieldMapping fieldMapping = null;
        int n = 0;
        while (n < fieldMappingArray.length) {
            if (fieldMappingArray[n].getSql() != null && fieldMappingArray[n].getName().equals(string)) {
                fieldMapping = fieldMappingArray[n];
                break;
            }
            ++n;
        }
        if (fieldMapping == null) {
            throw new DTXException("The field " + string + " was not found");
        }
        Sql sql = fieldMapping.getSql();
        String string4 = classMapping.getMapTo().getTable();
        if (string3.startsWith("$")) {
            queryExpression.addParameter(string4, sql.getName()[0], string2);
        } else {
            queryExpression.addCondition(string4, sql.getName()[0], string2, string3);
        }
    }

    public void bind(int n, double d) throws DTXException {
        if (this._stmt == null) {
            throw new DTXException("No prepared statement.");
        }
        try {
            this._stmt.setDouble(n, d);
        }
        catch (SQLException sQLException) {
            throw new DTXException(sQLException);
        }
    }

    public void bind(int n, float f) throws DTXException {
        if (this._stmt == null) {
            throw new DTXException("No prepared statement.");
        }
        try {
            this._stmt.setFloat(n, f);
        }
        catch (SQLException sQLException) {
            throw new DTXException(sQLException);
        }
    }

    public void bind(int n, int n2) throws DTXException {
        if (this._stmt == null) {
            throw new DTXException("No prepared statement.");
        }
        try {
            this._stmt.setInt(n, n2);
        }
        catch (SQLException sQLException) {
            throw new DTXException(sQLException);
        }
    }

    public void bind(int n, long l) throws DTXException {
        if (this._stmt == null) {
            throw new DTXException("No prepared statement.");
        }
        try {
            this._stmt.setLong(n, l);
        }
        catch (SQLException sQLException) {
            throw new DTXException(sQLException);
        }
    }

    public void bind(int n, Object object) throws DTXException {
        if (this._stmt == null) {
            throw new DTXException("No prepared statement.");
        }
        try {
            this._stmt.setObject(n, object);
        }
        catch (SQLException sQLException) {
            throw new DTXException(sQLException);
        }
    }

    public void bind(int n, String string) throws DTXException {
        if (this._stmt == null) {
            throw new DTXException("No prepared statement.");
        }
        try {
            this._stmt.setString(n, string);
        }
        catch (SQLException sQLException) {
            throw new DTXException(sQLException);
        }
    }

    public void bind(int n, boolean bl) throws DTXException {
        if (this._stmt == null) {
            throw new DTXException("No prepared statement.");
        }
        try {
            this._stmt.setBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            throw new DTXException(sQLException);
        }
    }

    protected void emitSaxEvents(ResultSet resultSet) throws DTXException {
        try {
            if (resultSet.next()) {
                this.emitSaxInt(resultSet, 0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(this._logWriter);
            throw new DTXException(exception);
        }
    }

    protected boolean emitSaxInt(ResultSet resultSet, int n) throws DTXException {
        boolean bl = true;
        try {
            Integer n2;
            String string;
            String string2 = null;
            String string3 = null;
            int n3 = 0;
            if (n != 0) {
                string = (String)this._ids.get(n - 1);
                n2 = (Integer)this._cols.get(string);
                n3 = n2;
                string3 = string2 = resultSet.getString(n3);
            }
            string = (String)this._ids.get(n);
            n2 = (Integer)this._cols.get(string);
            DTXClassDescriptor dTXClassDescriptor = (DTXClassDescriptor)this._classes.get(string);
            ClassMapping classMapping = dTXClassDescriptor.getClassMapping();
            String string4 = null;
            string4 = classMapping.getMapTo() == null || classMapping.getMapTo().getXml() == null ? classMapping.getName() : classMapping.getMapTo().getXml();
            String[] stringArray = dTXClassDescriptor.getAttrCols();
            String[] stringArray2 = dTXClassDescriptor.getSimpleElementCols();
            String string5 = dTXClassDescriptor.getTextCol();
            while (bl && (n == 0 || string3.equalsIgnoreCase(string2))) {
                String string6;
                Object object;
                Object object2;
                Object object3;
                if (n == 0) {
                    this._handler.startDocument();
                }
                String string7 = resultSet.getString(n2);
                AttributeListImpl attributeListImpl = new AttributeListImpl();
                int n4 = 0;
                while (n4 < stringArray.length) {
                    String string8 = stringArray[n4];
                    object3 = (Integer)this._cols.get(string8);
                    object2 = dTXClassDescriptor.getAttr(string8);
                    object = null;
                    object = ((FieldMapping)object2).getBindXml() == null || ((FieldMapping)object2).getBindXml().getName() == null ? ((FieldMapping)object2).getName() : ((FieldMapping)object2).getBindXml().getName();
                    string6 = resultSet.getString((Integer)object3);
                    attributeListImpl.addAttribute((String)object, "CDATA", string6);
                    ++n4;
                }
                this._handler.startElement(string4, attributeListImpl);
                int n5 = 0;
                while (n5 < stringArray2.length) {
                    object3 = stringArray2[n5];
                    object2 = (Integer)this._cols.get(object3);
                    object = dTXClassDescriptor.getSimpleElement((String)object3);
                    string6 = null;
                    string6 = ((FieldMapping)object).getBindXml() == null || ((FieldMapping)object).getBindXml().getName() == null ? ((FieldMapping)object).getName() : ((FieldMapping)object).getBindXml().getName();
                    String string9 = resultSet.getString((Integer)object2);
                    this._handler.startElement(string6, new AttributeListImpl());
                    this._handler.characters(string9.toCharArray(), 0, string9.length());
                    this._handler.endElement(string6);
                    ++n5;
                }
                if (n < this._ids.size() - 1) {
                    bl = this.emitSaxInt(resultSet, n + 1);
                }
                if (string5 != null) {
                    object3 = (Integer)this._cols.get(string5);
                    object2 = resultSet.getString((Integer)object3);
                    this._handler.characters(((String)object2).toCharArray(), 0, ((String)object2).length());
                }
                this._handler.endElement(string4);
                if (n == 0) {
                    this._handler.endDocument();
                }
                if (((String)(object3 = resultSet.getString(n2))).equalsIgnoreCase(string7)) {
                    bl = resultSet.next();
                }
                if (!bl || n == 0) continue;
                string3 = resultSet.getString(n3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(this._logWriter);
            throw new DTXException(exception);
        }
        return bl;
    }

    public void execute() throws DTXException {
        if (this._stmt == null) {
            throw new DTXException("No prepared statement.");
        }
        try {
            ResultSet resultSet = this._stmt.executeQuery();
            this.emitSaxEvents(resultSet);
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new DTXException(sQLException);
        }
    }

    protected void initQuery(ClassMapping classMapping, QueryExpression queryExpression) throws DTXException {
        Object object;
        MapTo mapTo = classMapping.getMapTo();
        if (mapTo == null) {
            throw new DTXException("no table mapping for: " + classMapping.getName());
        }
        String string = mapTo.getTable();
        FieldMapping[] fieldMappingArray = classMapping.getFieldMapping();
        FieldMapping fieldMapping = null;
        String string2 = classMapping.getIdentity(0);
        int n = 0;
        while (n < fieldMappingArray.length) {
            if (fieldMappingArray[n].getName().equals(string2)) {
                fieldMapping = fieldMappingArray[n];
                break;
            }
            ++n;
        }
        if (fieldMapping == null) {
            throw new DTXException("no identity field in class: " + classMapping.getName());
        }
        Sql sql = fieldMapping.getSql();
        if (sql == null) {
            throw new DTXException("no identity SQL info in class: " + classMapping.getName());
        }
        String string3 = sql.getName()[0];
        this._ids.add(String.valueOf(string) + "." + string3);
        DTXClassDescriptor dTXClassDescriptor = new DTXClassDescriptor(classMapping);
        this._classes.put(String.valueOf(string) + "." + string3, dTXClassDescriptor);
        if (classMapping.getExtends() != null) {
            MapTo mapTo2 = new MapTo();
            if (mapTo2 == null) {
                throw new DTXException("no mapping info for extends table.");
            }
            object = mapTo2.getTable();
            queryExpression.addInnerJoin(string, string3, (String)object, string3);
            this.initQuery(new ClassMapping(), queryExpression);
        }
        int n2 = 0;
        while (n2 < fieldMappingArray.length) {
            String string4;
            Object object2;
            Object object3;
            Object object4;
            object = fieldMappingArray[n2];
            Sql sql2 = ((FieldMapping)object).getSql();
            ClassMapping classMapping2 = this._eng.getClassMapping(((FieldMapping)object).getType());
            if (sql2 == null) {
                if (classMapping2 != null) {
                    Object object5;
                    object4 = classMapping2.getFieldMapping();
                    object3 = classMapping2.getMapTo();
                    if (object3 == null) {
                        throw new DTXException("dtx.NoRelatedMapTo");
                    }
                    object2 = ((MapTo)object3).getTable();
                    string4 = null;
                    String string5 = null;
                    int n3 = 0;
                    while (n3 < ((FieldMapping[])object4).length) {
                        String string6;
                        object5 = object4[n3].getSql();
                        if (object5 != null && (string6 = object4[n3].getType()) != null && string6.equals(classMapping.getName())) {
                            string5 = ((Sql)object5).getName()[0];
                        }
                        ++n3;
                    }
                    if (string5 != null) {
                        queryExpression.addOuterJoin(string, string3, (String)object2, string5);
                        object5 = new DTXClassDescriptor(classMapping2);
                        int n4 = 0;
                        while (n4 < ((FieldMapping[])object4).length) {
                            FieldMapping fieldMapping2 = object4[n4];
                            Sql sql3 = object4[n4].getSql();
                            if (sql3 != null) {
                                String string7 = sql3.getName()[0];
                                if (string7 == null) {
                                    string7 = object4[n4].getName();
                                }
                                String string8 = String.valueOf(object2) + "." + string7;
                                BindXml bindXml = object4[n4].getBindXml();
                                String string9 = "element";
                                if (bindXml != null) {
                                    string9 = bindXml.getNode().toString();
                                }
                                if (!string7.equals(string5)) {
                                    queryExpression.addColumn((String)object2, string7);
                                    this._cols.put(String.valueOf(object2) + "." + string7, new Integer(++this._lastCol));
                                    if (string9.equalsIgnoreCase("attribute")) {
                                        ((DTXClassDescriptor)object5).addAttr(string8, fieldMapping2);
                                    } else if (string9.equalsIgnoreCase("element")) {
                                        ((DTXClassDescriptor)object5).addSimpleElement(string8, fieldMapping2);
                                    } else if (string9.equalsIgnoreCase("text")) {
                                        ((DTXClassDescriptor)object5).setTextCol(string8, fieldMapping2);
                                    }
                                }
                                if (fieldMapping2.getName().equals(classMapping2.getIdentity())) {
                                    this._ids.add(String.valueOf(object2) + "." + string7);
                                    dTXClassDescriptor.addContained(String.valueOf(object2) + "." + string7, classMapping2);
                                    this._classes.put(String.valueOf(object2) + "." + string7, object5);
                                }
                            }
                            ++n4;
                        }
                    }
                }
            } else {
                object4 = sql2.getName()[0];
                if (object4 == null) {
                    object4 = fieldMappingArray[n2].getName();
                }
                object3 = String.valueOf(string) + "." + (String)object4;
                object2 = ((FieldMapping)object).getBindXml();
                string4 = "element";
                if (object2 != null) {
                    string4 = ((BindXml)object2).getNode().toString();
                }
                if (string4.equalsIgnoreCase("attribute")) {
                    dTXClassDescriptor.addAttr((String)object3, (FieldMapping)object);
                } else if (string4.equalsIgnoreCase("element")) {
                    dTXClassDescriptor.addSimpleElement((String)object3, (FieldMapping)object);
                } else if (string4.equalsIgnoreCase("text")) {
                    dTXClassDescriptor.setTextCol((String)object3, (FieldMapping)object);
                }
                if (classMapping2 == null || sql2.getManyTable() == null) {
                    queryExpression.addColumn(string, (String)object4);
                    this._cols.put(object3, new Integer(++this._lastCol));
                } else {
                    queryExpression.addColumn(sql2.getManyTable(), (String)object4);
                    this._cols.put(object3, new Integer(++this._lastCol));
                    queryExpression.addOuterJoin(string, string3, sql2.getManyTable(), sql2.getManyKey()[0]);
                }
            }
            ++n2;
        }
    }

    protected String parseOQL(String string) throws DTXException {
        try {
            this._ids = new ArrayList();
            this._cols = new HashMap();
            this._classes = new HashMap();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.hasMoreTokens() || !stringTokenizer.nextToken().equalsIgnoreCase("SELECT")) {
                throw new DTXException("Query must start with SELECT");
            }
            if (!stringTokenizer.hasMoreTokens()) {
                throw new DTXException("Missing object name");
            }
            this._objName = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens() || !stringTokenizer.nextToken().equalsIgnoreCase("FROM")) {
                throw new DTXException("Object must be followed by FROM");
            }
            if (!stringTokenizer.hasMoreTokens()) {
                throw new DTXException("Missing object type");
            }
            this._objType = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                throw new DTXException("Missing object name");
            }
            if (!this._objName.equals(stringTokenizer.nextToken())) {
                throw new DTXException("Object name not same in SELECT and FROM");
            }
            if (this._logWriter != null) {
                this._logWriter.println("Querying " + this._objName + " of type " + this._objType);
            }
            this._clsMapping = this._eng.getClassMapping(this._objType);
            if (this._clsMapping == null) {
                throw new DTXException("dtx.NoClassDescription: " + this._objType);
            }
            PersistenceFactory persistenceFactory = this._eng.getFactory();
            if (persistenceFactory == null) {
                throw new DTXException("dtx.NoFactory");
            }
            QueryExpression queryExpression = persistenceFactory.getQueryExpression();
            if (queryExpression == null) {
                throw new DTXException("dtx.NoQueryExpression");
            }
            this.initQuery(this._clsMapping, queryExpression);
            if (stringTokenizer.hasMoreTokens()) {
                if (!stringTokenizer.nextToken().equalsIgnoreCase("WHERE")) {
                    throw new DTXException("Missing WHERE clause");
                }
                this.addField(this._clsMapping, stringTokenizer, queryExpression);
                while (stringTokenizer.hasMoreTokens()) {
                    if (!stringTokenizer.nextToken().equals("AND")) {
                        throw new QueryException("Only AND supported in WHERE clause");
                    }
                    this.addField(this._clsMapping, stringTokenizer, queryExpression);
                }
            }
            String string2 = queryExpression.getStatement(false);
            string2 = String.valueOf(string2) + " ORDER BY ";
            Iterator iterator = ((AbstractList)this._ids).iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                string2 = String.valueOf(string2) + " " + string3;
                if (!iterator.hasNext()) continue;
                string2 = String.valueOf(string2) + ",";
            }
            if (this._logWriter != null) {
                this._logWriter.println("SQL: " + string2);
            }
            return string2;
        }
        catch (Exception exception) {
            if (this._logWriter != null) {
                exception.printStackTrace(this._logWriter);
            }
            throw new DTXException(exception);
        }
    }

    void prepare(String string) throws DTXException {
        try {
            String string2 = this.parseOQL(string);
            Connection connection = this._eng.getConnection();
            this._stmt = connection.prepareStatement(string2);
        }
        catch (SQLException sQLException) {
            throw new DTXException(sQLException);
        }
    }

    void setEngine(DTXEngine dTXEngine) {
        this._eng = dTXEngine;
    }

    public void setHandler(DocumentHandler documentHandler) {
        this._handler = documentHandler;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this._logWriter = printWriter;
    }
}

