/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.om;

import java.util.ArrayList;
import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.om.DateKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.StringKey;

public class ComboKey
extends ObjectKey {
    public static final char SEPARATOR = ':';
    public static final String SEPARATOR_STRING = ":";
    private SimpleKey[] key;

    public ComboKey() {
    }

    public ComboKey(SimpleKey[] keys) {
        this.setValue(keys);
    }

    public ComboKey(String[] keys) {
        this.setValue(keys);
    }

    public ComboKey(String keys) {
        this.setValue(keys);
    }

    public void setValue(SimpleKey[] keys) {
        this.key = keys;
    }

    public void setValue(String[] keys) {
        this.key = new SimpleKey[keys.length];
        int i = 0;
        while (i < keys.length) {
            this.key[i] = new StringKey(keys[i]);
            ++i;
        }
    }

    public void setValue(String keys) {
        int startPtr = 0;
        int indexOfSep = keys.indexOf(58);
        ArrayList<NumberKey> tmpKeys = new ArrayList<NumberKey>();
        while (indexOfSep != -1) {
            if (indexOfSep == startPtr) {
                tmpKeys.add(null);
            } else {
                char keyType = keys.charAt(startPtr);
                String keyString = keys.substring(startPtr + 1, indexOfSep);
                SimpleKey newKey = null;
                switch (keyType) {
                    case 'N': {
                        newKey = new NumberKey(keyString);
                        break;
                    }
                    case 'S': {
                        newKey = new StringKey(keyString);
                        break;
                    }
                    case 'D': {
                        try {
                            newKey = new DateKey(keyString);
                        }
                        catch (NumberFormatException nfe) {
                            newKey = new DateKey();
                        }
                        break;
                    }
                }
                tmpKeys.add((NumberKey)newKey);
            }
            startPtr = indexOfSep + 1;
            indexOfSep = keys.indexOf(58, startPtr);
        }
        this.key = new SimpleKey[tmpKeys.size()];
        int i = 0;
        while (i < this.key.length) {
            this.key[i] = (SimpleKey)tmpKeys.get(i);
            ++i;
        }
    }

    public void setValue(ComboKey keys) {
        this.setValue((SimpleKey[])keys.getValue());
    }

    public Object getValue() {
        return this.key;
    }

    public boolean equals(Object keyObj) {
        boolean isEqual = false;
        if (this.key != null) {
            isEqual = true;
            SimpleKey[] keys = this.key;
            int i = 0;
            while (i < keys.length && isEqual) {
                isEqual &= keys[i] != null && keys[i].getValue() != null;
                ++i;
            }
            isEqual &= this.looseEquals(keyObj);
        }
        return isEqual;
    }

    public boolean looseEquals(Object keyObj) {
        boolean isEqual;
        block2: {
            block4: {
                block3: {
                    isEqual = false;
                    if (this.key == null) break block2;
                    if (!(keyObj instanceof String)) break block3;
                    isEqual = this.toString().equals(keyObj);
                    break block2;
                }
                if (!(keyObj instanceof ComboKey)) break block4;
                SimpleKey[] keys1 = this.key;
                SimpleKey[] obj = (SimpleKey[])((ComboKey)keyObj).getValue();
                SimpleKey[] keys2 = obj;
                isEqual = keys1.length == keys2.length;
                int i = 0;
                while (i < keys1.length && isEqual) {
                    isEqual &= ObjectUtils.equals((Object)keys1[i], (Object)keys2[i]);
                    ++i;
                }
                break block2;
            }
            if (!(keyObj instanceof SimpleKey[]) || !(this.key instanceof SimpleKey[])) break block2;
            SimpleKey[] keys1 = this.key;
            SimpleKey[] keys2 = (SimpleKey[])keyObj;
            isEqual = keys1.length == keys2.length;
            int i = 0;
            while (i < keys1.length && isEqual) {
                isEqual &= ObjectUtils.equals((Object)keys1[i], (Object)keys2[i]);
                ++i;
            }
        }
        return isEqual;
    }

    public void appendTo(StringBuffer sb) {
        if (this.key != null) {
            SimpleKey[] keys = this.key;
            int i = 0;
            while (i < keys.length) {
                if (keys[i] != null) {
                    if (keys[i] instanceof StringKey) {
                        sb.append("S");
                    } else if (keys[i] instanceof NumberKey) {
                        sb.append("N");
                    } else if (keys[i] instanceof DateKey) {
                        sb.append("D");
                    } else {
                        sb.append("U");
                    }
                    keys[i].appendTo(sb);
                }
                sb.append(':');
                ++i;
            }
        }
    }

    public int hashCode() {
        if (this.key == null) {
            return super.hashCode();
        }
        SimpleKey sk = this.key[0];
        if (sk == null) {
            return super.hashCode();
        }
        return sk.hashCode();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        this.appendTo(sbuf);
        return sbuf.toString();
    }
}

