/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.torque.Torque;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.Database;
import org.xml.sax.Attributes;

public class AppData {
    private List dbList = new ArrayList(5);
    private Map idiosyncrasyTable = new HashMap(8);
    private String databaseType;
    private String basePropsFilePath;
    private String name;
    boolean isInitialized;

    public AppData(String databaseType, String basePropsFilePath) {
        this.basePropsFilePath = basePropsFilePath;
        this.databaseType = databaseType;
    }

    protected Properties getIdiosyncrasies(String databaseType) throws EngineException {
        Properties idiosyncrasies = (Properties)this.idiosyncrasyTable.get(databaseType);
        if (idiosyncrasies == null && this.basePropsFilePath != null && databaseType != null) {
            idiosyncrasies = new Properties();
            File propsFile = new File(this.basePropsFilePath + databaseType, "db.props");
            if (propsFile.exists()) {
                try {
                    idiosyncrasies.load(new FileInputStream(propsFile));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.idiosyncrasyTable.put(databaseType, idiosyncrasies);
            } else {
                try {
                    String path = '/' + this.basePropsFilePath + databaseType + "/db.props";
                    idiosyncrasies.load(this.getClass().getResourceAsStream(path));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (((Hashtable)idiosyncrasies).isEmpty()) {
                throw new EngineException("Database-specific properties file does not exist: " + propsFile.getAbsolutePath());
            }
        }
        return idiosyncrasies;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return StringUtils.replace((String)this.name, (String)"-schema", (String)"");
    }

    public Database getDatabase() {
        this.doFinalInitialization();
        return (Database)this.dbList.get(0);
    }

    public Database[] getDatabases() {
        this.doFinalInitialization();
        int size = this.dbList.size();
        Database[] dbs = new Database[size];
        int i = 0;
        while (i < size) {
            dbs[i] = (Database)this.dbList.get(i);
            ++i;
        }
        return dbs;
    }

    public boolean hasMultipleDatabases() {
        return this.dbList.size() > 1;
    }

    public Database getDatabase(String name) {
        this.doFinalInitialization();
        Iterator i = this.dbList.iterator();
        while (i.hasNext()) {
            Database db = (Database)i.next();
            if (!db.getName().equals(name)) continue;
            return db;
        }
        return null;
    }

    public Database addDatabase(Attributes attrib) {
        Database db = new Database();
        db.loadFromXML(attrib);
        this.addDatabase(db);
        return db;
    }

    public void addDatabase(Database db) {
        db.setAppData(this);
        if (db.getName() == null) {
            db.setName(Torque.getDefaultDB());
        }
        if (db.getDatabaseType() == null) {
            db.setDatabaseType(this.databaseType);
        }
        this.dbList.add(db);
    }

    private void doFinalInitialization() {
        if (!this.isInitialized) {
            Iterator dbs = this.dbList.iterator();
            while (dbs.hasNext()) {
                ((Database)dbs.next()).doFinalInitialization();
            }
            this.isInitialized = true;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("<app-data>\n");
        Iterator i = this.dbList.iterator();
        while (i.hasNext()) {
            result.append(i.next());
        }
        result.append("</app-data>");
        return result.toString();
    }
}

