/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Vector;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsWriter;
import org.apache.lucene.index.SegmentMergeInfo;
import org.apache.lucene.index.SegmentMergeQueue;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentTermEnum;
import org.apache.lucene.index.SegmentTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.OutputStream;
import org.apache.lucene.util.BitVector;

final class SegmentMerger {
    private Directory directory;
    private String segment;
    private Vector readers = new Vector();
    private FieldInfos fieldInfos;
    private OutputStream freqOutput = null;
    private OutputStream proxOutput = null;
    private TermInfosWriter termInfosWriter = null;
    private SegmentMergeQueue queue = null;
    private final TermInfo termInfo = new TermInfo();

    SegmentMerger(Directory dir, String name) {
        this.directory = dir;
        this.segment = name;
    }

    final void add(SegmentReader reader) {
        this.readers.addElement(reader);
    }

    final SegmentReader segmentReader(int i) {
        return (SegmentReader)this.readers.elementAt(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void merge() throws IOException {
        try {
            this.mergeFields();
            this.mergeTerms();
            this.mergeNorms();
        }
        finally {
            i = 0;
            ** while (i < this.readers.size())
        }
lbl-1000:
        // 1 sources

        {
            reader = (SegmentReader)this.readers.elementAt(i);
            reader.close();
            ++i;
            continue;
        }
lbl12:
        // 1 sources

    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeFields() throws IOException {
        this.fieldInfos = new FieldInfos();
        int i = 0;
        while (i < this.readers.size()) {
            SegmentReader reader = (SegmentReader)this.readers.elementAt(i);
            this.fieldInfos.add(reader.fieldInfos);
            ++i;
        }
        this.fieldInfos.write(this.directory, this.segment + ".fnm");
        FieldsWriter fieldsWriter = new FieldsWriter(this.directory, this.segment, this.fieldInfos);
        try {
            int i2 = 0;
            while (i2 < this.readers.size()) {
                SegmentReader reader = (SegmentReader)this.readers.elementAt(i2);
                BitVector deletedDocs = reader.deletedDocs;
                int maxDoc = reader.maxDoc();
                int j = 0;
                while (j < maxDoc) {
                    if (deletedDocs == null || !deletedDocs.get(j)) {
                        fieldsWriter.addDocument(reader.document(j));
                    }
                    ++j;
                }
                ++i2;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            fieldsWriter.close();
            throw throwable;
        }
        fieldsWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeTerms() throws IOException {
        try {
            this.freqOutput = this.directory.createFile(this.segment + ".frq");
            this.proxOutput = this.directory.createFile(this.segment + ".prx");
            this.termInfosWriter = new TermInfosWriter(this.directory, this.segment, this.fieldInfos);
            this.mergeTermInfos();
        }
        finally {
            if (this.freqOutput != null) {
                this.freqOutput.close();
            }
            if (this.proxOutput != null) {
                this.proxOutput.close();
            }
            if (this.termInfosWriter != null) {
                this.termInfosWriter.close();
            }
            if (this.queue != null) {
                this.queue.close();
            }
        }
    }

    private final void mergeTermInfos() throws IOException {
        this.queue = new SegmentMergeQueue(this.readers.size());
        int base = 0;
        int i = 0;
        while (i < this.readers.size()) {
            SegmentReader reader = (SegmentReader)this.readers.elementAt(i);
            SegmentTermEnum termEnum = (SegmentTermEnum)reader.terms();
            SegmentMergeInfo smi = new SegmentMergeInfo(base, termEnum, reader);
            base += reader.numDocs();
            if (smi.next()) {
                this.queue.put(smi);
            } else {
                smi.close();
            }
            ++i;
        }
        SegmentMergeInfo[] match = new SegmentMergeInfo[this.readers.size()];
        while (this.queue.size() > 0) {
            int matchSize = 0;
            match[matchSize++] = (SegmentMergeInfo)this.queue.pop();
            Term term = match[0].term;
            SegmentMergeInfo top = (SegmentMergeInfo)this.queue.top();
            while (top != null && term.compareTo(top.term) == 0) {
                match[matchSize++] = (SegmentMergeInfo)this.queue.pop();
                top = (SegmentMergeInfo)this.queue.top();
            }
            this.mergeTermInfo(match, matchSize);
            while (matchSize > 0) {
                SegmentMergeInfo smi;
                if ((smi = match[--matchSize]).next()) {
                    this.queue.put(smi);
                    continue;
                }
                smi.close();
            }
        }
    }

    private final void mergeTermInfo(SegmentMergeInfo[] smis, int n) throws IOException {
        long freqPointer = this.freqOutput.getFilePointer();
        long proxPointer = this.proxOutput.getFilePointer();
        int df = this.appendPostings(smis, n);
        if (df > 0) {
            this.termInfo.set(df, freqPointer, proxPointer);
            this.termInfosWriter.add(smis[0].term, this.termInfo);
        }
    }

    private final int appendPostings(SegmentMergeInfo[] smis, int n) throws IOException {
        int lastDoc = 0;
        int df = 0;
        int i = 0;
        while (i < n) {
            SegmentMergeInfo smi = smis[i];
            SegmentTermPositions postings = smi.postings;
            int base = smi.base;
            int[] docMap = smi.docMap;
            smi.termEnum.termInfo(this.termInfo);
            postings.seek(this.termInfo);
            while (postings.next()) {
                int doc = docMap == null ? base + postings.doc : base + docMap[postings.doc];
                if (doc < lastDoc) {
                    throw new IllegalStateException("docs out of order");
                }
                int docCode = doc - lastDoc << 1;
                lastDoc = doc;
                int freq = postings.freq;
                if (freq == 1) {
                    this.freqOutput.writeVInt(docCode | 1);
                } else {
                    this.freqOutput.writeVInt(docCode);
                    this.freqOutput.writeVInt(freq);
                }
                int lastPosition = 0;
                int j = 0;
                while (j < freq) {
                    int position = postings.nextPosition();
                    this.proxOutput.writeVInt(position - lastPosition);
                    lastPosition = position;
                    ++j;
                }
                ++df;
            }
            ++i;
        }
        return df;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void mergeNorms() throws IOException {
        int i = 0;
        while (i < this.fieldInfos.size()) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (fi.isIndexed) {
                Object var14_12;
                OutputStream output = this.directory.createFile(this.segment + ".f" + i);
                try {
                    int j = 0;
                    while (true) {
                        block14: {
                            Object var12_11;
                            if (j >= this.readers.size()) {
                                var14_12 = null;
                                break;
                            }
                            SegmentReader reader = (SegmentReader)this.readers.elementAt(j);
                            BitVector deletedDocs = reader.deletedDocs;
                            InputStream input = reader.normStream(fi.name);
                            int maxDoc = reader.maxDoc();
                            try {
                                int k = 0;
                                while (true) {
                                    byte norm;
                                    if (k >= maxDoc) {
                                        var12_11 = null;
                                        if (input == null) break block14;
                                        break;
                                    }
                                    byte by = norm = input != null ? input.readByte() : (byte)0;
                                    if (deletedDocs == null || !deletedDocs.get(k)) {
                                        output.writeByte(norm);
                                    }
                                    ++k;
                                }
                            }
                            catch (Throwable throwable) {
                                var12_11 = null;
                                if (input != null) {
                                    input.close();
                                }
                                throw throwable;
                            }
                            input.close();
                        }
                        ++j;
                    }
                }
                catch (Throwable throwable) {
                    var14_12 = null;
                    output.close();
                    throw throwable;
                }
                output.close();
            }
            ++i;
        }
        return;
    }
}

