/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DocumentWriter;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.OutputStream;
import org.apache.lucene.store.RAMDirectory;

public class IndexWriter {
    private Directory directory;
    private Analyzer analyzer;
    private Similarity similarity = Similarity.getDefault();
    private SegmentInfos segmentInfos = new SegmentInfos();
    private final Directory ramDirectory = new RAMDirectory();
    private Lock writeLock;
    public int maxFieldLength = 10000;
    public int mergeFactor = 10;
    public int maxMergeDocs = Integer.MAX_VALUE;
    public PrintStream infoStream = null;

    public void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public IndexWriter(String path, Analyzer a, boolean create) throws IOException {
        this(FSDirectory.getDirectory(path, create), a, create);
    }

    public IndexWriter(File path, Analyzer a, boolean create) throws IOException {
        this(FSDirectory.getDirectory(path, create), a, create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexWriter(Directory d, Analyzer a, final boolean create) throws IOException {
        this.directory = d;
        this.analyzer = a;
        Lock writeLock = this.directory.makeLock("write.lock");
        if (!writeLock.obtain()) {
            throw new IOException("Index locked for write: " + writeLock);
        }
        this.writeLock = writeLock;
        Directory directory = this.directory;
        synchronized (directory) {
            new Lock.With(this.directory.makeLock("commit.lock")){

                public Object doBody() throws IOException {
                    if (create) {
                        IndexWriter.this.segmentInfos.write(IndexWriter.this.directory);
                    } else {
                        IndexWriter.this.segmentInfos.read(IndexWriter.this.directory);
                    }
                    return null;
                }
            }.run();
        }
    }

    public synchronized void close() throws IOException {
        this.flushRamSegments();
        this.ramDirectory.close();
        this.writeLock.release();
        this.writeLock = null;
        this.directory.close();
    }

    protected void finalize() throws IOException {
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public synchronized int docCount() {
        int count = 0;
        int i = 0;
        while (i < this.segmentInfos.size()) {
            SegmentInfo si = this.segmentInfos.info(i);
            count += si.docCount;
            ++i;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(Document doc) throws IOException {
        DocumentWriter dw = new DocumentWriter(this.ramDirectory, this.analyzer, this.similarity, this.maxFieldLength);
        String segmentName = this.newSegmentName();
        dw.addDocument(segmentName, doc);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.segmentInfos.addElement(new SegmentInfo(segmentName, 1, this.ramDirectory));
            this.maybeMergeSegments();
        }
    }

    private final synchronized String newSegmentName() {
        return "_" + Integer.toString(this.segmentInfos.counter++, 36);
    }

    public synchronized void optimize() throws IOException {
        this.flushRamSegments();
        while (this.segmentInfos.size() > 1 || this.segmentInfos.size() == 1 && (SegmentReader.hasDeletions(this.segmentInfos.info(0)) || this.segmentInfos.info((int)0).dir != this.directory)) {
            int minSegment = this.segmentInfos.size() - this.mergeFactor;
            this.mergeSegments(minSegment < 0 ? 0 : minSegment);
        }
    }

    public synchronized void addIndexes(Directory[] dirs) throws IOException {
        this.optimize();
        int i = 0;
        while (i < dirs.length) {
            SegmentInfos sis = new SegmentInfos();
            sis.read(dirs[i]);
            int j = 0;
            while (j < sis.size()) {
                this.segmentInfos.addElement(sis.info(j));
                ++j;
            }
            ++i;
        }
        this.optimize();
    }

    private final void flushRamSegments() throws IOException {
        int minSegment = this.segmentInfos.size() - 1;
        int docCount = 0;
        while (minSegment >= 0 && this.segmentInfos.info((int)minSegment).dir == this.ramDirectory) {
            docCount += this.segmentInfos.info((int)minSegment).docCount;
            --minSegment;
        }
        if (minSegment < 0 || docCount + this.segmentInfos.info((int)minSegment).docCount > this.mergeFactor || this.segmentInfos.info((int)(this.segmentInfos.size() - 1)).dir != this.ramDirectory) {
            ++minSegment;
        }
        if (minSegment >= this.segmentInfos.size()) {
            return;
        }
        this.mergeSegments(minSegment);
    }

    private final void maybeMergeSegments() throws IOException {
        long targetMergeDocs = this.mergeFactor;
        while (targetMergeDocs <= (long)this.maxMergeDocs) {
            int minSegment = this.segmentInfos.size();
            int mergeDocs = 0;
            while (--minSegment >= 0) {
                SegmentInfo si = this.segmentInfos.info(minSegment);
                if ((long)si.docCount >= targetMergeDocs) break;
                mergeDocs += si.docCount;
            }
            if ((long)mergeDocs < targetMergeDocs) break;
            this.mergeSegments(minSegment + 1);
            targetMergeDocs *= (long)this.mergeFactor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeSegments(int minSegment) throws IOException {
        String mergedName = this.newSegmentName();
        int mergedDocCount = 0;
        if (this.infoStream != null) {
            this.infoStream.print("merging segments");
        }
        SegmentMerger merger = new SegmentMerger(this.directory, mergedName);
        final Vector<SegmentReader> segmentsToDelete = new Vector<SegmentReader>();
        int i = minSegment;
        while (i < this.segmentInfos.size()) {
            SegmentInfo si = this.segmentInfos.info(i);
            if (this.infoStream != null) {
                this.infoStream.print(" " + si.name + " (" + si.docCount + " docs)");
            }
            SegmentReader reader = new SegmentReader(si);
            merger.add(reader);
            if (reader.directory == this.directory || reader.directory == this.ramDirectory) {
                segmentsToDelete.addElement(reader);
            }
            mergedDocCount += si.docCount;
            ++i;
        }
        if (this.infoStream != null) {
            this.infoStream.println();
            this.infoStream.println(" into " + mergedName + " (" + mergedDocCount + " docs)");
        }
        merger.merge();
        this.segmentInfos.setSize(minSegment);
        this.segmentInfos.addElement(new SegmentInfo(mergedName, mergedDocCount, this.directory));
        Directory directory = this.directory;
        synchronized (directory) {
            new Lock.With(this.directory.makeLock("commit.lock")){

                public Object doBody() throws IOException {
                    IndexWriter.this.segmentInfos.write(IndexWriter.this.directory);
                    IndexWriter.this.deleteSegments(segmentsToDelete);
                    return null;
                }
            }.run();
        }
    }

    private final void deleteSegments(Vector segments) throws IOException {
        Vector deletable = new Vector();
        this.deleteFiles(this.readDeleteableFiles(), deletable);
        int i = 0;
        while (i < segments.size()) {
            SegmentReader reader = (SegmentReader)segments.elementAt(i);
            if (reader.directory == this.directory) {
                this.deleteFiles(reader.files(), deletable);
            } else {
                this.deleteFiles(reader.files(), reader.directory);
            }
            ++i;
        }
        this.writeDeleteableFiles(deletable);
    }

    private final void deleteFiles(Vector files, Directory directory) throws IOException {
        int i = 0;
        while (i < files.size()) {
            directory.deleteFile((String)files.elementAt(i));
            ++i;
        }
    }

    private final void deleteFiles(Vector files, Vector deletable) throws IOException {
        int i = 0;
        while (i < files.size()) {
            block4: {
                String file = (String)files.elementAt(i);
                try {
                    this.directory.deleteFile(file);
                }
                catch (IOException e) {
                    if (!this.directory.fileExists(file)) break block4;
                    if (this.infoStream != null) {
                        this.infoStream.println(e.getMessage() + "; Will re-try later.");
                    }
                    deletable.addElement(file);
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Vector readDeleteableFiles() throws IOException {
        Vector<String> result = new Vector<String>();
        if (!this.directory.fileExists("deletable")) {
            return result;
        }
        InputStream input = this.directory.openFile("deletable");
        try {
            int i = input.readInt();
            while (i > 0) {
                result.addElement(input.readString());
                --i;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            input.close();
            throw throwable;
        }
        input.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeDeleteableFiles(Vector files) throws IOException {
        OutputStream output = this.directory.createFile("deleteable.new");
        try {
            output.writeInt(files.size());
            int i = 0;
            while (i < files.size()) {
                output.writeString((String)files.elementAt(i));
                ++i;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            output.close();
            throw throwable;
        }
        output.close();
        this.directory.renameFile("deleteable.new", "deletable");
    }
}

